/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import fr.nashoba24.wolvsk.WolvSKNMS;
import fr.nashoba24.wolvsk.askyblock.WolvSKASkyBlock;
import fr.nashoba24.wolvsk.essentials.WolvSKEssentials;
import fr.nashoba24.wolvsk.guardianbeamapi.WolvSKGuardianBeamAPI;
import fr.nashoba24.wolvsk.maths.WolvSKMaths;
import fr.nashoba24.wolvsk.misc.WolvSKMisc;
import fr.nashoba24.wolvsk.playerpoints.WolvSKPlayerPoints;
import fr.nashoba24.wolvsk.pvparena.WolvSKPvpArena;
import fr.nashoba24.wolvsk.supertrails.WolvSKSuperTrails;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class WolvSK
extends JavaPlugin {
    private static WolvSK instance;
    private static SkriptAddon addonInstance;
    protected FileConfiguration config;
    public static HashMap<String, Long> cooldowns;

    public WolvSK() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public void onEnable() {
        instance = WolvSK.getInstance();
        addonInstance = WolvSK.getAddonInstance();
        this.setupConfig();
        this.register();
    }

    public void onDisable() {
    }

    public static SkriptAddon getAddonInstance() {
        if (addonInstance == null) {
            addonInstance = Skript.registerAddon((JavaPlugin)WolvSK.getInstance());
        }
        return addonInstance;
    }

    public static WolvSK getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    private void setupConfig() {
        File file = new File(instance.getDataFolder() + "/");
        if (!file.exists()) {
            file.mkdir();
        }
        this.config = this.getConfig();
        this.config.addDefault("askyblock", (Object)true);
        this.config.addDefault("essentials", (Object)true);
        this.config.addDefault("guardianbeamapi", (Object)true);
        this.config.addDefault("misc", (Object)true);
        this.config.addDefault("pvparena", (Object)true);
        this.config.addDefault("supertrails", (Object)true);
        this.config.addDefault("playerpoints", (Object)true);
        this.config.addDefault("maths", (Object)true);
        this.config.addDefault("nms", (Object)true);
        this.config.options().copyDefaults(true);
        this.saveConfig();
    }

    private void register() {
        if (!this.config.contains("askyblock") || this.config.getBoolean("askyblock")) {
            WolvSKASkyBlock.register();
        }
        if (!this.config.contains("essentials") || this.config.getBoolean("essentials")) {
            WolvSKEssentials.register();
        }
        if (!this.config.contains("guardianbeamapi") || this.config.getBoolean("guardianbeamapi")) {
            WolvSKGuardianBeamAPI.register();
        }
        if (!this.config.contains("misc") || this.config.getBoolean("misc")) {
            WolvSKMisc.register();
            this.CleanupTimer();
        }
        if (!this.config.contains("pvparena") || this.config.getBoolean("pvparena")) {
            WolvSKPvpArena.register();
        }
        if (!this.config.contains("supertrails") || this.config.getBoolean("supertrails")) {
            WolvSKSuperTrails.register();
        }
        if (!this.config.contains("playerpoints") || this.config.getBoolean("playerpoints")) {
            WolvSKPlayerPoints.register();
        }
        if (!this.config.contains("maths") || this.config.getBoolean("maths")) {
            WolvSKMaths.register();
        }
        if (!this.config.contains("nms") || this.config.getBoolean("nms")) {
            WolvSKNMS.registerNMSClasses();
        }
    }

    private void CleanupTimer() {
        Timer timer = new Timer();
        TimerTask hourlyTask = new TimerTask(){

            @Override
            public void run() {
                int i = 0;
                Iterator<Map.Entry<String, Long>> it = cooldowns.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Long> pair = it.next();
                    long value = pair.getValue();
                    if (value >= System.currentTimeMillis()) continue;
                    ++i;
                    it.remove();
                }
                if (i > 0) {
                    System.out.println("[WolvSK Hourly Memory Cleanup] " + i + " finished cooldowns cleared from memory.");
                }
            }
        };
        timer.schedule(hourlyTask, 100L, 3600000L);
    }

    static {
        cooldowns = new HashMap();
    }
}

