/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk.misc.anvilgui;

import fr.nashoba24.wolvsk.misc.anvilgui.AnvilGUI;
import fr.nashoba24.wolvsk.misc.anvilgui.IAnvilNMS;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.ChatMessage;
import net.minecraft.server.v1_15_R1.ContainerAccess;
import net.minecraft.server.v1_15_R1.ContainerAnvil;
import net.minecraft.server.v1_15_R1.Containers;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.ICrafting;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_15_R1.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AnvilNMS1_15_R1
implements IAnvilNMS {
    @Override
    public Inventory open(AnvilGUI menu) {
        EntityPlayer nmsPlayer = ((CraftPlayer)menu.getPlayer()).getHandle();
        int windowId = nmsPlayer.nextContainerCounter();
        AnvilContainer container = new AnvilContainer(nmsPlayer, menu, windowId);
        Inventory inv = container.getBukkitView().getTopInventory();
        for (int slot = 0; slot < menu.getItems().length; ++slot) {
            ItemStack item = menu.getItems()[slot];
            if (item == null) continue;
            inv.setItem(slot, item);
        }
        nmsPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(windowId, Containers.ANVIL, (IChatBaseComponent)new ChatMessage(menu.getName(), new Object[0])));
        nmsPlayer.activeContainer = container;
        nmsPlayer.activeContainer.addSlotListener((ICrafting)nmsPlayer);
        return inv;
    }

    public static class AnvilContainer
    extends ContainerAnvil {
        private AnvilGUI menu;

        public AnvilContainer(EntityPlayer human, AnvilGUI menu, int nextContainerCounter) {
            super(nextContainerCounter, human.inventory, (ContainerAccess)new AnvilGUIContainerAccess(human));
            this.menu = menu;
        }

        public boolean canUse(EntityHuman entityhuman) {
            return true;
        }

        public void a(String text) {
            this.menu.itemName = text == null ? "" : text;
            super.a(text);
        }

        static {
            try {
                Field fieldText = ContainerAnvil.class.getDeclaredField("renameText");
                fieldText.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }

        public static class AnvilGUIContainerAccess
        implements ContainerAccess {
            private EntityPlayer p;

            public AnvilGUIContainerAccess(EntityPlayer p) {
                this.p = p;
            }

            public World getWorld() {
                return this.p.world;
            }

            public BlockPosition getPosition() {
                return new BlockPosition(0, 0, 0);
            }

            public Location getLocation() {
                return new Location((org.bukkit.World)this.getWorld().getWorld(), 0.0, 0.0, 0.0);
            }

            public <T> Optional<T> a(BiFunction<World, BlockPosition, T> biFunction) {
                return Optional.empty();
            }

            public <T> T a(BiFunction<World, BlockPosition, T> bifunction, T t0) {
                return this.a(bifunction).orElse(t0);
            }

            public void a(BiConsumer<World, BlockPosition> biconsumer) {
                this.a((World world, BlockPosition blockposition) -> {
                    biconsumer.accept((World)world, (BlockPosition)blockposition);
                    return Optional.empty();
                });
            }
        }
    }
}

