/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk.misc.anvilgui;

import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_10_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_11_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_12_2_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_12_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_13_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_8_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_8_R2;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_8_R3;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_9_R1;
import fr.nashoba24.wolvsk.misc.anvilgui.AnvilNMS1_9_R2;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilGUI
implements Listener {
    public static final int SLOT_INPUT_LEFT = 0;
    public static final int SLOT_INPUT_RIGHT = 1;
    public static final int SLOT_OUTPUT = 2;
    private Player player;
    private AnvilClickHandler clickHandler;
    private ItemStack[] items;
    private Inventory inv;
    private Plugin plugin;
    private Listener listener;
    String itemName = "";

    public AnvilGUI(Plugin plugin, final Player player, final AnvilClickHandler clickHandler) {
        this.plugin = plugin;
        this.player = player;
        this.clickHandler = clickHandler;
        this.items = new ItemStack[3];
        this.listener = new Listener(){

            @EventHandler
            public void onInventoryClick(InventoryClickEvent event) {
                if (event.getInventory().equals(AnvilGUI.this.inv)) {
                    event.setCancelled(true);
                    if (event.getWhoClicked() instanceof Player) {
                        Player player2 = (Player)event.getWhoClicked();
                        ItemStack item = event.getCurrentItem();
                        int slot = event.getRawSlot();
                        if (slot == 2 && item != null) {
                            if (item.hasItemMeta()) {
                                ItemMeta meta = item.getItemMeta();
                                meta.hasDisplayName();
                            }
                            if (clickHandler != null) {
                                try {
                                    if (clickHandler.onClick(AnvilGUI.this, AnvilGUI.this.itemName)) {
                                        player2.closeInventory();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    player2.sendMessage(ChatColor.RED + "An error occurred (" + e.getClass().getSimpleName() + "): " + e.getMessage());
                                }
                            }
                        }
                    }
                }
            }

            @EventHandler
            public void onInventoryClose(InventoryCloseEvent event) {
                if (event.getPlayer().equals(player)) {
                    AnvilGUI.this.onClose();
                }
            }

            @EventHandler
            public void onPlayerQuit(PlayerQuitEvent event) {
                if (event.getPlayer().equals(player)) {
                    AnvilGUI.this.onClose();
                }
            }
        };
    }

    public Player getPlayer() {
        return this.player;
    }

    public AnvilClickHandler getClickHandler() {
        return this.clickHandler;
    }

    public AnvilGUI setInputName(String name) {
        this.setItem(0, new ItemStack(Material.PAPER), name);
        return this;
    }

    public void setOutputName(String name) {
        ItemStack item = this.inv.getItem(2);
        if (item == null && (item = this.inv.getItem(0)) == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        this.inv.setItem(2, item);
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public boolean isDead() {
        return this.player == null && this.clickHandler == null && this.items == null && this.inv == null && this.listener == null && this.plugin == null;
    }

    public AnvilGUI open() {
        block33: {
            String version;
            block32: {
                if (this.items[0] == null) {
                    this.setInputName("-");
                }
                if (!Bukkit.getVersion().contains("1.12.2")) break block32;
                this.inv = AnvilNMS1_12_2_R1.open(this);
                break block33;
            }
            switch (version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3]) {
                case "v1_8_R1": {
                    this.inv = AnvilNMS1_8_R1.open(this);
                    break;
                }
                case "v1_8_R2": {
                    this.inv = AnvilNMS1_8_R2.open(this);
                    break;
                }
                case "v1_8_R3": {
                    this.inv = AnvilNMS1_8_R3.open(this);
                    break;
                }
                case "v1_9_R1": {
                    this.inv = AnvilNMS1_9_R1.open(this);
                    break;
                }
                case "v1_9_R2": {
                    this.inv = AnvilNMS1_9_R2.open(this);
                    break;
                }
                case "v1_10_R1": {
                    this.inv = AnvilNMS1_10_R1.open(this);
                    break;
                }
                case "v1_11_R1": {
                    this.inv = AnvilNMS1_11_R1.open(this);
                    break;
                }
                case "v1_12_R1": {
                    this.inv = AnvilNMS1_12_R1.open(this);
                    break;
                }
                case "v1_13_R1": {
                    this.inv = AnvilNMS1_13_R1.open(this);
                    break;
                }
                default: {
                    Bukkit.getLogger().warning("You can't open anvil GUI because your Minecraft version is not supported!");
                }
            }
        }
        Bukkit.getPluginManager().registerEvents(this.listener, this.plugin);
        return this;
    }

    private void destroy() {
        this.player = null;
        this.clickHandler = null;
        this.items = null;
        this.inv = null;
        HandlerList.unregisterAll((Listener)this.listener);
        this.listener = null;
        this.plugin = null;
    }

    public void setItem(int slot, ItemStack item, String name) {
        if (name != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName() && meta.getDisplayName().equals(name)) {
                if (this.inv != null) {
                    return;
                }
            } else {
                meta.setDisplayName(name);
                item.setItemMeta(meta);
            }
        }
        this.items[slot] = item;
        if (slot != 2) {
            this.items[2] = item;
        }
        if (this.inv != null) {
            this.inv.setItem(slot, item);
            if (slot != 2) {
                this.inv.setItem(2, item);
            }
        }
    }

    public void onClose() {
        if (this.inv != null) {
            this.inv.clear();
        }
        this.destroy();
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public static interface AnvilClickHandler {
        public boolean onClick(AnvilGUI var1, String var2);
    }
}

