/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk.minigames;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import fr.nashoba24.wolvsk.WolvSK;
import fr.nashoba24.wolvsk.minigames.Arena;
import fr.nashoba24.wolvsk.minigames.ArenaCountdownEvent;
import fr.nashoba24.wolvsk.minigames.ArenaStartEvent;
import fr.nashoba24.wolvsk.minigames.ArenaStopEvent;
import fr.nashoba24.wolvsk.minigames.CondInArena;
import fr.nashoba24.wolvsk.minigames.CondInGame;
import fr.nashoba24.wolvsk.minigames.CondIsStarted;
import fr.nashoba24.wolvsk.minigames.EffArenaBroadcast;
import fr.nashoba24.wolvsk.minigames.EffCreateArena;
import fr.nashoba24.wolvsk.minigames.EffCreateMinigame;
import fr.nashoba24.wolvsk.minigames.EffMakeJoinArena;
import fr.nashoba24.wolvsk.minigames.EffMakeLeaveArena;
import fr.nashoba24.wolvsk.minigames.EffStartArena;
import fr.nashoba24.wolvsk.minigames.EffStopArena;
import fr.nashoba24.wolvsk.minigames.ExprAllArenas;
import fr.nashoba24.wolvsk.minigames.ExprAllMinigames;
import fr.nashoba24.wolvsk.minigames.ExprArenaByName;
import fr.nashoba24.wolvsk.minigames.ExprArenaCount;
import fr.nashoba24.wolvsk.minigames.ExprArenaCurrentCountdown;
import fr.nashoba24.wolvsk.minigames.ExprArenaLobby;
import fr.nashoba24.wolvsk.minigames.ExprArenaMax;
import fr.nashoba24.wolvsk.minigames.ExprArenaMin;
import fr.nashoba24.wolvsk.minigames.ExprArenaName;
import fr.nashoba24.wolvsk.minigames.ExprArenaOfPlayer;
import fr.nashoba24.wolvsk.minigames.ExprArenaPlayers;
import fr.nashoba24.wolvsk.minigames.ExprArenaTimer;
import fr.nashoba24.wolvsk.minigames.ExprMinigameByName;
import fr.nashoba24.wolvsk.minigames.ExprMinigameChatFormat;
import fr.nashoba24.wolvsk.minigames.ExprMinigameCommand;
import fr.nashoba24.wolvsk.minigames.ExprMinigameMessageFormat;
import fr.nashoba24.wolvsk.minigames.ExprMinigameOfArena;
import fr.nashoba24.wolvsk.minigames.ExprMinigamePlayer;
import fr.nashoba24.wolvsk.minigames.ExprMinigamePrefix;
import fr.nashoba24.wolvsk.minigames.ExprNameOfMinigame;
import fr.nashoba24.wolvsk.minigames.Minigame;
import fr.nashoba24.wolvsk.minigames.PlayerJoinArenaEvent;
import fr.nashoba24.wolvsk.minigames.PlayerLeaveArenaEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Minigames
implements Listener,
CommandExecutor {
    static ArrayList<Minigame> arr = new ArrayList();
    static HashMap<String, Minigame> map = new HashMap();
    static HashMap<String, Minigame> commands = new HashMap();
    static HashMap<String, Minigame> games = new HashMap();
    static HashMap<String, Integer> lvl = new HashMap();
    static HashMap<String, Float> exp = new HashMap();
    static HashMap<String, ItemStack[]> inv = new HashMap();
    static HashMap<String, Location> ancLoc = new HashMap();
    public static String chatFormat = "%player% > %message%";
    public static String messageFormat = "&6[%minigame%] &r&b%message%";
    static boolean init = false;
    public static String xSecsLeft = "The game will start in %secs% seconds!";
    public static String OneSecLeft = "The game will start in 1 second!";
    public static String playerJoined = "%player% joined the game!";
    public static String playerLeft = "%player% left the game!";
    public static boolean customChatFormat = true;

    public static Minigame createMinigame(String name, String command, String prefix, boolean save) {
        name = name.replaceAll(" ", "-");
        command = command.replaceAll(" ", "-");
        if (map.containsKey(name)) {
            return null;
        }
        if (!init) {
            init = true;
            Minigames.init();
        }
        Minigame mg = new Minigame(name, command.toLowerCase(), prefix);
        arr.add(mg);
        map.put(name, mg);
        commands.put(command.toLowerCase(), mg);
        if (save) {
            Minigames.save(mg);
        }
        return mg;
    }

    public static void removeMinigame(String name, boolean save) {
        if (!map.containsKey(name = name.replaceAll(" ", "-"))) {
            return;
        }
        Minigame mg = Minigames.getByName(name);
        Arena[] arenaArray = mg.getArenas();
        int n = arenaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Arena a = arenaArray[n2];
            Minigames.stop(mg, a);
            ++n2;
        }
        arr.remove(name);
        commands.remove(mg.getCommand());
        if (save) {
            Minigames.createFolder();
            File file = new File(WolvSK.getInstance().getDataFolder() + "/minigames.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (config.isSet(mg.getName())) {
                config.set(mg.getName(), null);
            }
            try {
                config.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Minigame getByName(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return null;
    }

    public static Minigame[] getAllMinigames() {
        if (arr.size() == 0) {
            return new Minigame[0];
        }
        Minigame[] list = new Minigame[arr.size()];
        list = arr.toArray(list);
        return list;
    }

    public static boolean start(Minigame mg, Arena arena, boolean force) {
        if (!force) {
            if (arena.playersCount() >= arena.getMin()) {
                if (arena.getMinigame() == mg) {
                    arena.setStarted(true);
                    Player[] playerArray = arena.getAllPlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player p = playerArray[n2];
                        p.setLevel(0);
                        p.setExp(0.0f);
                        ++n2;
                    }
                    WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new ArenaStartEvent(mg, arena));
                    arena.updateSigns();
                    return true;
                }
                return false;
            }
            return false;
        }
        if (arena.getMinigame() == mg) {
            arena.setStarted(true);
            WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new ArenaStartEvent(mg, arena));
            arena.updateSigns();
            return true;
        }
        return false;
    }

    public static boolean stop(Minigame mg, Arena arena) {
        if (arena.getMinigame() == mg) {
            Player[] list;
            arena.setStarted(false);
            Player[] playerArray = list = arena.getAllPlayers();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                Minigames.leave(p, true, false, null);
                ++n2;
            }
            WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new ArenaStopEvent(mg, arena));
            arena.updateSigns();
            return true;
        }
        return false;
    }

    public static boolean join(Player p, Minigame mg, Arena arena, boolean message) {
        if (arena.getMinigame() != mg) {
            return false;
        }
        if (Minigames.inGame(p)) {
            if (message) {
                p.sendMessage(Minigames.getMessage("You are already in an arena!", mg.getPrefix(), true));
            }
            return false;
        }
        if (arena.isStarted()) {
            if (message) {
                p.sendMessage(Minigames.getMessage("This arena has started!", mg.getPrefix(), true));
            }
            return false;
        }
        if (arena.playersCount() >= arena.getMax()) {
            Player pl;
            if (!p.hasPermission("wolvsk.vip.kick")) {
                if (message) {
                    p.sendMessage(Minigames.getMessage("This arena is full!", mg.getPrefix(), true));
                }
                return false;
            }
            Player[] list = arena.getAllPlayers();
            ArrayList<Player> list2 = new ArrayList<Player>();
            Player[] playerArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                pl = playerArray[n2];
                if (pl.hasPermission("wolvsk.vip.kick")) {
                    list2.add(pl);
                }
                ++n2;
            }
            if (list2.size() > 0) {
                Collections.shuffle(list2);
                pl = (Player)list2.get(0);
                Minigames.leave(pl, true, false, null);
            } else {
                if (message) {
                    p.sendMessage(Minigames.getMessage("You can't join this arena because there is no player that can be kicked!", mg.getPrefix(), true));
                }
                return false;
            }
        }
        mg.setArena(p, arena);
        arena.addPlayer(p);
        games.put(p.getName(), mg);
        lvl.put(p.getName(), p.getLevel());
        exp.put(p.getName(), Float.valueOf(p.getExp()));
        inv.put(p.getName(), p.getInventory().getContents());
        ancLoc.put(p.getName(), p.getLocation());
        p.getInventory().clear();
        p.updateInventory();
        if (arena.getLobby() != null) {
            Location loc = arena.getLobby();
            loc.setPitch(0.0f);
            loc.setYaw(0.0f);
            p.teleport(loc);
        }
        WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerJoinArenaEvent(mg, arena, p));
        arena.updateSigns();
        return true;
    }

    public static boolean leave(Player p, boolean force, boolean msg, String prefix) {
        if (!force) {
            if (!Minigames.inGame(p)) {
                if (msg) {
                    p.sendMessage(Minigames.getMessage("You are not in a game!", prefix, true));
                }
                return false;
            }
            if (Minigames.getMinigame(p).getArena(p).isStarted()) {
                if (msg) {
                    p.sendMessage(Minigames.getMessage("The game is started!", prefix, true));
                }
                return false;
            }
            Arena arena = Minigames.getMinigame(p).getArena(p);
            WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerLeaveArenaEvent(Minigames.getMinigame(p), Minigames.getMinigame(p).getArena(p), p));
            Minigames.getMinigame(p).getArena(p).removePlayer(p);
            Minigames.getMinigame(p).setArena(p, null);
            games.remove(p.getName());
            if (lvl.containsKey(p.getName())) {
                p.setLevel(lvl.get(p.getName()).intValue());
            }
            if (exp.containsKey(p.getName())) {
                p.setExp(exp.get(p.getName()).floatValue());
            }
            if (inv.containsKey(p.getName())) {
                p.getInventory().setContents(inv.get(p.getName()));
                p.updateInventory();
            }
            if (ancLoc.containsKey(p.getName())) {
                p.teleport(ancLoc.get(p.getName()));
            }
            arena.updateSigns();
            return true;
        }
        if (Minigames.inGame(p)) {
            Arena arena = Minigames.getMinigame(p).getArena(p);
            WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerLeaveArenaEvent(Minigames.getMinigame(p), Minigames.getMinigame(p).getArena(p), p));
            Minigames.getMinigame(p).getArena(p).removePlayer(p);
            Minigames.getMinigame(p).setArena(p, null);
            if (msg) {
                String m = playerLeft.replaceAll("%player%", p.getName()).replaceAll("%min%", arena.getMin().toString()).replaceAll("%max%", arena.getMax().toString()).replaceAll("%players count%", String.valueOf(arena.getAllPlayers().length));
                arena.broadcast(Minigames.getMessage(m, arena.getMinigame().getPrefix(), false));
            }
            games.remove(p.getName());
            if (lvl.containsKey(p.getName())) {
                p.setLevel(lvl.get(p.getName()).intValue());
            }
            if (exp.containsKey(p.getName())) {
                p.setExp(exp.get(p.getName()).floatValue());
            }
            if (inv.containsKey(p.getName())) {
                p.getInventory().setContents(inv.get(p.getName()));
                p.updateInventory();
            }
            if (ancLoc.containsKey(p.getName())) {
                p.teleport(ancLoc.get(p.getName()));
            }
            arena.updateSigns();
            return true;
        }
        return false;
    }

    public static boolean inGame(Player p) {
        return games.containsKey(p.getName());
    }

    public static Minigame getMinigame(Player p) {
        if (games.containsKey(p.getName())) {
            return games.get(p.getName());
        }
        return null;
    }

    public static void init() {
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)WolvSK.getInstance(), new Runnable(){

            @Override
            public void run() {
                Minigame[] list;
                Minigame[] minigameArray = list = Minigames.getAllMinigames();
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Arena[] list2;
                    Minigame mg = minigameArray[n2];
                    Arena[] arenaArray = list2 = mg.getArenas();
                    int n3 = list2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Arena a = arenaArray[n4];
                        if (!a.isStarted()) {
                            if (a.getAllPlayers().length != 0) {
                                a.countdown();
                            }
                        } else {
                            a.finish();
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }, 0L, 20L);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        if (ancLoc.containsKey(e.getPlayer().getName())) {
            e.getPlayer().teleport(ancLoc.get(e.getPlayer().getName()));
        }
        Minigames.leave(e.getPlayer(), true, true, null);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        if (Minigames.inGame(p)) {
            if (customChatFormat) {
                e.setCancelled(true);
                Minigames.getMinigame(p).getArena(p).chat(p, e.getMessage());
            } else {
                e.getRecipients().clear();
                for (Player pl : WolvSK.getInstance().getServer().getOnlinePlayers()) {
                    if (Minigames.getMinigame(pl) == null || !Minigames.getMinigame(pl).getArena(pl).getName().equals(Minigames.getMinigame(p).getArena(p).getName()) || !Minigames.getMinigame(pl).getCommand().equals(Minigames.getMinigame(p).getCommand())) continue;
                    e.getRecipients().add(pl);
                }
            }
            System.out.println("[Arena: " + Minigames.getMinigame(p).getArena(p).getName() + ", Minigame: " + Minigames.getMinigame(p).getName() + "] " + p.getName() + " > " + e.getMessage());
        } else {
            for (Player pl : WolvSK.getInstance().getServer().getOnlinePlayers()) {
                if (!Minigames.inGame(pl)) continue;
                e.getRecipients().remove(pl);
            }
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        if (Minigames.inGame(e.getPlayer()) && !Minigames.getMinigame(e.getPlayer()).getArena(e.getPlayer()).isStarted()) {
            e.setCancelled(true);
        }
        if (!(e.isCancelled() || e.getBlock().getType() != Material.WALL_SIGN && e.getBlock().getType() != Material.SIGN_POST)) {
            Sign sign = (Sign)e.getBlock().getState();
            Player p = e.getPlayer();
            if (sign.getLine(0).startsWith(ChatColor.GREEN + "[") && sign.getLine(0).endsWith("]")) {
                Minigame mg = null;
                Minigame[] minigameArray = Minigames.getAllMinigames();
                int n = minigameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Minigame m = minigameArray[n2];
                    if (sign.getLine(0).equals(ChatColor.GREEN + "[" + m.getPrefix() + "]")) {
                        mg = m;
                        break;
                    }
                    ++n2;
                }
                if (mg == null) {
                    return;
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".admin") || p.hasPermission("wolvsk." + mg.getName() + ".sign")) {
                    Arena a = null;
                    Arena[] arenaArray = mg.getArenas();
                    int n3 = arenaArray.length;
                    n = 0;
                    while (n < n3) {
                        Arena a2 = arenaArray[n];
                        if (sign.getLine(1).equals(a2.getName())) {
                            a = a2;
                            break;
                        }
                        ++n;
                    }
                    if (a == null) {
                        return;
                    }
                    a.removeSign(e.getBlock(), true);
                } else {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        if (Minigames.inGame(e.getPlayer()) && !Minigames.getMinigame(e.getPlayer()).getArena(e.getPlayer()).isStarted()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        Player p;
        if (e.getEntity() instanceof Player && Minigames.inGame(p = (Player)e.getEntity()) && !Minigames.getMinigame(p).getArena(p).isStarted()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        Minigame[] minigameArray = Minigames.getAllMinigames();
        int n = minigameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Minigame mg = minigameArray[n2];
            if (e.getLine(0).equalsIgnoreCase("[" + mg.getPrefix() + "]") && (e.getPlayer().hasPermission("wolvsk." + mg.getName() + ".admin") || e.getPlayer().hasPermission("wolvsk." + mg.getName() + ".sign"))) {
                Arena[] arenaArray = mg.getArenas();
                int n3 = arenaArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Arena a = arenaArray[n4];
                    if (e.getLine(1).equalsIgnoreCase(a.getName())) {
                        e.setLine(0, ChatColor.GREEN + "[" + mg.getPrefix() + "]");
                        e.setLine(1, a.getName());
                        a.addSign(e.getBlock(), true);
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent e) {
        if (Minigames.inGame(e.getPlayer()) && !Minigames.getMinigame(e.getPlayer()).getArena(e.getPlayer()).isStarted()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Player p;
        if (e.getDamager() instanceof Player && Minigames.inGame(p = (Player)e.getDamager()) && !Minigames.getMinigame(p).getArena(p).isStarted()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHungerChange(FoodLevelChangeEvent e) {
        if (Minigames.inGame((Player)e.getEntity()) && !Minigames.getMinigame((Player)e.getEntity()).getArena((Player)e.getEntity()).isStarted()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (Minigames.inGame(e.getPlayer()) && !Minigames.getMinigame(e.getPlayer()).getArena(e.getPlayer()).isStarted()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && e.getClickedBlock().getState() instanceof Sign) {
            Sign sign = (Sign)e.getClickedBlock().getState();
            Minigame[] minigameArray = Minigames.getAllMinigames();
            int n = minigameArray.length;
            int n2 = 0;
            while (n2 < n) {
                Minigame mg = minigameArray[n2];
                if (sign.getLine(0).equals(ChatColor.GREEN + "[" + mg.getPrefix() + "]") && mg.getArena(sign.getLine(1), false) != null && sign.getLine(3).equals(ChatColor.GREEN + "join")) {
                    if (mg.getArena(sign.getLine(1), false).getLobby() == null) {
                        e.getPlayer().sendMessage(Minigames.getMessage("The arena " + ChatColor.DARK_RED + sign.getLine(1) + ChatColor.RED + " is not ready to be used!", mg.getPrefix(), true));
                        return;
                    }
                    boolean success = Minigames.join(e.getPlayer(), mg, mg.getArena(sign.getLine(1), false), true);
                    if (success) {
                        String m = playerJoined.replaceAll("%player%", e.getPlayer().getName()).replaceAll("%min%", mg.getArena(sign.getLine(1), false).getMin().toString()).replaceAll("%max%", mg.getArena(sign.getLine(1), false).getMax().toString()).replaceAll("%players count%", String.valueOf(mg.getArena(sign.getLine(1), false).getAllPlayers().length));
                        mg.getArena(sign.getLine(1), false).broadcast(Minigames.getMessage(m, mg.getPrefix(), false));
                    }
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        String[] list = e.getMessage().split(" ");
        Player p = e.getPlayer();
        if (commands.containsKey(list[0].replaceFirst("/", "").toLowerCase())) {
            e.setCancelled(true);
            String cmd = list[0].replaceFirst("/", "");
            String[] args = new String[list.length - 1];
            Integer i = 0;
            boolean first = true;
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!first) {
                    args[i.intValue()] = s;
                    i = i + 1;
                } else {
                    first = false;
                }
                ++n2;
            }
            Minigame mg = commands.get(cmd);
            if (args.length == 0) {
                p.sendMessage(ChatColor.AQUA + "----- " + mg.getFullPrefix() + ChatColor.RESET + ChatColor.AQUA + " -----");
                if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".leave") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " leave");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setlobby <arena>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".setmin") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmin <arena> <min>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".setmax") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmax <arena> <max>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".list") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " list");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".remove") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " remove <arena>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".settimer") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " settimer <arena> <seconds>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".start") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " start <arena>");
                }
                if (p.hasPermission("wolvsk." + mg.getName() + ".stop") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " stop <arena>");
                }
                p.sendMessage(ChatColor.AQUA + "---------------");
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("leave")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".leave") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        boolean s;
                        Arena a = null;
                        if (Minigames.getMinigame(p) != null) {
                            a = Minigames.getMinigame(p).getArena(p);
                        }
                        if (s = Minigames.leave(p, false, true, mg.getPrefix())) {
                            p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] You left the game!");
                            String m = playerLeft.replaceAll("%player%", e.getPlayer().getName()).replaceAll("%min%", a.getMin().toString()).replaceAll("%max%", a.getMax().toString()).replaceAll("%players count%", String.valueOf(a.getAllPlayers().length));
                            a.broadcast(Minigames.getMessage(m, mg.getPrefix(), false));
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("join")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("create")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setlobby")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setlobby <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setmin")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmin") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmin <arena> <min>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setmax")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmax") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmax <arena> <max>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("settimer")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".settimer") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " settimer <arena> <seconds>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("list")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".list") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        Arena[] l = mg.getArenas();
                        ArrayList<String> f = new ArrayList<String>();
                        Arena[] arenaArray = l;
                        int n3 = l.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Arena a = arenaArray[n4];
                            f.add(a.getName());
                            ++n4;
                        }
                        p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] All arenas availables: " + ChatColor.GOLD + String.join((CharSequence)(ChatColor.GREEN + ", " + ChatColor.GOLD), f));
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".remove") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " remove <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("start")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".start") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " start <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("stop")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".start") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " stop <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("help")) {
                    p.sendMessage(ChatColor.AQUA + "----- " + mg.getFullPrefix() + ChatColor.RESET + ChatColor.AQUA + " -----");
                    if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".leave") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " leave");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setlobby <arena>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmin") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmin <arena> <min>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmax") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmax <arena> <min>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".list") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " list");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".remove") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " remove <arena>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".settimer") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " settimer <arena> <seconds>");
                    }
                } else {
                    p.sendMessage(ChatColor.AQUA + "----- " + mg.getFullPrefix() + ChatColor.RESET + ChatColor.AQUA + " -----");
                    if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".leave") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " leave");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setlobby <arena>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmin") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmin <arena> <min>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmax") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmax <arena> <min>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".list") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " list");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".remove") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " remove <arena>");
                    }
                    if (p.hasPermission("wolvsk." + mg.getName() + ".settimer") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " settimer <arena> <seconds>");
                    }
                }
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("join")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        if (!Minigames.inGame(p)) {
                            if (mg.getArena(args[1], true) == null) {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                                return;
                            }
                            if (mg.getArena(args[1], true).getLobby() == null) {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + ChatColor.DARK_RED + args[1] + ChatColor.RED + " is not ready to be used!");
                                return;
                            }
                            boolean success = Minigames.join(p, mg, mg.getArena(args[1], true), true);
                            if (success) {
                                String m = playerJoined.replaceAll("%player%", e.getPlayer().getName()).replaceAll("%min%", mg.getArena(args[1], true).getMin().toString()).replaceAll("%max%", mg.getArena(args[1], true).getMax().toString()).replaceAll("%players count%", String.valueOf(mg.getArena(args[1], true).getAllPlayers().length));
                                mg.getArena(args[1], true).broadcast(Minigames.getMessage(m, mg.getPrefix(), false));
                            }
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("create")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".remove") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            mg.removeArena(mg.getArena(args[1], true), true);
                            p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] The arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " has been removed!");
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setlobby")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            mg.getArena(args[1], true).setLobby(p.getLocation(), true);
                            p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] The lobby of the arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " has been set to your location!");
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setmin")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmin") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmin <arena> <min>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setmax")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmax") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setmax <arena> <min>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("settimer")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".settimer") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " settimer <arena> <seconds>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("start")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".start") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            Minigames.start(mg, mg.getArena(args[1], true), true);
                            p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] You forced the starting of the arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + "!");
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("stop")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".stop") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            Minigames.stop(mg, mg.getArena(args[1], true));
                            p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] You stopped the arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + "!");
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("join")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("create")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setlobby")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setlobby <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setmin")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmin") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            if (Minigames.isInteger(args[2])) {
                                Integer min = Integer.parseInt(args[2]);
                                if (mg.getArena(args[1], true).getMax() >= min) {
                                    mg.getArena(args[1], true).setMin(min, true);
                                    p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] The minimum of player of the arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " is now " + ChatColor.DARK_GREEN + min + ChatColor.GREEN + "!");
                                } else {
                                    p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The minimum of player cannot be greater than the maximum of player");
                                }
                            } else {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The minimum of player must be an integer!");
                            }
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setmax")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setmax") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            if (Minigames.isInteger(args[2])) {
                                Integer max = Integer.parseInt(args[2]);
                                if (max >= mg.getArena(args[1], true).getMin()) {
                                    mg.getArena(args[1], true).setMax(max, true);
                                    p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] The maximum of player of the arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " is now " + ChatColor.DARK_GREEN + max + ChatColor.GREEN + "!");
                                } else {
                                    p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The maximum of player cannot be smaller than the minimum of player");
                                }
                            } else {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The maximum of player must be an integer!");
                            }
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("settimer")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".settimer") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) != null) {
                            if (Minigames.isInteger(args[2])) {
                                Integer timer = Integer.parseInt(args[2]);
                                if (timer > 0) {
                                    mg.getArena(args[1], true).setDefaultTimer(timer, true);
                                    p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] The timer of the arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " is now " + ChatColor.DARK_GREEN + timer + ChatColor.GREEN + "!");
                                } else {
                                    p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] Invalid number!");
                                }
                            } else {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The number of seconds of the timer must be an integer!");
                            }
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The arena " + args[1] + " doesn't exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                }
            } else if (args.length == 4) {
                if (args[0].equalsIgnoreCase("join")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("setlobby")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".setlobby") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " setlobby <arena>");
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                } else if (args[0].equalsIgnoreCase("create")) {
                    if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                        if (mg.getArena(args[1], true) == null) {
                            if (args[1].equalsIgnoreCase("command") || args[1].equalsIgnoreCase("prefix") || args[1].equalsIgnoreCase("name")) {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] An arena cannot be called with that name!");
                            }
                            if (Minigames.isInteger(args[2])) {
                                if (Minigames.isInteger(args[3])) {
                                    Integer min = Integer.parseInt(args[2]);
                                    Integer max = Integer.parseInt(args[3]);
                                    if (min > max) {
                                        p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The minimum of player cannot be greater than the maximum of player");
                                        return;
                                    }
                                    if (min <= 1) {
                                        p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The minimum of player must be greater than 0!");
                                        return;
                                    }
                                    mg.addArena(new Arena(mg, args[1], min, max), true);
                                    p.sendMessage(ChatColor.GREEN + "[" + mg.getPrefix() + "] The arena " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " has been created!");
                                } else {
                                    p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The maximum of player must be an integer!");
                                }
                            } else {
                                p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] The minimum of player must be an integer!");
                            }
                        } else {
                            p.sendMessage(ChatColor.RED + "[" + mg.getPrefix() + "] An arena with the name " + ChatColor.DARK_RED + args[1] + ChatColor.RED + " already exists!");
                        }
                    } else {
                        p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                    }
                }
            } else if (args[0].equalsIgnoreCase("join")) {
                if (p.hasPermission("wolvsk." + mg.getName() + ".join") || p.hasPermission("wolvsk." + mg.getName() + ".player")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " join <arena>");
                } else {
                    p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                }
            } else if (args[0].equalsIgnoreCase("create")) {
                if (p.hasPermission("wolvsk." + mg.getName() + ".create") || p.hasPermission("wolvsk." + mg.getName() + ".admin")) {
                    p.sendMessage(ChatColor.GOLD + "/" + cmd + ChatColor.GREEN + " create <arena> <min> <max>");
                } else {
                    p.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
                }
            }
            return;
        }
    }

    public static boolean isInteger(String s) {
        return Minigames.isInteger(s, 10);
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void saveAll() {
        Minigame[] list;
        Minigames.createFolder();
        Minigame[] minigameArray = list = Minigames.getAllMinigames();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Minigame mg = minigameArray[n2];
            Minigames.save(mg);
            ++n2;
        }
    }

    public static void save(Minigame mg) {
        Arena[] list;
        Minigames.createFolder();
        File file = new File(WolvSK.getInstance().getDataFolder() + "/minigames.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection section = config.createSection(mg.getName());
        section.set("name", (Object)mg.getName());
        section.set("prefix", (Object)mg.getPrefix());
        section.set("command", (Object)mg.getCommand());
        Arena[] arenaArray = list = mg.getArenas();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Arena a = arenaArray[n2];
            ConfigurationSection section2 = section.createSection(a.getName());
            section2.set("name", (Object)a.getName());
            section2.set("max", (Object)a.getMax());
            section2.set("min", (Object)a.getMin());
            section2.set("timer", (Object)a.getDefaultTimer());
            if (a.getLobby() != null) {
                section2.set("lobby.x", (Object)a.getLobby().getBlockX());
                section2.set("lobby.y", (Object)a.getLobby().getBlockY());
                section2.set("lobby.z", (Object)a.getLobby().getBlockZ());
                section2.set("lobby.world", (Object)a.getLobby().getWorld().getName());
            }
            Integer block = 0;
            Block[] blockArray = a.getAllSigns();
            int n3 = blockArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Block b = blockArray[n4];
                section2.set("signs." + block + ".x", (Object)b.getX());
                section2.set("signs." + block + ".y", (Object)b.getY());
                section2.set("signs." + block + ".z", (Object)b.getZ());
                section2.set("signs." + block + ".world", (Object)b.getWorld().getName());
                block = block + 1;
                ++n4;
            }
            ++n2;
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        YamlConfiguration config;
        File file = new File(WolvSK.getInstance().getDataFolder() + "/mg-settings.yml");
        if (file.exists()) {
            config = YamlConfiguration.loadConfiguration((File)file);
            if (config.isSet("custom-chat-format")) {
                customChatFormat = config.getBoolean("custom-chat-format");
            }
            if (config.isSet("chat-format")) {
                chatFormat = config.getString("chat-format");
            }
            if (config.isSet("message-format")) {
                messageFormat = config.getString("message-format");
            }
            if (config.isSet("messages")) {
                ConfigurationSection sect = config.getConfigurationSection("messages");
                if (sect.isSet("start-in-x-seconds")) {
                    xSecsLeft = sect.getString("start-in-x-seconds");
                }
                if (sect.isSet("start-in-1-second")) {
                    OneSecLeft = sect.getString("start-in-1-second");
                }
                if (sect.isSet("player-joined")) {
                    playerJoined = sect.getString("player-joined");
                }
                if (sect.isSet("player-left")) {
                    playerLeft = sect.getString("player-left");
                }
            }
        } else {
            Minigames.saveFormats();
        }
        if ((file = new File(WolvSK.getInstance().getDataFolder() + "/minigames.yml")).exists()) {
            config = YamlConfiguration.loadConfiguration((File)file);
            Set mgs = config.getKeys(false);
            for (String mg : mgs) {
                ConfigurationSection section = config.getConfigurationSection(mg);
                if (!section.isSet("name") || !section.isSet("prefix") || !section.isSet("command")) continue;
                Minigame minigame = Minigames.createMinigame(section.getString("name"), section.getString("command"), section.getString("prefix"), false);
                Set arenas = section.getKeys(false);
                for (String a : arenas) {
                    World w;
                    ConfigurationSection section2;
                    if (a.equals("name") || a.equals("prefix") || a.equals("command") || !(section2 = section.getConfigurationSection(a)).isSet("name") || !section2.isSet("max") || !section2.isSet("min")) continue;
                    Arena arena = new Arena(minigame, section2.getString("name"), section2.getInt("min"), section2.getInt("max"));
                    minigame.addArena(arena, false);
                    if (section2.isSet("lobby.x") && section2.isSet("lobby.y") && section2.isSet("lobby.z") && section2.isSet("lobby.world") && (w = WolvSK.getInstance().getServer().getWorld(section2.getString("lobby.world"))) != null) {
                        arena.setLobby(new Location(w, (double)section2.getInt("lobby.x"), (double)section2.getInt("lobby.y"), (double)section2.getInt("lobby.z")), false);
                    }
                    if (section2.isSet("timer")) {
                        arena.setDefaultTimer(section2.getInt("timer"), false);
                    }
                    Integer block = 0;
                    while (section2.isSet("signs." + block)) {
                        World w2;
                        if (section2.isSet("signs." + block + ".x") && section2.isSet("signs." + block + ".y") && section2.isSet("signs." + block + ".z") && section2.isSet("signs." + block + ".world") && (w2 = WolvSK.getInstance().getServer().getWorld(section2.getString("signs." + block + ".world"))) != null) {
                            arena.addSign(w2.getBlockAt(section2.getInt("signs." + block + ".x"), section2.getInt("signs." + block + ".y"), section2.getInt("signs." + block + ".z")), false);
                        }
                        block = block + 1;
                    }
                }
            }
        }
    }

    public static void registerAll() {
        Classes.registerClass((ClassInfo)new ClassInfo(Arena.class, "arena").user(new String[]{"arena"}).name("arena").parser((Parser)new Parser<Arena>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public Arena parse(String arg0, ParseContext arg1) {
                return null;
            }

            public String toString(Arena arg0, int arg1) {
                return "Minigame:" + arg0.getMinigame().getName() + "; Arena:" + arg0.getName();
            }

            public String toVariableNameString(Arena arg0) {
                return "Minigame:" + arg0.getMinigame().getName() + "; Arena:" + arg0.getName();
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(Minigame.class, "minigame").user(new String[]{"minigame"}).name("minigame").parser((Parser)new Parser<Minigame>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public Minigame parse(String arg0, ParseContext arg1) {
                return Minigames.getByName(arg0);
            }

            public String toString(Minigame arg0, int arg1) {
                return arg0.getName();
            }

            public String toVariableNameString(Minigame arg0) {
                return arg0.getName();
            }
        }));
        Skript.registerEffect(EffCreateMinigame.class, (String[])new String[]{"create[ a] (minigame|mg)[ named] %string% with (command|cmd) %string% and prefix %string%"});
        Skript.registerEffect(EffStartArena.class, (String[])new String[]{"start %arena%"});
        Skript.registerEffect(EffStopArena.class, (String[])new String[]{"stop %arena%"});
        Skript.registerEffect(EffMakeJoinArena.class, (String[])new String[]{"make %player% join %arena%"});
        Skript.registerEffect(EffMakeLeaveArena.class, (String[])new String[]{"make %player% leave[ current] arena"});
        Skript.registerEffect(EffCreateArena.class, (String[])new String[]{"create[ a[n]] arena[ named] %string% with min[imum][ player[s]] %integer%(,| and) max[imum][ player[s]] %integer% (for|in) %minigame%"});
        Skript.registerEffect(EffArenaBroadcast.class, (String[])new String[]{"broadcast [message ]%string% in %arena%"});
        Skript.registerCondition(CondInGame.class, (String[])new String[]{"%player% is in (a[n] arena|[a ]game)"});
        Skript.registerCondition(CondInArena.class, (String[])new String[]{"%player% is in %arena%"});
        Skript.registerCondition(CondIsStarted.class, (String[])new String[]{"%arena% is started"});
        Skript.registerExpression(ExprMinigameByName.class, Minigame.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"minigame %string%"});
        Skript.registerExpression(ExprAllMinigames.class, Minigame.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all ]minigames"});
        Skript.registerExpression(ExprMinigamePlayer.class, Minigame.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[current ]minigame of %player%", "%player%['s] [current ]minigame"});
        Skript.registerExpression(ExprNameOfMinigame.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"name of (minigame|mg) %minigame%", "(minigame|mg) %minigame%['s] name"});
        Skript.registerExpression(ExprAllArenas.class, Arena.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all ]arenas of %minigame%", "%minigame%['s] arenas"});
        Skript.registerExpression(ExprArenaByName.class, Arena.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"arena %string% in %minigame%", "%minigame%['s] arena %string%"});
        Skript.registerExpression(ExprArenaOfPlayer.class, Arena.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[current ]arena of %player%", "%player%['s] [current ]arena"});
        Skript.registerExpression(ExprMinigameCommand.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"command of %minigame%", "%minigame%['s] command"});
        Skript.registerExpression(ExprMinigamePrefix.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"prefix of %minigame%", "%minigame%['s] prefix"});
        Skript.registerExpression(ExprArenaLobby.class, Location.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"lobby of %arena%", "%arena%['s] lobby"});
        Skript.registerExpression(ExprMinigameOfArena.class, Minigame.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"minigame of %arena%", "%arena%['s] minigame"});
        Skript.registerExpression(ExprArenaName.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"name of arena %arena%", "arena %arena%['s] name"});
        Skript.registerExpression(ExprArenaMax.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"max[imum][ of player[s]] of %arena%", "%arena%['s] max[imum][ of player[s]]"});
        Skript.registerExpression(ExprArenaMin.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"min[imum][ of player[s]] of %arena%", "%arena%['s] min[imum][ of player[s]]"});
        Skript.registerExpression(ExprArenaCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"([player ]count|number of player[s]) of %arena%", "%arena%['s] ([player ]count|number of player[s])"});
        Skript.registerExpression(ExprArenaTimer.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"default (timer|countdown) of %arena%", "%arena%['s] default (timer|countdown)"});
        Skript.registerExpression(ExprArenaPlayers.class, Player.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all ]players (in|of) %arena%"});
        Skript.registerExpression(ExprMinigameChatFormat.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"chat format of minigames"});
        Skript.registerExpression(ExprMinigameMessageFormat.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"message format of minigames"});
        Skript.registerExpression(ExprArenaCurrentCountdown.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"countdown of %arena%", "%arena%['s] countdown"});
        Skript.registerEvent((String)"Arena Start Event", SimpleEvent.class, ArenaStartEvent.class, (String[])new String[]{"arena start"});
        EventValues.registerEventValue(ArenaStartEvent.class, Arena.class, (Getter)new Getter<Arena, ArenaStartEvent>(){

            public Arena get(ArenaStartEvent e) {
                return e.getArena();
            }
        }, (int)0);
        EventValues.registerEventValue(ArenaStartEvent.class, Minigame.class, (Getter)new Getter<Minigame, ArenaStartEvent>(){

            public Minigame get(ArenaStartEvent e) {
                return e.getMinigame();
            }
        }, (int)0);
        Skript.registerEvent((String)"Arena Stop Event", SimpleEvent.class, ArenaStopEvent.class, (String[])new String[]{"arena stop"});
        EventValues.registerEventValue(ArenaStopEvent.class, Arena.class, (Getter)new Getter<Arena, ArenaStopEvent>(){

            public Arena get(ArenaStopEvent e) {
                return e.getArena();
            }
        }, (int)0);
        EventValues.registerEventValue(ArenaStopEvent.class, Minigame.class, (Getter)new Getter<Minigame, ArenaStopEvent>(){

            public Minigame get(ArenaStopEvent e) {
                return e.getMinigame();
            }
        }, (int)0);
        Skript.registerEvent((String)"Player Join Arena Event", SimpleEvent.class, PlayerJoinArenaEvent.class, (String[])new String[]{"[player ]arena join"});
        EventValues.registerEventValue(PlayerJoinArenaEvent.class, Arena.class, (Getter)new Getter<Arena, PlayerJoinArenaEvent>(){

            public Arena get(PlayerJoinArenaEvent e) {
                return e.getArena();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerJoinArenaEvent.class, Minigame.class, (Getter)new Getter<Minigame, PlayerJoinArenaEvent>(){

            public Minigame get(PlayerJoinArenaEvent e) {
                return e.getMinigame();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerJoinArenaEvent.class, Player.class, (Getter)new Getter<Player, PlayerJoinArenaEvent>(){

            public Player get(PlayerJoinArenaEvent e) {
                return e.getPlayer();
            }
        }, (int)0);
        Skript.registerEvent((String)"Player Leave Arena Event", SimpleEvent.class, PlayerLeaveArenaEvent.class, (String[])new String[]{"[player ]arena leave"});
        EventValues.registerEventValue(PlayerLeaveArenaEvent.class, Arena.class, (Getter)new Getter<Arena, PlayerLeaveArenaEvent>(){

            public Arena get(PlayerLeaveArenaEvent e) {
                return e.getArena();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerLeaveArenaEvent.class, Minigame.class, (Getter)new Getter<Minigame, PlayerLeaveArenaEvent>(){

            public Minigame get(PlayerLeaveArenaEvent e) {
                return e.getMinigame();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerLeaveArenaEvent.class, Player.class, (Getter)new Getter<Player, PlayerLeaveArenaEvent>(){

            public Player get(PlayerLeaveArenaEvent e) {
                return e.getPlayer();
            }
        }, (int)0);
        Skript.registerEvent((String)"Arena Countdown Event", SimpleEvent.class, ArenaCountdownEvent.class, (String[])new String[]{"arena (countdown|timer)[ change]"});
        EventValues.registerEventValue(ArenaCountdownEvent.class, Arena.class, (Getter)new Getter<Arena, ArenaCountdownEvent>(){

            public Arena get(ArenaCountdownEvent e) {
                return e.getArena();
            }
        }, (int)0);
        EventValues.registerEventValue(ArenaCountdownEvent.class, Minigame.class, (Getter)new Getter<Minigame, ArenaCountdownEvent>(){

            public Minigame get(ArenaCountdownEvent e) {
                return e.getMinigame();
            }
        }, (int)0);
        EventValues.registerEventValue(ArenaCountdownEvent.class, Integer.class, (Getter)new Getter<Integer, ArenaCountdownEvent>(){

            public Integer get(ArenaCountdownEvent e) {
                return e.getCountdown();
            }
        }, (int)0);
    }

    static void createFolder() {
        File file = new File(WolvSK.getInstance().getDataFolder() + "/");
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(WolvSK.getInstance().getDataFolder() + "/minigames.yml")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("minigames.admin")) {
            if (args.length == 0) {
                sender.sendMessage(ChatColor.GREEN + "------- Minigames ------");
                sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " create <minigame> <command> <prefix (underscore for spaces)>");
                sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " remove <minigame>");
                sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " list");
                sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " info <minigame>");
                sender.sendMessage(ChatColor.GREEN + "------------------------");
            } else if (args[0].equalsIgnoreCase("create")) {
                if (args.length == 4) {
                    if (Minigames.getByName(args[1]) == null) {
                        if (!commands.containsKey(args[2].toLowerCase())) {
                            Minigames.createMinigame(args[1], args[2].toLowerCase(), args[3].replaceAll("_", " "), true);
                            sender.sendMessage(ChatColor.GREEN + "[Minigames] The Minigame " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " has been succefully created!");
                        } else {
                            sender.sendMessage(ChatColor.RED + "[Minigames] The command " + ChatColor.DARK_RED + args[2] + ChatColor.RED + " already exists!");
                        }
                    } else {
                        sender.sendMessage(ChatColor.RED + "[Minigames] The Minigame " + ChatColor.DARK_RED + args[1] + ChatColor.RED + " already exists!");
                    }
                } else {
                    sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " create <minigame> <command> <prefix (underscore for spaces)>");
                }
            } else if (args[0].equalsIgnoreCase("list")) {
                if (args.length == 1) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Map.Entry<String, Minigame> entry : map.entrySet()) {
                        list.add(entry.getKey());
                    }
                    sender.sendMessage(ChatColor.GREEN + "[Minigames] List: " + ChatColor.GOLD + String.join((CharSequence)(ChatColor.GREEN + ", " + ChatColor.GOLD), list));
                } else {
                    sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " list");
                }
            } else if (args[0].equalsIgnoreCase("info")) {
                if (args.length == 2) {
                    if (map.containsKey(args[1])) {
                        Minigame mg = Minigames.getByName(args[1]);
                        sender.sendMessage(ChatColor.GREEN + "[Minigames] Name: " + ChatColor.DARK_GREEN + mg.getName() + ChatColor.GREEN + ", Command: " + ChatColor.DARK_GREEN + mg.getCommand() + ChatColor.GREEN + ", Prefix: " + ChatColor.DARK_GREEN + mg.getPrefix());
                    } else {
                        sender.sendMessage(ChatColor.RED + "[Minigames] The Minigame " + ChatColor.DARK_RED + args[1] + ChatColor.RED + " doesn't exist!");
                    }
                } else {
                    sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " info <minigame>");
                }
            } else if (args[0].equalsIgnoreCase("remove")) {
                if (args.length == 2) {
                    if (map.containsKey(args[1])) {
                        Minigames.removeMinigame(args[1], true);
                        sender.sendMessage(ChatColor.GREEN + "[Minigames] The Minigame " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " has been removed!");
                    } else {
                        sender.sendMessage(ChatColor.RED + "[Minigames] The Minigame " + ChatColor.DARK_RED + args[1] + ChatColor.RED + " doesn't exist!");
                    }
                } else {
                    sender.sendMessage(ChatColor.GOLD + "/minigames" + ChatColor.GREEN + " remove <minigame>");
                }
            } else {
                WolvSK.getInstance().getServer().dispatchCommand(sender, "minigames");
            }
        } else {
            sender.sendMessage(ChatColor.DARK_RED + "You don't have the permission to execute this command!");
        }
        return true;
    }

    public static String getMessage(String msg, String prefix, boolean error) {
        if (error) {
            return ChatColor.RED + ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)messageFormat.replaceAll("%minigame%", prefix).replaceAll("%message%", msg)));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)messageFormat.replaceAll("%minigame%", prefix).replaceAll("%message%", msg));
    }

    public static void saveFormats() {
        File file = new File(WolvSK.getInstance().getDataFolder() + "/mg-settings.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("custom-chat-format", (Object)customChatFormat);
        config.set("chat-format", (Object)chatFormat);
        config.set("message-format", (Object)messageFormat);
        ConfigurationSection sect = config.createSection("messages");
        sect.set("start-in-x-seconds", (Object)xSecsLeft);
        sect.set("start-in-1-second", (Object)OneSecLeft);
        sect.set("player-joined", (Object)playerJoined);
        sect.set("player-left", (Object)playerLeft);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

