/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk.quests;

import fr.nashoba24.wolvsk.WolvSK;
import fr.nashoba24.wolvsk.quests.Dialogue;
import fr.nashoba24.wolvsk.quests.FinishDialogueEvent;
import fr.nashoba24.wolvsk.quests.ScoreboardAPI;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class Dialogues
implements Listener {
    public static HashMap<String, Dialogue> l = new HashMap();

    public static void createDialogue(Player p, Dialogue d) {
        ScoreboardAPI scoreboard = new ScoreboardAPI("\u00a7a\u00a7lDialogue: " + d.getNpcName());
        scoreboard.blankLine();
        int i = 0;
        while (i < d.getResponses().size()) {
            String s = d.getResponse(i);
            s = i == d.selected() ? ChatColor.GREEN + "\u25b6 " + s : ChatColor.GRAY + s;
            scoreboard.add(s);
            ++i;
        }
        scoreboard.build();
        scoreboard.send(p);
        l.put(p.getName(), d);
    }

    public static void updateSel(Player p, String m) {
        Dialogue d = l.get(p.getName());
        if (d != null) {
            if (m.equals("add")) {
                d.addSel();
            } else {
                d.removeSel();
            }
        }
        Dialogues.createDialogue(p, d);
    }

    public static boolean isInDialogue(String p) {
        return l.containsKey(p);
    }

    @EventHandler
    public void onUpdateSel(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        if (Dialogues.isInDialogue(p.getName())) {
            if (e.getPreviousSlot() > e.getNewSlot()) {
                Dialogues.updateSel(p, "remove");
            } else if (e.getNewSlot() > e.getPreviousSlot()) {
                Dialogues.updateSel(p, "add");
            }
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (Dialogues.isInDialogue(e.getPlayer().getName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onChoose(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (Dialogues.isInDialogue(p.getName()) && (e.getAction() == Action.LEFT_CLICK_AIR || e.getAction() == Action.LEFT_CLICK_BLOCK)) {
            Dialogue d = l.get(p.getName());
            l.remove(p.getName());
            WolvSK.getInstance().getServer().getPluginManager().callEvent((Event)new FinishDialogueEvent(d.getResponse(d.selected()), p));
            System.out.println("Debug: " + d.getResponse(d.selected()));
        }
    }
}

