/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import twitter4j.BASE64Encoder;
import twitter4j.HttpRequest;
import twitter4j.auth.Authorization;

public class BasicAuthorization
implements Authorization,
Serializable {
    private static final long serialVersionUID = 7420629998989177351L;
    private final String userId;
    private final String password;
    private final String basic;

    public BasicAuthorization(String userId, String password) {
        this.userId = userId;
        this.password = password;
        this.basic = this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    private String encodeBasicAuthenticationString() {
        if (this.userId != null && this.password != null) {
            return "Basic " + BASE64Encoder.encode((String.valueOf(this.userId) + ":" + this.password).getBytes());
        }
        return null;
    }

    @Override
    public String getAuthorizationHeader(HttpRequest req) {
        return this.basic;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicAuthorization)) {
            return false;
        }
        BasicAuthorization that = (BasicAuthorization)o;
        return this.basic.equals(that.basic);
    }

    public int hashCode() {
        return this.basic.hashCode();
    }

    public String toString() {
        return "BasicAuthorization{userId='" + this.userId + '\'' + ", password='**********''" + '}';
    }
}

