/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public final class HttpParameter
implements Comparable<HttpParameter>,
Serializable {
    private static final long serialVersionUID = 4046908449190454692L;
    private String name = null;
    private String value = null;
    private File file = null;
    private InputStream fileBody = null;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public HttpParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpParameter(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public HttpParameter(String name, String fileName, InputStream fileBody) {
        this.name = name;
        this.file = new File(fileName);
        this.fileBody = fileBody;
    }

    public HttpParameter(String name, int value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, long value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, boolean value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getFileBody() {
        return this.fileBody;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean hasFileBody() {
        return this.fileBody != null;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String extensions = this.file.getName();
        int index = extensions.lastIndexOf(".");
        String contentType = -1 == index ? OCTET : ((extensions = extensions.substring(extensions.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(extensions) ? GIF : ("png".equals(extensions) ? PNG : ("jpg".equals(extensions) ? JPEG : OCTET))) : (extensions.length() == 4 ? ("jpeg".equals(extensions) ? JPEG : OCTET) : OCTET));
        return contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpParameter)) {
            return false;
        }
        HttpParameter that = (HttpParameter)o;
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        if (this.fileBody != null ? !this.fileBody.equals(that.fileBody) : that.fileBody != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public static boolean containsFile(HttpParameter[] params) {
        boolean containsFile = false;
        if (params == null) {
            return false;
        }
        HttpParameter[] httpParameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            HttpParameter param = httpParameterArray[n2];
            if (param.isFile()) {
                containsFile = true;
                break;
            }
            ++n2;
        }
        return containsFile;
    }

    static boolean containsFile(List<HttpParameter> params) {
        boolean containsFile = false;
        for (HttpParameter param : params) {
            if (!param.isFile()) continue;
            containsFile = true;
            break;
        }
        return containsFile;
    }

    public static HttpParameter[] getParameterArray(String name, String value) {
        return new HttpParameter[]{new HttpParameter(name, value)};
    }

    public static HttpParameter[] getParameterArray(String name, int value) {
        return HttpParameter.getParameterArray(name, String.valueOf(value));
    }

    public static HttpParameter[] getParameterArray(String name1, String value1, String name2, String value2) {
        return new HttpParameter[]{new HttpParameter(name1, value1), new HttpParameter(name2, value2)};
    }

    public static HttpParameter[] getParameterArray(String name1, int value1, String name2, int value2) {
        return HttpParameter.getParameterArray(name1, String.valueOf(value1), name2, String.valueOf(value2));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + (this.fileBody != null ? this.fileBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PostParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", file=" + this.file + ", fileBody=" + this.fileBody + '}';
    }

    @Override
    public int compareTo(HttpParameter o) {
        int compared = this.name.compareTo(o.name);
        if (compared == 0) {
            compared = this.value.compareTo(o.value);
        }
        return compared;
    }

    public static String encodeParameters(HttpParameter[] httpParams) {
        if (httpParams == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int j = 0;
        while (j < httpParams.length) {
            if (httpParams[j].isFile()) {
                throw new IllegalArgumentException("parameter [" + httpParams[j].name + "]should be text");
            }
            if (j != 0) {
                buf.append("&");
            }
            buf.append(HttpParameter.encode(httpParams[j].name)).append("=").append(HttpParameter.encode(httpParams[j].value));
            ++j;
        }
        return buf.toString();
    }

    public static String encode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(encoded.length());
        int i = 0;
        while (i < encoded.length()) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
            } else if (focus == '+') {
                buf.append("%20");
            } else if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
            } else {
                buf.append(focus);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String decode(String value) {
        value = value.replace("%2A", "*");
        value = value.replace("%2a", "*");
        value = value.replace("%20", " ");
        String decoded = null;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public static List<HttpParameter> decodeParameters(String queryParameters) {
        ArrayList<HttpParameter> result = new ArrayList<HttpParameter>();
        String[] stringArray = queryParameters.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] parts = pair.split("=", 2);
            if (parts.length == 2) {
                String name = HttpParameter.decode(parts[0]);
                String value = HttpParameter.decode(parts[1]);
                if (!name.equals("") && !value.equals("")) {
                    result.add(new HttpParameter(name, value));
                }
            }
            ++n2;
        }
        return result;
    }
}

