/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api;

import com.github.theholywaffle.teamspeak3.api.exception.TS3CommandFailedException;
import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class CommandFuture<V>
implements Future<V> {
    private final Object monitor = new Object();
    private volatile FutureState state = FutureState.WAITING;
    private volatile V value = null;
    private volatile QueryError queryError = null;
    private volatile SuccessListener<? super V> successListener = null;
    private volatile FailureListener failureListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        while (this.state == FutureState.WAITING) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.state == FutureState.WAITING && System.currentTimeMillis() < end) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait(end - System.currentTimeMillis());
            }
        }
        if (this.state == FutureState.WAITING) {
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        boolean interrupted = false;
        while (this.state == FutureState.WAITING) {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.wait();
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        boolean interrupted = false;
        while (this.state == FutureState.WAITING && System.currentTimeMillis() < end) {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.wait(end - System.currentTimeMillis());
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (this.state == FutureState.WAITING) {
            throw new TimeoutException();
        }
    }

    @Override
    public V get() throws InterruptedException {
        this.await();
        this.checkForFailure();
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.await(timeout, unit);
        this.checkForFailure();
        return this.value;
    }

    public V getUninterruptibly() {
        this.awaitUninterruptibly();
        this.checkForFailure();
        return this.value;
    }

    public V getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        this.awaitUninterruptibly(timeout, unit);
        this.checkForFailure();
        return this.value;
    }

    private void checkForFailure() {
        if (this.state == FutureState.CANCELLED) {
            throw new CancellationException();
        }
        if (this.state == FutureState.FAILED) {
            throw new TS3CommandFailedException(this.queryError);
        }
    }

    @Override
    public boolean isDone() {
        return this.state != FutureState.WAITING;
    }

    public boolean isSuccessful() {
        return this.state == FutureState.SUCCEEDED;
    }

    @Override
    public boolean isCancelled() {
        return this.state == FutureState.CANCELLED;
    }

    public boolean isFailed() {
        return this.state == FutureState.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(V value) {
        Object object = this.monitor;
        synchronized (object) {
            block7: {
                if (!this.isDone()) break block7;
                return false;
            }
            this.state = FutureState.SUCCEEDED;
            this.value = value;
            this.monitor.notifyAll();
        }
        if (this.successListener != null) {
            try {
                this.successListener.handleSuccess(value);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fail(QueryError error) {
        Object object = this.monitor;
        synchronized (object) {
            block7: {
                if (!this.isDone()) break block7;
                return false;
            }
            this.state = FutureState.FAILED;
            this.queryError = error;
            this.monitor.notifyAll();
        }
        if (this.failureListener != null) {
            try {
                this.failureListener.handleFailure(this.queryError);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.monitor;
        synchronized (object) {
            block4: {
                if (!this.isDone()) break block4;
                return false;
            }
            this.state = FutureState.CANCELLED;
            this.monitor.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandFuture<V> onSuccess(SuccessListener<? super V> listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.successListener != null) {
                throw new IllegalStateException("Listener already set");
            }
            this.successListener = listener;
        }
        if (this.state == FutureState.SUCCEEDED) {
            listener.handleSuccess(this.value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandFuture<V> onFailure(FailureListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.failureListener != null) {
                throw new IllegalStateException("Listener already set");
            }
            this.failureListener = listener;
        }
        if (this.state == FutureState.FAILED) {
            listener.handleFailure(this.queryError);
        }
        return this;
    }

    public CommandFuture<V> forwardSuccess(final CommandFuture<? super V> otherFuture) {
        return this.onSuccess(new SuccessListener<V>(){

            @Override
            public void handleSuccess(V result) {
                otherFuture.set(result);
            }
        });
    }

    public CommandFuture<V> forwardFailure(final CommandFuture<?> otherFuture) {
        return this.onFailure(new FailureListener(){

            @Override
            public void handleFailure(QueryError error) {
                otherFuture.fail(error);
            }
        });
    }

    public void forwardResult(CommandFuture<V> otherFuture) {
        this.forwardSuccess(otherFuture).forwardFailure(otherFuture);
    }

    public static <V> CommandFuture<V> immediate(V value) {
        CommandFuture<V> future = new CommandFuture<V>();
        future.set(value);
        return future;
    }

    @SafeVarargs
    public static <F> CommandFuture<List<F>> ofAll(CommandFuture<F> ... futures) {
        return CommandFuture.ofAll(Arrays.asList(futures));
    }

    public static <F> CommandFuture<List<F>> ofAll(Collection<CommandFuture<F>> futures) {
        if (futures.isEmpty()) {
            throw new IllegalArgumentException("Requires at least 1 future");
        }
        final Object[] results = new Object[futures.size()];
        final AtomicInteger successCounter = new AtomicInteger(futures.size());
        final CommandFuture<List<F>> combined = new CommandFuture<List<F>>();
        Iterator<CommandFuture<F>> iterator = futures.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            final int index = i++;
            CommandFuture<F> future = iterator.next();
            future.forwardFailure(combined).onSuccess(new SuccessListener<F>(){

                @Override
                public void handleSuccess(F result) {
                    results[index] = result;
                    if (successCounter.decrementAndGet() == 0) {
                        combined.set(Arrays.asList(results));
                    }
                }
            });
        }
        return combined;
    }

    @SafeVarargs
    public static <F> CommandFuture<F> ofAny(CommandFuture<F> ... futures) {
        return CommandFuture.ofAny(Arrays.asList(futures));
    }

    public static <F> CommandFuture<F> ofAny(Collection<CommandFuture<F>> futures) {
        if (futures.isEmpty()) {
            throw new IllegalArgumentException("Requires at least 1 future");
        }
        final CommandFuture any = new CommandFuture();
        final AtomicInteger failureCounter = new AtomicInteger(futures.size());
        for (CommandFuture<F> future : futures) {
            future.forwardSuccess(any).onFailure(new FailureListener(){

                @Override
                public void handleFailure(QueryError error) {
                    if (failureCounter.decrementAndGet() == 0) {
                        any.fail(error);
                    }
                }
            });
        }
        return any;
    }

    public static interface FailureListener {
        public void handleFailure(QueryError var1);
    }

    private static enum FutureState {
        WAITING,
        CANCELLED,
        FAILED,
        SUCCEEDED;

    }

    public static interface SuccessListener<V> {
        public void handleSuccess(V var1);
    }
}

