/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk.minigames;

import fr.nashoba24.wolvsk.WolvSK;
import fr.nashoba24.wolvsk.minigames.Minigame;
import fr.nashoba24.wolvsk.minigames.Minigames;
import fr.nashoba24.wolvsk.minigames.TitleAPI;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Arena {
    private String arenaname;
    private Minigame game;
    private Location lobby;
    private Integer minp;
    private Integer maxp;
    private ArrayList<String> pl = new ArrayList();
    private boolean started = false;
    private Integer defaultTimer = 120;
    private Integer timer = 120;
    private ArrayList<Block> signs = new ArrayList();

    public Arena(Minigame mg, String name, Integer min, Integer max) {
        name = name.replaceAll(" ", "-");
        this.game = mg;
        this.arenaname = name;
        this.minp = min;
        this.maxp = max;
    }

    public void setLobby(Location loc, boolean save) {
        this.lobby = loc;
        if (save) {
            Minigames.save(this.getMinigame());
        }
    }

    public Location getLobby() {
        return this.lobby;
    }

    public Minigame getMinigame() {
        return this.game;
    }

    public String getName() {
        return this.arenaname;
    }

    public void setMax(Integer max, boolean save) {
        this.maxp = max;
        if (save) {
            Minigames.save(this.getMinigame());
        }
        this.updateSigns();
    }

    public void setMin(Integer min, boolean save) {
        this.minp = min;
        if (save) {
            Minigames.save(this.getMinigame());
        }
    }

    public Integer getMin() {
        return this.minp;
    }

    public Integer getMax() {
        return this.maxp;
    }

    public void addPlayer(Player p) {
        this.pl.add(p.getName());
    }

    public void removePlayer(Player p) {
        this.pl.remove(p.getName());
    }

    public Integer playersCount() {
        return this.pl.size();
    }

    public boolean isInArena(Player p) {
        return this.pl.contains(p.getName());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setDefaultTimer(Integer i, boolean save) {
        if (this.timer == this.defaultTimer) {
            this.timer = i;
            this.defaultTimer = i;
        } else {
            this.defaultTimer = i;
        }
        if (save) {
            Minigames.save(this.getMinigame());
        }
    }

    public Integer getDefaultTimer() {
        return this.defaultTimer;
    }

    public void finish() {
        if (this.isStarted() && (this.playersCount() == 0 || this.playersCount() == 1)) {
            Minigames.stop(this.getMinigame(), this);
        }
    }

    public void timer() {
        block9: {
            Player[] list;
            block8: {
                Player[] list2;
                int n;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            Player[] list3;
                                            boolean s;
                                            if (this.playersCount() < this.getMin()) break block8;
                                            this.timer = this.timer - 1;
                                            if (this.timer == 0 && !(s = Minigames.start(this.getMinigame(), this, false))) {
                                                this.timer = this.defaultTimer - 1;
                                            }
                                            Player[] playerArray = list3 = this.getAllPlayers();
                                            n = list3.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                Player p = playerArray[n2];
                                                p.setExp(this.timer.floatValue() / this.defaultTimer.floatValue());
                                                p.setLevel(this.timer.intValue());
                                                ++n2;
                                            }
                                            if (this.timer == this.defaultTimer) break block9;
                                            if (this.timer < 30) break block10;
                                            if (this.timer % 30 != 0) break block9;
                                            this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                                            break block9;
                                        }
                                        if (this.timer != 20) break block11;
                                        this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                                        break block9;
                                    }
                                    if (this.timer != 10) break block12;
                                    this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                                    break block9;
                                }
                                if (this.timer != 5) break block13;
                                this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                                Player[] playerArray = list2 = this.getAllPlayers();
                                int n3 = list2.length;
                                n = 0;
                                while (n < n3) {
                                    Player p = playerArray[n];
                                    TitleAPI.sendTitle(p, 5, 10, 5, ChatColor.GREEN + "5", "");
                                    ++n;
                                }
                                break block9;
                            }
                            if (this.timer != 4) break block14;
                            this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                            Player[] playerArray = list2 = this.getAllPlayers();
                            int n4 = list2.length;
                            n = 0;
                            while (n < n4) {
                                Player p = playerArray[n];
                                TitleAPI.sendTitle(p, 5, 10, 5, ChatColor.YELLOW + "4", "");
                                ++n;
                            }
                            break block9;
                        }
                        if (this.timer != 3) break block15;
                        this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                        Player[] playerArray = list2 = this.getAllPlayers();
                        int n5 = list2.length;
                        n = 0;
                        while (n < n5) {
                            Player p = playerArray[n];
                            TitleAPI.sendTitle(p, 5, 10, 5, ChatColor.GOLD + "3", "");
                            ++n;
                        }
                        break block9;
                    }
                    if (this.timer != 2) break block16;
                    this.broadcast(Minigames.getMessage(Minigames.xSecsLeft.replaceAll("%secs%", this.timer.toString()), this.getMinigame().getPrefix(), false));
                    Player[] playerArray = list2 = this.getAllPlayers();
                    int n6 = list2.length;
                    n = 0;
                    while (n < n6) {
                        Player p = playerArray[n];
                        TitleAPI.sendTitle(p, 5, 10, 5, ChatColor.RED + "2", "");
                        ++n;
                    }
                    break block9;
                }
                if (this.timer != 1) break block9;
                this.broadcast(Minigames.getMessage(Minigames.OneSecLeft, this.getMinigame().getPrefix(), false));
                Player[] playerArray = list2 = this.getAllPlayers();
                int n7 = list2.length;
                n = 0;
                while (n < n7) {
                    Player p = playerArray[n];
                    TitleAPI.sendTitle(p, 5, 10, 5, ChatColor.DARK_RED + "1", "");
                    ++n;
                }
                break block9;
            }
            this.timer = this.defaultTimer;
            Player[] playerArray = list = this.getAllPlayers();
            int n = list.length;
            int n8 = 0;
            while (n8 < n) {
                Player p = playerArray[n8];
                p.setExp((float)(this.timer / this.defaultTimer) - 0.01f);
                p.setLevel(this.timer.intValue());
                ++n8;
            }
        }
    }

    public Player[] getAllPlayers() {
        if (this.pl.size() == 0) {
            return new Player[0];
        }
        ArrayList<Player> arr = new ArrayList<Player>();
        for (String s : this.pl) {
            arr.add(WolvSK.getInstance().getServer().getPlayer(s));
        }
        Player[] list = new Player[arr.size()];
        list = arr.toArray(list);
        return list;
    }

    public void setStarted(boolean b) {
        this.started = b;
    }

    public void broadcast(String msg) {
        Player[] list;
        Player[] playerArray = list = this.getAllPlayers();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.sendMessage(msg);
            ++n2;
        }
    }

    public Block[] getAllSigns() {
        if (this.signs.size() == 0) {
            return new Block[0];
        }
        Block[] list = new Block[this.signs.size()];
        list = this.signs.toArray(list);
        return list;
    }

    public void addSign(Block b, boolean save) {
        this.signs.add(b);
        this.updateSigns();
        if (save) {
            Minigames.save(this.getMinigame());
        }
    }

    public void removeSign(Block b, boolean save) {
        this.signs.remove(b);
        if (save) {
            Minigames.save(this.getMinigame());
        }
    }

    public void chat(Player p, String msg) {
        Player[] list = this.getAllPlayers();
        String m = Minigames.chatFormat.replaceAll("%player%", p.getName()).replaceAll("%message%", msg).replaceAll("%minigame%", this.getMinigame().getPrefix()).replaceAll("%arena%", this.getName());
        Player[] playerArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Player pl = playerArray[n2];
            pl.sendMessage(m);
            ++n2;
        }
    }

    public void updateSigns() {
        final Arena arena = this;
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.scheduleSyncDelayedTask((Plugin)WolvSK.getInstance(), new Runnable(){

            @Override
            public void run() {
                Block[] listb;
                Block[] blockArray = listb = arena.getAllSigns();
                int n = listb.length;
                int n2 = 0;
                while (n2 < n) {
                    Block b = blockArray[n2];
                    if (b.getState() instanceof Sign) {
                        Sign sign = (Sign)b.getState();
                        if (sign.getLine(0).equalsIgnoreCase(ChatColor.GREEN + "[" + arena.getMinigame().getPrefix() + "]")) {
                            String line2 = sign.getLine(1);
                            if (arena.getMinigame().getArena(line2, false) != null) {
                                if (arena.getMinigame().getArena(line2, false) == arena) {
                                    if (!arena.isStarted()) {
                                        if (arena.playersCount() >= arena.getMin()) {
                                            sign.setLine(2, ChatColor.DARK_GREEN + arena.playersCount().toString() + "/" + arena.getMax());
                                        } else {
                                            sign.setLine(2, ChatColor.BLUE + arena.playersCount().toString() + "/" + arena.getMax());
                                        }
                                        sign.setLine(3, ChatColor.GREEN + "join");
                                    } else {
                                        sign.setLine(2, ChatColor.DARK_GREEN + arena.playersCount().toString() + "/" + arena.getMax());
                                        sign.setLine(3, ChatColor.GOLD + "started");
                                    }
                                    sign.update();
                                }
                            } else {
                                arena.removeSign(b, true);
                            }
                        } else {
                            arena.removeSign(b, true);
                        }
                    } else {
                        arena.removeSign(b, true);
                    }
                    ++n2;
                }
            }
        }, 1L);
    }
}

