/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Dispatcher;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;

final class UserStreamImpl
extends StatusStreamImpl
implements UserStream {
    UserStreamImpl(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        super(dispatcher, stream, conf);
    }

    UserStreamImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        super(dispatcher, response, conf);
    }

    @Override
    public void next(UserStreamListener listener) throws TwitterException {
        this.handleNextElement(new StreamListener[]{listener}, EMPTY);
    }

    @Override
    protected void onSender(JSONObject json, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onDirectMessage(new DirectMessageJSONImpl(json));
            ++n2;
        }
    }

    @Override
    protected void onDirectMessage(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        DirectMessage directMessage = this.asDirectMessage(json);
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onDirectMessage(directMessage);
            ++n2;
        }
    }

    @Override
    protected void onScrubGeo(JSONObject json, StreamListener[] listeners) throws TwitterException {
        logger.info("Geo-tagging deletion notice (not implemented yet): " + this.line);
    }

    @Override
    protected void onFriends(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        long[] friendIds = this.asFriendList(json);
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onFriendList(friendIds);
            ++n2;
        }
    }

    @Override
    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onFavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUnfavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    protected void onFollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onFollow(this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    protected void onUnfollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUnfollow(this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListMemberAddition(this.asUser(addedMember), this.asUser(owner), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListMemberDeletion(this.asUser(deletedMember), this.asUser(owner), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListSubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListUnsubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListCreation(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListCreation(this.asUser(source), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListUpdated(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListUpdate(this.asUser(source), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListDestroyed(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserListDeletion(this.asUser(source), this.asUserList(target));
            ++n2;
        }
    }

    @Override
    protected void onUserUpdate(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserProfileUpdate(this.asUser(source));
            ++n2;
        }
    }

    @Override
    protected void onUserSuspension(long target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserSuspension(target);
            ++n2;
        }
    }

    @Override
    protected void onUserDeletion(long target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUserDeletion(target);
            ++n2;
        }
    }

    @Override
    protected void onBlock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onBlock(this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    protected void onUnblock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onUnblock(this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    void onRetweetedRetweet(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onRetweetedRetweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    void onFavoritedRetweet(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onFavoritedRetweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    protected void onQuotedTweet(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((UserStreamListener)listener).onQuotedTweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }
}

