/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import twitter4j.ConnectionLifeCycleListener;
import twitter4j.Dispatcher;
import twitter4j.DispatcherFactory;
import twitter4j.FilterQuery;
import twitter4j.HttpClient;
import twitter4j.HttpClientFactory;
import twitter4j.HttpParameter;
import twitter4j.Logger;
import twitter4j.RawStreamListener;
import twitter4j.SiteStreamsImpl;
import twitter4j.SiteStreamsListener;
import twitter4j.Status;
import twitter4j.StatusAdapter;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamBase;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamController;
import twitter4j.StreamListener;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.StringUtil;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;
import twitter4j.UserStream;
import twitter4j.UserStreamImpl;
import twitter4j.auth.Authorization;
import twitter4j.conf.Configuration;
import twitter4j.util.function.Consumer;

class TwitterStreamImpl
extends TwitterBaseImpl
implements TwitterStream {
    private static final long serialVersionUID = 5621090317737561048L;
    private final HttpClient http;
    private static final Logger logger = Logger.getLogger(TwitterStreamImpl.class);
    private final List<ConnectionLifeCycleListener> lifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>(0);
    private TwitterStreamConsumer handler = null;
    private final String stallWarningsGetParam;
    private final HttpParameter stallWarningsParam;
    private static volatile transient Dispatcher dispatcher;
    private static int numberOfHandlers;
    private final ArrayList<StreamListener> streamListeners = new ArrayList(0);
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;
    private static int count;

    static {
        numberOfHandlers = 0;
        count = 0;
    }

    TwitterStreamImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.http = HttpClientFactory.getInstance(new StreamingReadTimeoutConfiguration(conf));
        this.http.addDefaultRequestHeader("Connection", "close");
        this.stallWarningsGetParam = "stall_warnings=" + (conf.isStallWarningsEnabled() ? "true" : "false");
        this.stallWarningsParam = new HttpParameter("stall_warnings", conf.isStallWarningsEnabled());
    }

    @Override
    public void firehose(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getFirehoseStream(count);
            }
        });
    }

    StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/firehose.json", count);
    }

    @Override
    public void links(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getLinksStream(count);
            }
        });
    }

    StatusStream getLinksStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/links.json", count);
    }

    private StatusStream getCountStream(String relativeUrl, int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(String.valueOf(this.conf.getStreamBaseURL()) + relativeUrl, new HttpParameter[]{new HttpParameter("count", String.valueOf(count)), this.stallWarningsParam}, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public void retweet() {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getRetweetStream();
            }
        });
    }

    StatusStream getRetweetStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(String.valueOf(this.conf.getStreamBaseURL()) + "statuses/retweet.json", new HttpParameter[]{this.stallWarningsParam}, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public void sample() {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getSampleStream();
            }
        });
    }

    @Override
    public void sample(final String language) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getSampleStream(language);
            }
        });
    }

    StatusStream getSampleStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.get(String.valueOf(this.conf.getStreamBaseURL()) + "statuses/sample.json?" + this.stallWarningsGetParam, null, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    StatusStream getSampleStream(String language) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.get(String.valueOf(this.conf.getStreamBaseURL()) + "statuses/sample.json?" + this.stallWarningsGetParam + "&language=" + language, null, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public void user() {
        this.user(null);
    }

    @Override
    public void user(final String[] track) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.user){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getUserStream(track);
            }
        });
    }

    UserStream getUserStream(String[] track) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
            params.add(this.stallWarningsParam);
            if (this.conf.isUserStreamRepliesAllEnabled()) {
                params.add(new HttpParameter("replies", "all"));
            }
            if (!this.conf.isUserStreamWithFollowingsEnabled()) {
                params.add(new HttpParameter("with", "user"));
            }
            if (track != null) {
                params.add(new HttpParameter("track", StringUtil.join(track)));
            }
            return new UserStreamImpl(this.getDispatcher(), this.http.post(String.valueOf(this.conf.getUserStreamBaseURL()) + "user.json", params.toArray(new HttpParameter[params.size()]), this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public StreamController site(final boolean withFollowings, final long[] follow) {
        this.ensureOAuthEnabled();
        this.ensureSiteStreamsListenerIsSet();
        final StreamController cs = new StreamController(this.http, this.auth);
        this.startHandler(new TwitterStreamConsumer(this, Mode.site){

            @Override
            public StatusStream getStream() throws TwitterException {
                try {
                    return new SiteStreamsImpl(this.getDispatcher(), this.getSiteStream(withFollowings, follow), conf, cs);
                }
                catch (IOException e) {
                    throw new TwitterException(e);
                }
            }
        });
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dispatcher getDispatcher() {
        if (dispatcher != null) return dispatcher;
        Class<TwitterStreamImpl> clazz = TwitterStreamImpl.class;
        synchronized (TwitterStreamImpl.class) {
            if (dispatcher != null) return dispatcher;
            dispatcher = new DispatcherFactory(this.conf).getInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dispatcher;
        }
    }

    InputStream getSiteStream(boolean withFollowings, long[] follow) throws TwitterException {
        this.ensureOAuthEnabled();
        return this.http.post(String.valueOf(this.conf.getSiteStreamBaseURL()) + "site.json", new HttpParameter[]{new HttpParameter("with", withFollowings ? "followings" : "user"), new HttpParameter("follow", StringUtil.join(follow)), this.stallWarningsParam}, this.auth, null).asStream();
    }

    @Override
    public void filter(final FilterQuery query) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(this, Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return this.getFilterStream(query);
            }
        });
    }

    @Override
    public void filter(String ... track) {
        this.filter(new FilterQuery().track(track));
    }

    StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(String.valueOf(this.conf.getStreamBaseURL()) + "statuses/filter.json", query.asHttpParameterArray(this.stallWarningsParam), this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    private void ensureStatusStreamListenerIsSet() {
        if (this.streamListeners.size() == 0) {
            throw new IllegalStateException("StatusListener is not set.");
        }
    }

    private void ensureSiteStreamsListenerIsSet() {
        if (this.getSiteStreamsListeners().length == 0 && this.getRawStreamListeners().length == 0) {
            throw new IllegalStateException("SiteStreamsListener is not set.");
        }
    }

    private synchronized void startHandler(TwitterStreamConsumer handler) {
        this.cleanUp();
        this.handler = handler;
        this.handler.start();
        ++numberOfHandlers;
    }

    @Override
    public synchronized void cleanUp() {
        if (this.handler != null) {
            this.handler.close();
            --numberOfHandlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this.cleanUp();
        Class<TwitterStreamImpl> clazz = TwitterStreamImpl.class;
        synchronized (TwitterStreamImpl.class) {
            if (numberOfHandlers == 0 && dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addConnectionLifeCycleListener(ConnectionLifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    @Override
    public synchronized void addListener(StreamListener listener) {
        this.streamListeners.add(listener);
        this.updateListeners();
    }

    @Override
    public synchronized TwitterStream onStatus(final Consumer<Status> action) {
        this.streamListeners.add(new StatusAdapter(){

            @Override
            public void onStatus(Status status) {
                action.accept(status);
            }
        });
        this.updateListeners();
        return this;
    }

    @Override
    public synchronized TwitterStream onException(final Consumer<Exception> action) {
        this.streamListeners.add(new StatusAdapter(){

            @Override
            public void onException(Exception ex) {
                action.accept(ex);
            }
        });
        this.updateListeners();
        return this;
    }

    @Override
    public synchronized void removeListener(StreamListener listener) {
        this.streamListeners.remove(listener);
        this.updateListeners();
    }

    @Override
    public synchronized void clearListeners() {
        this.streamListeners.clear();
        this.updateListeners();
    }

    @Override
    public synchronized void replaceListener(StreamListener toBeRemoved, StreamListener toBeAdded) {
        this.streamListeners.remove(toBeRemoved);
        this.streamListeners.add(toBeAdded);
        this.updateListeners();
    }

    private synchronized void updateListeners() {
        if (this.handler != null) {
            this.handler.updateListeners();
        }
    }

    private RawStreamListener[] getRawStreamListeners() {
        ArrayList<RawStreamListener> rawStreamListeners = new ArrayList<RawStreamListener>();
        for (StreamListener streamListener : this.streamListeners) {
            if (!(streamListener instanceof RawStreamListener)) continue;
            rawStreamListeners.add((RawStreamListener)streamListener);
        }
        return rawStreamListeners.toArray(new RawStreamListener[rawStreamListeners.size()]);
    }

    private SiteStreamsListener[] getSiteStreamsListeners() {
        ArrayList<SiteStreamsListener> siteStreamsListeners = new ArrayList<SiteStreamsListener>();
        for (StreamListener streamListener : this.streamListeners) {
            if (!(streamListener instanceof SiteStreamsListener)) continue;
            siteStreamsListeners.add((SiteStreamsListener)streamListener);
        }
        return siteStreamsListeners.toArray(new SiteStreamsListener[siteStreamsListeners.size()]);
    }

    private StatusListener[] getStatusListeners() {
        ArrayList<StatusListener> statusListeners = new ArrayList<StatusListener>();
        for (StreamListener streamListener : this.streamListeners) {
            if (!(streamListener instanceof StatusListener)) continue;
            statusListeners.add((StatusListener)streamListener);
        }
        return statusListeners.toArray(new StatusListener[statusListeners.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterStreamImpl that = (TwitterStreamImpl)o;
        if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        if (this.lifeCycleListeners != null ? !this.lifeCycleListeners.equals(that.lifeCycleListeners) : that.lifeCycleListeners != null) {
            return false;
        }
        if (this.stallWarningsGetParam != null ? !this.stallWarningsGetParam.equals(that.stallWarningsGetParam) : that.stallWarningsGetParam != null) {
            return false;
        }
        if (this.stallWarningsParam != null ? !this.stallWarningsParam.equals(that.stallWarningsParam) : that.stallWarningsParam != null) {
            return false;
        }
        return !(this.streamListeners != null ? !this.streamListeners.equals(that.streamListeners) : that.streamListeners != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + (this.lifeCycleListeners != null ? this.lifeCycleListeners.hashCode() : 0);
        result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
        result = 31 * result + (this.stallWarningsGetParam != null ? this.stallWarningsGetParam.hashCode() : 0);
        result = 31 * result + (this.stallWarningsParam != null ? this.stallWarningsParam.hashCode() : 0);
        result = 31 * result + (this.streamListeners != null ? this.streamListeners.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "TwitterStreamImpl{http=" + this.http + ", lifeCycleListeners=" + this.lifeCycleListeners + ", handler=" + this.handler + ", stallWarningsGetParam='" + this.stallWarningsGetParam + '\'' + ", stallWarningsParam=" + this.stallWarningsParam + ", streamListeners=" + this.streamListeners + '}';
    }

    static /* synthetic */ List access$6(TwitterStreamImpl twitterStreamImpl) {
        return twitterStreamImpl.lifeCycleListeners;
    }

    static enum Mode {
        user,
        status,
        site;

    }

    abstract class TwitterStreamConsumer
    extends Thread {
        private StatusStreamBase stream = null;
        private final String NAME;
        private volatile boolean closed;
        private StreamListener[] streamListeners;
        private RawStreamListener[] rawStreamListeners;
        private final Mode mode;

        TwitterStreamConsumer(Mode mode) {
            StringBuilder stringBuilder = new StringBuilder("Twitter Stream consumer-");
            int n = count + 1;
            count = n;
            this.NAME = stringBuilder.append(n).toString();
            this.closed = false;
            this.mode = mode;
            this.updateListeners();
            this.setName(String.valueOf(this.NAME) + "[initializing]");
        }

        void updateListeners() {
            switch (this.mode) {
                case site: {
                    this.streamListeners = TwitterStreamImpl.this.getSiteStreamsListeners();
                    break;
                }
                default: {
                    this.streamListeners = TwitterStreamImpl.this.getStatusListeners();
                }
            }
            this.rawStreamListeners = TwitterStreamImpl.this.getRawStreamListeners();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [40[DOLOOP]], but top level block is 41[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public synchronized void close() {
            this.setStatus("[Disposing thread]");
            this.closed = true;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn(e.getMessage());
                }
            }
        }

        private void setStatus(String message) {
            String actualMessage = String.valueOf(this.NAME) + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }
}

