/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.wolvsk.minigames;

import fr.nashoba24.wolvsk.minigames.Arena;
import fr.nashoba24.wolvsk.minigames.Minigames;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Minigame {
    private String mgname;
    private ArrayList<Arena> arenas = new ArrayList();
    private static HashMap<Player, Arena> players = new HashMap();
    private String cmd;
    private String mgprefix;

    public Minigame(String name, String command, String prefix) {
        this.mgname = name;
        this.cmd = command.toLowerCase();
        this.mgprefix = prefix;
    }

    public String getName() {
        return this.mgname;
    }

    public Arena[] getArenas() {
        if (this.arenas.size() == 0) {
            return new Arena[0];
        }
        Arena[] list = new Arena[this.arenas.size()];
        list = this.arenas.toArray(list);
        return list;
    }

    public boolean addArena(Arena arena, boolean save) {
        if (this.arenas.contains(arena)) {
            return false;
        }
        Arena[] arenaArray = this.getArenas();
        int n = arenaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Arena a = arenaArray[n2];
            if (a.getName().equals(arena.getName())) {
                return false;
            }
            ++n2;
        }
        if (arena.getMinigame() == this) {
            this.arenas.add(arena);
            if (save) {
                Minigames.save(arena.getMinigame());
            }
            arena.updateSigns();
            return true;
        }
        return false;
    }

    public void removeArena(Arena arena, boolean save) {
        if (this.arenas.contains(arena)) {
            this.arenas.remove(arena);
            if (save) {
                Minigames.save(arena.getMinigame());
            }
        }
    }

    public Arena getArena(String name, boolean ignoreCase) {
        if (ignoreCase) {
            for (Arena a : this.arenas) {
                if (!a.getName().equalsIgnoreCase(name)) continue;
                return a;
            }
        } else {
            for (Arena a : this.arenas) {
                if (!a.getName().equals(name)) continue;
                return a;
            }
        }
        return null;
    }

    public Arena getArena(Player p) {
        if (players.containsKey(p)) {
            return players.get(p);
        }
        return null;
    }

    public String getCommand() {
        return this.cmd;
    }

    public String getPrefix() {
        return this.mgprefix;
    }

    public String getFullPrefix() {
        return ChatColor.RESET + ChatColor.AQUA + "[" + this.mgprefix + ChatColor.RESET + ChatColor.AQUA + "]";
    }

    public void setArena(Player p, Arena arena) {
        if (arena == null) {
            players.remove(p);
            return;
        }
        players.put(p, arena);
    }
}

