/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.QueryIO;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.Callback;
import com.github.theholywaffle.teamspeak3.commands.CQuit;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SocketReader
extends Thread {
    private final TS3Query ts3;
    private final QueryIO io;
    private final BufferedReader in;
    private String lastEvent = "";

    public SocketReader(TS3Query ts3Query, QueryIO io) throws IOException {
        super("[TeamSpeak-3-Java-API] SocketReader");
        this.io = io;
        this.ts3 = ts3Query;
        this.in = new BufferedReader(new InputStreamReader(io.getSocket().getInputStream(), "UTF-8"));
        try {
            int i = 0;
            while (i < 4 || this.in.ready()) {
                TS3Query.log.info("< " + this.in.readLine());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            String line;
            try {
                line = this.in.readLine();
            }
            catch (IOException io) {
                if (this.isInterrupted()) break;
                TS3Query.log.log(Level.WARNING, "Connection error occurred.", io);
                break;
            }
            if (line == null) {
                TS3Query.log.warning("Connection closed by the server.");
                break;
            }
            if (line.isEmpty()) continue;
            Command c = this.io.getCommandQueue().peek();
            if (line.startsWith("notify")) {
                TS3Query.log.info("< [event] " + line);
                if (this.isDuplicate(line)) continue;
                this.ts3.submitUserTask(new Runnable(){

                    @Override
                    public void run() {
                        String[] arr = line.split(" ", 2);
                        SocketReader.this.ts3.getEventManager().fireEvent(arr[0], arr[1]);
                    }
                });
                continue;
            }
            if (c != null && c.isSent()) {
                TS3Query.log.info("[" + c.getName() + "] < " + line);
                if (line.startsWith("error")) {
                    if (c instanceof CQuit) {
                        this.interrupt();
                    }
                    c.feedError(line.substring("error ".length()));
                    if (c.getError().getId() != 0) {
                        TS3Query.log.severe("TS3 command error: " + c.getError());
                    }
                    c.setAnswered();
                    this.io.getCommandQueue().remove(c);
                    this.answerCallback(c);
                    continue;
                }
                c.feed(line);
                continue;
            }
            TS3Query.log.warning("[UNHANDLED] < " + line);
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.isInterrupted()) {
            TS3Query.log.warning("SocketReader has stopped!");
            this.ts3.fireDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void answerCallback(Command c) {
        Map<Command, Callback> callbackMap = this.io.getCallbackMap();
        final Callback callback = callbackMap.get(c);
        if (callback == null) {
            return;
        }
        Set<Command> keySet = callbackMap.keySet();
        Map<Command, Callback> map = callbackMap;
        synchronized (map) {
            Iterator<Command> iterator = keySet.iterator();
            while (iterator.hasNext() && !c.equals(iterator.next())) {
                iterator.remove();
            }
        }
        this.ts3.submitUserTask(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.handle();
                }
                catch (Throwable t) {
                    TS3Query.log.log(Level.WARNING, "User callback threw exception", t);
                }
            }
        });
    }

    private boolean isDuplicate(String eventMessage) {
        if (!(eventMessage.startsWith("notifyclientmoved") || eventMessage.startsWith("notifycliententerview") || eventMessage.startsWith("notifyclientleftview"))) {
            return false;
        }
        if (eventMessage.equals(this.lastEvent)) {
            this.lastEvent = "";
            return true;
        }
        this.lastEvent = eventMessage;
        return false;
    }
}

