/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import twitter4j.HttpResponse;
import twitter4j.TwitterException;
import twitter4j.auth.OAuthSupport;
import twitter4j.auth.OAuthToken;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;

public final class RequestToken
extends OAuthToken
implements Serializable {
    private static final long serialVersionUID = -8806439091674811734L;
    private final Configuration conf = ConfigurationContext.getInstance();
    private OAuthSupport oauth;

    RequestToken(HttpResponse res, OAuthSupport oauth) throws TwitterException {
        super(res);
        this.oauth = oauth;
    }

    public RequestToken(String token, String tokenSecret) {
        super(token, tokenSecret);
    }

    RequestToken(String token, String tokenSecret, OAuthSupport oauth) {
        super(token, tokenSecret);
        this.oauth = oauth;
    }

    public String getAuthorizationURL() {
        return String.valueOf(this.conf.getOAuthAuthorizationURL()) + "?oauth_token=" + this.getToken();
    }

    public String getAuthenticationURL() {
        return String.valueOf(this.conf.getOAuthAuthenticationURL()) + "?oauth_token=" + this.getToken();
    }
}

