/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.Dispatcher;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.RawStreamListener;
import twitter4j.StallWarning;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStreamBase;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;

class StatusStreamImpl
extends StatusStreamBase {
    String line;
    static final RawStreamListener[] EMPTY = new RawStreamListener[0];

    StatusStreamImpl(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        super(dispatcher, stream, conf);
    }

    StatusStreamImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        super(dispatcher, response, conf);
    }

    @Override
    protected void onClose() {
    }

    @Override
    public void next(StatusListener listener) throws TwitterException {
        this.handleNextElement(new StatusListener[]{listener}, EMPTY);
    }

    @Override
    public void next(StreamListener[] listeners, RawStreamListener[] rawStreamListeners) throws TwitterException {
        this.handleNextElement(listeners, rawStreamListeners);
    }

    @Override
    protected String parseLine(String line) {
        this.line = line;
        return line;
    }

    @Override
    protected void onMessage(String rawString, RawStreamListener[] listeners) throws TwitterException {
        RawStreamListener[] rawStreamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            RawStreamListener listener = rawStreamListenerArray[n2];
            listener.onMessage(rawString);
            ++n2;
        }
    }

    @Override
    protected void onStatus(JSONObject json, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((StatusListener)listener).onStatus(this.asStatus(json));
            ++n2;
        }
    }

    @Override
    protected void onDelete(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            JSONObject deletionNotice = json.getJSONObject("delete");
            if (deletionNotice.has("status")) {
                ((StatusListener)listener).onDeletionNotice(new StatusDeletionNoticeImpl(deletionNotice.getJSONObject("status")));
            } else {
                JSONObject directMessage = deletionNotice.getJSONObject("direct_message");
                ((UserStreamListener)listener).onDeletionNotice(ParseUtil.getLong("id", directMessage), ParseUtil.getLong("user_id", directMessage));
            }
            ++n2;
        }
    }

    @Override
    protected void onLimit(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((StatusListener)listener).onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
            ++n2;
        }
    }

    @Override
    protected void onStallWarning(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((StatusListener)listener).onStallWarning(new StallWarning(json));
            ++n2;
        }
    }

    @Override
    protected void onScrubGeo(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        JSONObject scrubGeo = json.getJSONObject("scrub_geo");
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((StatusListener)listener).onScrubGeo(ParseUtil.getLong("user_id", scrubGeo), ParseUtil.getLong("up_to_status_id", scrubGeo));
            ++n2;
        }
    }

    @Override
    public void onException(Exception e, StreamListener[] listeners) {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            listener.onException(e);
            ++n2;
        }
    }
}

