/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.reconnect;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;

public class ReconnectingConnectionHandler
implements ConnectionHandler {
    private final ConnectionHandler userConnectionHandler;
    private final int startTimeout;
    private final int timeoutCap;
    private final int addend;
    private final double multiplier;
    private int timeout = -1;

    public ReconnectingConnectionHandler(ConnectionHandler userConnectionHandler, int startTimeout, int timeoutCap, int addend, double multiplier) {
        this.userConnectionHandler = userConnectionHandler;
        this.startTimeout = startTimeout;
        this.timeoutCap = timeoutCap;
        this.addend = addend;
        this.multiplier = multiplier;
    }

    @Override
    public void onConnect(TS3Query ts3Query) {
        this.timeout = this.startTimeout;
        if (this.userConnectionHandler != null) {
            this.userConnectionHandler.onConnect(ts3Query);
        }
    }

    @Override
    public void onDisconnect(TS3Query ts3Query) {
        if (this.timeout < 0) {
            return;
        }
        if (this.timeout == this.startTimeout) {
            TS3Query.log.info("[Connection] Disconnected from TS3 server");
            if (this.userConnectionHandler != null) {
                this.userConnectionHandler.onDisconnect(ts3Query);
            }
        }
        this.timeout = (int)Math.ceil((double)this.timeout * this.multiplier) + this.addend;
        if (this.timeoutCap > 0) {
            this.timeout = Math.min(this.timeout, this.timeoutCap);
        }
        try {
            Thread.sleep(this.timeout);
        }
        catch (InterruptedException e) {
            return;
        }
        try {
            ts3Query.connect();
        }
        catch (TS3ConnectionFailedException conFailed) {
            TS3Query.log.fine("[Connection] Failed to reconnect - waiting " + this.timeout + "ms until next attempt");
        }
    }
}

