/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.ReconnectStrategy;
import java.util.logging.Level;

public class TS3Config {
    private String host = null;
    private int queryPort = 10011;
    private TS3Query.FloodRate floodRate = TS3Query.FloodRate.DEFAULT;
    private Level level = Level.WARNING;
    private boolean debugToFile = false;
    private int commandTimeout = 4000;
    private ReconnectStrategy reconnectStrategy = ReconnectStrategy.disconnect();
    private ConnectionHandler connectionHandler = null;

    public TS3Config setHost(String host) {
        this.host = host;
        return this;
    }

    String getHost() {
        return this.host;
    }

    public TS3Config setQueryPort(int queryPort) {
        this.queryPort = queryPort;
        return this;
    }

    int getQueryPort() {
        return this.queryPort;
    }

    public TS3Config setFloodRate(TS3Query.FloodRate rate) {
        if (rate == null) {
            throw new NullPointerException("rate cannot be null!");
        }
        this.floodRate = rate;
        return this;
    }

    TS3Query.FloodRate getFloodRate() {
        return this.floodRate;
    }

    public TS3Config setDebugLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level cannot be null!");
        }
        this.level = level;
        return this;
    }

    Level getDebugLevel() {
        return this.level;
    }

    public TS3Config setDebugToFile(boolean debugToFile) {
        this.debugToFile = debugToFile;
        return this;
    }

    boolean getDebugToFile() {
        return this.debugToFile;
    }

    public TS3Config setCommandTimeout(int commandTimeout) {
        if (commandTimeout <= 0) {
            throw new IllegalArgumentException("Timeout value must be greater than 0");
        }
        this.commandTimeout = commandTimeout;
        return this;
    }

    int getCommandTimeout() {
        return this.commandTimeout;
    }

    public TS3Config setReconnectStrategy(ReconnectStrategy reconnectStrategy) {
        if (reconnectStrategy == null) {
            throw new NullPointerException("reconnectStrategy cannot be null!");
        }
        this.reconnectStrategy = reconnectStrategy;
        return this;
    }

    ReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public TS3Config setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        return this;
    }

    ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }
}

