/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.QueryIO;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.io.IOException;
import java.io.PrintStream;

public class SocketWriter
extends Thread {
    private final QueryIO io;
    private final int floodRate;
    private final PrintStream out;
    private volatile long lastCommand = System.currentTimeMillis();

    public SocketWriter(QueryIO io, int floodRate) throws IOException {
        super("[TeamSpeak-3-Java-API] SocketWriter");
        this.io = io;
        this.floodRate = floodRate > 50 ? floodRate : 50;
        this.out = new PrintStream(io.getSocket().getOutputStream(), true, "UTF-8");
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            Command c = this.io.getCommandQueue().peek();
            if (c != null && !c.isSent()) {
                String msg = c.toString();
                TS3Query.log.info("> " + msg);
                c.setSent();
                this.out.println(msg);
                this.lastCommand = System.currentTimeMillis();
            }
            try {
                Thread.sleep(this.floodRate);
            }
            catch (InterruptedException e) {
                this.interrupt();
                break;
            }
        }
        this.out.close();
        if (!this.isInterrupted()) {
            TS3Query.log.warning("SocketWriter has stopped!");
        }
    }

    public long getIdleTime() {
        return System.currentTimeMillis() - this.lastCommand;
    }
}

