/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.EventManager;
import com.github.theholywaffle.teamspeak3.QueryIO;
import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3ApiAsync;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.api.Callback;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.commands.CQuit;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.log.LogHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TS3Query {
    public static final Logger log = Logger.getLogger(TS3Query.class.getName());
    private final ExecutorService userThreadPool = Executors.newCachedThreadPool();
    private final EventManager eventManager = new EventManager();
    private final TS3Config config;
    private final ConnectionHandler connectionHandler;
    private QueryIO io;
    private TS3Api api;
    private TS3ApiAsync asyncApi;

    public TS3Query() {
        this(new TS3Config());
    }

    public TS3Query(TS3Config config) {
        log.setUseParentHandlers(false);
        log.addHandler(new LogHandler(config.getDebugToFile()));
        log.setLevel(config.getDebugLevel());
        this.config = config;
        this.connectionHandler = config.getReconnectStrategy().create(config.getConnectionHandler());
    }

    public TS3Query connect() {
        QueryIO oldIO = this.io;
        if (oldIO != null) {
            oldIO.disconnect();
        }
        try {
            this.io = new QueryIO(this, this.config);
        }
        catch (TS3ConnectionFailedException conFailed) {
            this.fireDisconnect();
            throw conFailed;
        }
        try {
            this.connectionHandler.onConnect(this);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "ConnectionHandler threw exception in connect handler", t);
        }
        this.io.continueFrom(oldIO);
        return this;
    }

    public void exit() {
        this.doCommand(new CQuit());
        this.io.disconnect();
        this.userThreadPool.shutdown();
        Handler[] handlerArray = log.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler lh = handlerArray[n2];
            log.removeHandler(lh);
            ++n2;
        }
    }

    public TS3Api getApi() {
        if (this.api == null) {
            this.api = new TS3Api(this);
        }
        return this.api;
    }

    public TS3ApiAsync getAsyncApi() {
        if (this.asyncApi == null) {
            this.asyncApi = new TS3ApiAsync(this);
        }
        return this.asyncApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCommand(Command c) {
        long end = System.currentTimeMillis() + (long)this.config.getCommandTimeout();
        final Object signal = new Object();
        Callback callback = new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle() {
                Object object = signal;
                synchronized (object) {
                    signal.notifyAll();
                }
            }
        };
        this.io.queueCommand(c, callback);
        boolean interrupted = false;
        while (!c.isAnswered() && System.currentTimeMillis() < end) {
            try {
                Object object = signal;
                synchronized (object) {
                    signal.wait(end - System.currentTimeMillis());
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (!c.isAnswered()) {
            log.severe("Command " + c.getName() + " was not answered in time.");
            return false;
        }
        return c.getError().isSuccessful();
    }

    void doCommandAsync(Command c) {
        this.doCommandAsync(c, null);
    }

    void doCommandAsync(Command c, Callback callback) {
        this.io.queueCommand(c, callback);
    }

    void submitUserTask(Runnable task) {
        this.userThreadPool.submit(task);
    }

    EventManager getEventManager() {
        return this.eventManager;
    }

    void fireDisconnect() {
        this.userThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    TS3Query.this.connectionHandler.onDisconnect(TS3Query.this);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "ConnectionHandler threw exception in disconnect handler", t);
                }
            }
        });
    }

    public static enum FloodRate {
        DEFAULT(350),
        UNLIMITED(0);

        private final int ms;

        private FloodRate(int ms) {
            this.ms = ms;
        }

        public int getMs() {
            return this.ms;
        }
    }
}

