/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.Callback;
import com.github.theholywaffle.teamspeak3.api.ChannelProperty;
import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.CommandFuture;
import com.github.theholywaffle.teamspeak3.api.PermissionGroupDatabaseType;
import com.github.theholywaffle.teamspeak3.api.PrivilegeKeyType;
import com.github.theholywaffle.teamspeak3.api.ReasonIdentifier;
import com.github.theholywaffle.teamspeak3.api.ServerGroupType;
import com.github.theholywaffle.teamspeak3.api.ServerInstanceProperty;
import com.github.theholywaffle.teamspeak3.api.Snapshot;
import com.github.theholywaffle.teamspeak3.api.TextMessageTargetMode;
import com.github.theholywaffle.teamspeak3.api.VirtualServerProperty;
import com.github.theholywaffle.teamspeak3.api.event.TS3EventType;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.wrapper.Ban;
import com.github.theholywaffle.teamspeak3.api.wrapper.Binding;
import com.github.theholywaffle.teamspeak3.api.wrapper.Channel;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelBase;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Client;
import com.github.theholywaffle.teamspeak3.api.wrapper.ClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Complaint;
import com.github.theholywaffle.teamspeak3.api.wrapper.ConnectionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.CreatedVirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.HostInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.InstanceInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Message;
import com.github.theholywaffle.teamspeak3.api.wrapper.Permission;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionAssignment;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.PrivilegeKey;
import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerQueryInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Version;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServerInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.CBanAdd;
import com.github.theholywaffle.teamspeak3.commands.CBanClient;
import com.github.theholywaffle.teamspeak3.commands.CBanDel;
import com.github.theholywaffle.teamspeak3.commands.CBanDelAll;
import com.github.theholywaffle.teamspeak3.commands.CBanList;
import com.github.theholywaffle.teamspeak3.commands.CBindingList;
import com.github.theholywaffle.teamspeak3.commands.CChannelAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelClientAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelClientDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelClientPermList;
import com.github.theholywaffle.teamspeak3.commands.CChannelCreate;
import com.github.theholywaffle.teamspeak3.commands.CChannelDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelDelete;
import com.github.theholywaffle.teamspeak3.commands.CChannelEdit;
import com.github.theholywaffle.teamspeak3.commands.CChannelFind;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupAdd;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupClientList;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupCopy;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupDel;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupList;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupPermList;
import com.github.theholywaffle.teamspeak3.commands.CChannelGroupRename;
import com.github.theholywaffle.teamspeak3.commands.CChannelInfo;
import com.github.theholywaffle.teamspeak3.commands.CChannelList;
import com.github.theholywaffle.teamspeak3.commands.CChannelMove;
import com.github.theholywaffle.teamspeak3.commands.CChannelPermList;
import com.github.theholywaffle.teamspeak3.commands.CClientAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CClientDBDelete;
import com.github.theholywaffle.teamspeak3.commands.CClientDBEdit;
import com.github.theholywaffle.teamspeak3.commands.CClientDBFind;
import com.github.theholywaffle.teamspeak3.commands.CClientDBInfo;
import com.github.theholywaffle.teamspeak3.commands.CClientDBList;
import com.github.theholywaffle.teamspeak3.commands.CClientDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CClientEdit;
import com.github.theholywaffle.teamspeak3.commands.CClientFind;
import com.github.theholywaffle.teamspeak3.commands.CClientGetDBIdFromUId;
import com.github.theholywaffle.teamspeak3.commands.CClientGetIds;
import com.github.theholywaffle.teamspeak3.commands.CClientInfo;
import com.github.theholywaffle.teamspeak3.commands.CClientKick;
import com.github.theholywaffle.teamspeak3.commands.CClientList;
import com.github.theholywaffle.teamspeak3.commands.CClientMove;
import com.github.theholywaffle.teamspeak3.commands.CClientPermList;
import com.github.theholywaffle.teamspeak3.commands.CClientPoke;
import com.github.theholywaffle.teamspeak3.commands.CClientSetServerQueryLogin;
import com.github.theholywaffle.teamspeak3.commands.CClientUpdate;
import com.github.theholywaffle.teamspeak3.commands.CComplainAdd;
import com.github.theholywaffle.teamspeak3.commands.CComplainDel;
import com.github.theholywaffle.teamspeak3.commands.CComplainDelAll;
import com.github.theholywaffle.teamspeak3.commands.CComplainList;
import com.github.theholywaffle.teamspeak3.commands.CGM;
import com.github.theholywaffle.teamspeak3.commands.CHostInfo;
import com.github.theholywaffle.teamspeak3.commands.CInstanceEdit;
import com.github.theholywaffle.teamspeak3.commands.CInstanceInfo;
import com.github.theholywaffle.teamspeak3.commands.CLogin;
import com.github.theholywaffle.teamspeak3.commands.CLogout;
import com.github.theholywaffle.teamspeak3.commands.CMessageAdd;
import com.github.theholywaffle.teamspeak3.commands.CMessageDel;
import com.github.theholywaffle.teamspeak3.commands.CMessageGet;
import com.github.theholywaffle.teamspeak3.commands.CMessageList;
import com.github.theholywaffle.teamspeak3.commands.CMessageUpdateFlag;
import com.github.theholywaffle.teamspeak3.commands.CPermFind;
import com.github.theholywaffle.teamspeak3.commands.CPermGet;
import com.github.theholywaffle.teamspeak3.commands.CPermIdGetByName;
import com.github.theholywaffle.teamspeak3.commands.CPermOverview;
import com.github.theholywaffle.teamspeak3.commands.CPermReset;
import com.github.theholywaffle.teamspeak3.commands.CPermissionList;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyAdd;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyDelete;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyList;
import com.github.theholywaffle.teamspeak3.commands.CPrivilegeKeyUse;
import com.github.theholywaffle.teamspeak3.commands.CQuit;
import com.github.theholywaffle.teamspeak3.commands.CSendTextMessage;
import com.github.theholywaffle.teamspeak3.commands.CServerCreate;
import com.github.theholywaffle.teamspeak3.commands.CServerDelete;
import com.github.theholywaffle.teamspeak3.commands.CServerEdit;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAdd;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAddClient;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAutoAddPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupAutoDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupClientList;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupCopy;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupDel;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupDelClient;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupDelPerm;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupList;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupPermList;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupRename;
import com.github.theholywaffle.teamspeak3.commands.CServerGroupsByClientId;
import com.github.theholywaffle.teamspeak3.commands.CServerIdGetByPort;
import com.github.theholywaffle.teamspeak3.commands.CServerInfo;
import com.github.theholywaffle.teamspeak3.commands.CServerList;
import com.github.theholywaffle.teamspeak3.commands.CServerNotifyRegister;
import com.github.theholywaffle.teamspeak3.commands.CServerNotifyUnregister;
import com.github.theholywaffle.teamspeak3.commands.CServerProcessStop;
import com.github.theholywaffle.teamspeak3.commands.CServerRequestConnectionInfo;
import com.github.theholywaffle.teamspeak3.commands.CServerSnapshotCreate;
import com.github.theholywaffle.teamspeak3.commands.CServerSnapshotDeploy;
import com.github.theholywaffle.teamspeak3.commands.CServerStart;
import com.github.theholywaffle.teamspeak3.commands.CServerStop;
import com.github.theholywaffle.teamspeak3.commands.CSetClientChannelGroup;
import com.github.theholywaffle.teamspeak3.commands.CUse;
import com.github.theholywaffle.teamspeak3.commands.CVersion;
import com.github.theholywaffle.teamspeak3.commands.CWhoAmI;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TS3ApiAsync {
    private final TS3Query query;

    public TS3ApiAsync(TS3Query query) {
        this.query = query;
    }

    public CommandFuture<Integer> addBan(String ip, String name, String uid, long timeInSeconds, String reason) {
        if (ip == null && name == null && uid == null) {
            throw new IllegalArgumentException("Either IP, Name or UID must be set");
        }
        CBanAdd add = new CBanAdd(ip, name, uid, timeInSeconds, reason);
        return this.executeAndReturnIntProperty(add, "banid");
    }

    public CommandFuture<Boolean> addChannelClientPermission(int channelId, int clientDBId, String permName, int permValue) {
        CChannelClientAddPerm add = new CChannelClientAddPerm(channelId, clientDBId, permName, permValue);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<Integer> addChannelGroup(String name) {
        return this.addChannelGroup(name, null);
    }

    public CommandFuture<Integer> addChannelGroup(String name, PermissionGroupDatabaseType type) {
        CChannelGroupAdd add = new CChannelGroupAdd(name, type);
        return this.executeAndReturnIntProperty(add, "cgid");
    }

    public CommandFuture<Boolean> addChannelGroupPermission(int groupId, String permName, int permValue) {
        CChannelGroupAddPerm add = new CChannelGroupAddPerm(groupId, permName, permValue);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<Boolean> addChannelPermission(int channelId, String permName, int permValue) {
        CChannelAddPerm perm = new CChannelAddPerm(channelId, permName, permValue);
        return this.executeAndReturnError(perm);
    }

    public CommandFuture<Boolean> addClientPermission(int clientDBId, String permName, int value, boolean skipped) {
        CClientAddPerm add = new CClientAddPerm(clientDBId, permName, value, skipped);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<Boolean> addClientToServerGroup(int groupId, int clientDatabaseId) {
        CServerGroupAddClient add = new CServerGroupAddClient(groupId, clientDatabaseId);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<Boolean> addComplaint(int clientDBId, String message) {
        CComplainAdd add = new CComplainAdd(clientDBId, message);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<Boolean> addPermissionToAllServerGroups(ServerGroupType type, String permName, int value, boolean negated, boolean skipped) {
        CServerGroupAutoAddPerm add = new CServerGroupAutoAddPerm(type, permName, value, negated, skipped);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<String> addPrivilegeKey(PrivilegeKeyType type, int groupId, int channelId, String description) {
        CPrivilegeKeyAdd add = new CPrivilegeKeyAdd(type, groupId, channelId, description);
        return this.executeAndReturnStringProperty(add, "token");
    }

    public CommandFuture<String> addPrivilegeKeyChannelGroup(int channelGroupId, int channelId, String description) {
        return this.addPrivilegeKey(PrivilegeKeyType.CHANNEL_GROUP, channelGroupId, channelId, description);
    }

    public CommandFuture<String> addPrivilegeKeyServerGroup(int serverGroupId, String description) {
        return this.addPrivilegeKey(PrivilegeKeyType.SERVER_GROUP, serverGroupId, 0, description);
    }

    public CommandFuture<Integer> addServerGroup(String name) {
        return this.addServerGroup(name, PermissionGroupDatabaseType.REGULAR);
    }

    public CommandFuture<Integer> addServerGroup(String name, PermissionGroupDatabaseType type) {
        CServerGroupAdd add = new CServerGroupAdd(name, type);
        return this.executeAndReturnIntProperty(add, "sgid");
    }

    public CommandFuture<Boolean> addServerGroupPermission(int groupId, String permName, int value, boolean negated, boolean skipped) {
        CServerGroupAddPerm add = new CServerGroupAddPerm(groupId, permName, value, negated, skipped);
        return this.executeAndReturnError(add);
    }

    public void addTS3Listeners(TS3Listener ... listeners) {
        this.query.getEventManager().addListeners(listeners);
    }

    public CommandFuture<int[]> banClient(int clientId, long timeInSeconds) {
        return this.banClient(clientId, timeInSeconds, null);
    }

    public CommandFuture<int[]> banClient(int clientId, long timeInSeconds, String reason) {
        final CBanClient client = new CBanClient(clientId, timeInSeconds, reason);
        final CommandFuture<int[]> future = new CommandFuture<int[]>();
        this.query.doCommandAsync(client, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(client, future)) {
                    return;
                }
                List<Wrapper> response = client.getResponse();
                int[] banIds = new int[response.size()];
                int i = 0;
                while (i < banIds.length) {
                    banIds[i] = response.get(i).getInt("banid");
                    ++i;
                }
                future.set(banIds);
            }
        });
        return future;
    }

    public CommandFuture<int[]> banClient(int clientId, String reason) {
        return this.banClient(clientId, 0L, reason);
    }

    public CommandFuture<Boolean> broadcast(String message) {
        CGM broadcast = new CGM(message);
        return this.executeAndReturnError(broadcast);
    }

    public CommandFuture<Boolean> copyChannelGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType type) {
        if (targetGroupId <= 0) {
            throw new IllegalArgumentException("To create a new channel group, use the method with a String argument");
        }
        CChannelGroupCopy copy = new CChannelGroupCopy(sourceGroupId, targetGroupId, type);
        return this.executeAndReturnError(copy);
    }

    public CommandFuture<Integer> copyChannelGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType type) {
        CChannelGroupCopy copy = new CChannelGroupCopy(sourceGroupId, targetName, type);
        return this.executeAndReturnIntProperty(copy, "cgid");
    }

    public CommandFuture<Integer> copyServerGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType type) {
        if (targetGroupId <= 0) {
            throw new IllegalArgumentException("To create a new server group, use the method with a String argument");
        }
        CServerGroupCopy copy = new CServerGroupCopy(sourceGroupId, targetGroupId, type);
        return this.executeAndReturnIntProperty(copy, "sgid");
    }

    public CommandFuture<Integer> copyServerGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType type) {
        CServerGroupCopy copy = new CServerGroupCopy(sourceGroupId, targetName, type);
        return this.executeAndReturnIntProperty(copy, "sgid");
    }

    public CommandFuture<Integer> createChannel(String name, Map<ChannelProperty, String> options) {
        CChannelCreate create = new CChannelCreate(name, options);
        return this.executeAndReturnIntProperty(create, "cid");
    }

    public CommandFuture<CreatedVirtualServer> createServer(String name, Map<VirtualServerProperty, String> options) {
        final CServerCreate create = new CServerCreate(name, options);
        final CommandFuture<CreatedVirtualServer> future = new CommandFuture<CreatedVirtualServer>();
        this.query.doCommandAsync(create, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(create, future)) {
                    return;
                }
                future.set(new CreatedVirtualServer(create.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<Snapshot> createServerSnapshot() {
        final CServerSnapshotCreate create = new CServerSnapshotCreate();
        final CommandFuture<Snapshot> future = new CommandFuture<Snapshot>();
        this.query.doCommandAsync(create, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(create, future)) {
                    return;
                }
                future.set(new Snapshot(create.getRaw()));
            }
        });
        return future;
    }

    public CommandFuture<Boolean> deleteAllBans() {
        CBanDelAll del = new CBanDelAll();
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteAllComplaints(int clientDBId) {
        CComplainDelAll del = new CComplainDelAll(clientDBId);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteBan(int banId) {
        CBanDel del = new CBanDel(banId);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteChannel(int channelId) {
        return this.deleteChannel(channelId, true);
    }

    public CommandFuture<Boolean> deleteChannel(int channelId, boolean force) {
        CChannelDelete del = new CChannelDelete(channelId, force);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteChannelClientPermission(int channelId, int clientDBId, String permName) {
        CChannelClientDelPerm del = new CChannelClientDelPerm(channelId, clientDBId, permName);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteChannelGroup(int groupId) {
        return this.deleteChannelGroup(groupId, true);
    }

    public CommandFuture<Boolean> deleteChannelGroup(int groupId, boolean force) {
        CChannelGroupDel del = new CChannelGroupDel(groupId, force);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteChannelGroupPermission(int groupId, String permName) {
        CChannelGroupDelPerm del = new CChannelGroupDelPerm(groupId, permName);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteChannelPermission(int channelId, String permName) {
        CChannelDelPerm del = new CChannelDelPerm(channelId, permName);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteClientPermission(int clientDBId, String permName) {
        CClientDelPerm del = new CClientDelPerm(clientDBId, permName);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteComplaint(int targetClientDBId, int fromClientDBId) {
        CComplainDel del = new CComplainDel(targetClientDBId, fromClientDBId);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteDatabaseClientProperties(int clientDBId) {
        CClientDBDelete del = new CClientDBDelete(clientDBId);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteOfflineMessage(int messageId) {
        CMessageDel del = new CMessageDel(messageId);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deletePermissionFromAllServerGroups(ServerGroupType type, String permName) {
        CServerGroupAutoDelPerm del = new CServerGroupAutoDelPerm(type, permName);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deletePrivilegeKey(String token) {
        CPrivilegeKeyDelete del = new CPrivilegeKeyDelete(token);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteServer(int serverId) {
        CServerDelete delete = new CServerDelete(serverId);
        return this.executeAndReturnError(delete);
    }

    public CommandFuture<Boolean> deleteServerGroup(int groupId) {
        return this.deleteServerGroup(groupId, true);
    }

    public CommandFuture<Boolean> deleteServerGroup(int groupId, boolean force) {
        CServerGroupDel del = new CServerGroupDel(groupId, force);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deleteServerGroupPermission(int groupId, String permName) {
        CServerGroupDelPerm del = new CServerGroupDelPerm(groupId, permName);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> deployServerSnapshot(Snapshot snapshot) {
        return this.deployServerSnapshot(snapshot.get());
    }

    public CommandFuture<Boolean> deployServerSnapshot(String snapshot) {
        CServerSnapshotDeploy deploy = new CServerSnapshotDeploy(snapshot);
        return this.executeAndReturnError(deploy);
    }

    public CommandFuture<Boolean> editChannel(int channelId, Map<ChannelProperty, String> options) {
        CChannelEdit edit = new CChannelEdit(channelId, options);
        return this.executeAndReturnError(edit);
    }

    public CommandFuture<Boolean> editClient(int clientId, Map<ClientProperty, String> options) {
        CClientEdit edit = new CClientEdit(clientId, options);
        return this.executeAndReturnError(edit);
    }

    public CommandFuture<Boolean> editDatabaseClient(int clientDBId, Map<ClientProperty, String> options) {
        CClientDBEdit edit = new CClientDBEdit(clientDBId, options);
        return this.executeAndReturnError(edit);
    }

    public CommandFuture<Boolean> editInstance(ServerInstanceProperty property, String value) {
        if (!property.isChangeable()) {
            throw new IllegalArgumentException("Property is not changeable");
        }
        CInstanceEdit edit = new CInstanceEdit(property, value);
        return this.executeAndReturnError(edit);
    }

    public CommandFuture<Boolean> editServer(Map<VirtualServerProperty, String> options) {
        CServerEdit edit = new CServerEdit(options);
        return this.executeAndReturnError(edit);
    }

    public CommandFuture<List<Ban>> getBans() {
        final CBanList list = new CBanList();
        final CommandFuture<List<Ban>> future = new CommandFuture<List<Ban>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Ban> bans = new ArrayList<Ban>(responses.size());
                for (Wrapper response : responses) {
                    bans.add(new Ban(response.getMap()));
                }
                future.set(bans);
            }
        });
        return future;
    }

    public CommandFuture<List<Binding>> getBindings() {
        final CBindingList list = new CBindingList();
        final CommandFuture<List<Binding>> future = new CommandFuture<List<Binding>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Binding> bindings = new ArrayList<Binding>(responses.size());
                for (Wrapper response : responses) {
                    bindings.add(new Binding(response.getMap()));
                }
                future.set(bindings);
            }
        });
        return future;
    }

    public CommandFuture<Channel> getChannelByNameExact(String name, final boolean ignoreCase) {
        final CommandFuture<Channel> future = new CommandFuture<Channel>();
        final String caseName = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
        this.getChannels().onSuccess(new CommandFuture.SuccessListener<List<Channel>>(){

            @Override
            public void handleSuccess(List<Channel> allChannels) {
                for (Channel c : allChannels) {
                    String channelName;
                    String string = channelName = ignoreCase ? c.getName().toLowerCase(Locale.ROOT) : c.getName();
                    if (!caseName.equals(channelName)) continue;
                    future.set(c);
                    return;
                }
                future.set(null);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<Channel>> getChannelsByName(String name) {
        final CChannelFind find = new CChannelFind(name);
        final CommandFuture<List<Channel>> future = new CommandFuture<List<Channel>>();
        this.getChannels().onSuccess(new CommandFuture.SuccessListener<List<Channel>>(){

            @Override
            public void handleSuccess(final List<Channel> allChannels) {
                TS3ApiAsync.this.query.doCommandAsync(find, new Callback(){

                    @Override
                    public void handle() {
                        if (TS3ApiAsync.this.hasFailed(find, future)) {
                            return;
                        }
                        List<Wrapper> responses = find.getResponse();
                        ArrayList<Channel> channels = new ArrayList<Channel>(responses.size());
                        block0: for (Wrapper response : responses) {
                            int channelId = response.getInt("cid");
                            for (Channel c : allChannels) {
                                if (c.getId() != channelId) continue;
                                channels.add(c);
                                continue block0;
                            }
                        }
                        future.set(channels);
                    }
                });
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<Permission>> getChannelClientPermissions(int channelId, int clientDBId) {
        final CChannelClientPermList list = new CChannelClientPermList(channelId, clientDBId);
        final CommandFuture<List<Permission>> future = new CommandFuture<List<Permission>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Permission> permissions = new ArrayList<Permission>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new Permission(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClients(int channelId, int clientDBId, int groupId) {
        final CChannelGroupClientList list = new CChannelGroupClientList(channelId, clientDBId, groupId);
        final CommandFuture<List<ChannelGroupClient>> future = new CommandFuture<List<ChannelGroupClient>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<ChannelGroupClient> clients = new ArrayList<ChannelGroupClient>(responses.size());
                for (Wrapper response : responses) {
                    clients.add(new ChannelGroupClient(response.getMap()));
                }
                future.set(clients);
            }
        });
        return future;
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByChannelGroupId(int groupId) {
        return this.getChannelGroupClients(-1, -1, groupId);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByChannelId(int channelId) {
        return this.getChannelGroupClients(channelId, -1, -1);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByClientDBId(int clientDBId) {
        return this.getChannelGroupClients(-1, clientDBId, -1);
    }

    public CommandFuture<List<Permission>> getChannelGroupPermissions(int groupId) {
        final CChannelGroupPermList list = new CChannelGroupPermList(groupId);
        final CommandFuture<List<Permission>> future = new CommandFuture<List<Permission>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Permission> permissions = new ArrayList<Permission>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new Permission(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<List<ChannelGroup>> getChannelGroups() {
        final CChannelGroupList list = new CChannelGroupList();
        final CommandFuture<List<ChannelGroup>> future = new CommandFuture<List<ChannelGroup>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<ChannelGroup> groups = new ArrayList<ChannelGroup>(responses.size());
                for (Wrapper response : responses) {
                    groups.add(new ChannelGroup(response.getMap()));
                }
                future.set(groups);
            }
        });
        return future;
    }

    public CommandFuture<ChannelInfo> getChannelInfo(final int channelId) {
        final CChannelInfo info = new CChannelInfo(channelId);
        final CommandFuture<ChannelInfo> future = new CommandFuture<ChannelInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new ChannelInfo(channelId, info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<List<Permission>> getChannelPermissions(int channelId) {
        final CChannelPermList list = new CChannelPermList(channelId);
        final CommandFuture<List<Permission>> future = new CommandFuture<List<Permission>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Permission> permissions = new ArrayList<Permission>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new Permission(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<List<Channel>> getChannels() {
        final CChannelList list = new CChannelList();
        final CommandFuture<List<Channel>> future = new CommandFuture<List<Channel>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Channel> channels = new ArrayList<Channel>(responses.size());
                for (Wrapper response : responses) {
                    channels.add(new Channel(response.getMap()));
                }
                future.set(channels);
            }
        });
        return future;
    }

    public CommandFuture<Client> getClientByNameExact(String name, final boolean ignoreCase) {
        final CommandFuture<Client> future = new CommandFuture<Client>();
        final String caseName = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
        this.getClients().onSuccess(new CommandFuture.SuccessListener<List<Client>>(){

            @Override
            public void handleSuccess(List<Client> allClients) {
                for (Client c : allClients) {
                    String clientName;
                    String string = clientName = ignoreCase ? c.getNickname().toLowerCase(Locale.ROOT) : c.getNickname();
                    if (!caseName.equals(clientName)) continue;
                    future.set(c);
                    return;
                }
                future.set(null);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<Client>> getClientsByName(String name) {
        final CClientFind find = new CClientFind(name);
        final CommandFuture<List<Client>> future = new CommandFuture<List<Client>>();
        this.getClients().onSuccess(new CommandFuture.SuccessListener<List<Client>>(){

            @Override
            public void handleSuccess(final List<Client> allClients) {
                TS3ApiAsync.this.query.doCommandAsync(find, new Callback(){

                    @Override
                    public void handle() {
                        if (TS3ApiAsync.this.hasFailed(find, future)) {
                            return;
                        }
                        List<Wrapper> responses = find.getResponse();
                        ArrayList<Client> clients = new ArrayList<Client>(responses.size());
                        block0: for (Wrapper response : responses) {
                            for (Client c : allClients) {
                                if (c.getId() != response.getInt("clid")) continue;
                                clients.add(c);
                                continue block0;
                            }
                        }
                        future.set(clients);
                    }
                });
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<ClientInfo> getClientByUId(String clientUId) {
        final CClientGetIds get = new CClientGetIds(clientUId);
        final CommandFuture<ClientInfo> future = new CommandFuture<ClientInfo>();
        this.query.doCommandAsync(get, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(get, future)) {
                    return;
                }
                TS3ApiAsync.this.getClientInfo(get.getFirstResponse().getInt("clid")).forwardResult(future);
            }
        });
        return future;
    }

    public CommandFuture<ClientInfo> getClientInfo(final int clientId) {
        final CClientInfo info = new CClientInfo(clientId);
        final CommandFuture<ClientInfo> future = new CommandFuture<ClientInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new ClientInfo(clientId, info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<List<Permission>> getClientPermissions(int clientDBId) {
        final CClientPermList list = new CClientPermList(clientDBId);
        final CommandFuture<List<Permission>> future = new CommandFuture<List<Permission>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Permission> permissions = new ArrayList<Permission>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new Permission(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<List<Client>> getClients() {
        final CClientList list = new CClientList();
        final CommandFuture<List<Client>> future = new CommandFuture<List<Client>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Client> clients = new ArrayList<Client>(responses.size());
                for (Wrapper response : responses) {
                    clients.add(new Client(response.getMap()));
                }
                future.set(clients);
            }
        });
        return future;
    }

    public CommandFuture<List<Complaint>> getComplaints() {
        return this.getComplaints(-1);
    }

    public CommandFuture<List<Complaint>> getComplaints(int clientDBId) {
        final CComplainList list = new CComplainList(clientDBId);
        final CommandFuture<List<Complaint>> future = new CommandFuture<List<Complaint>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Complaint> complaints = new ArrayList<Complaint>(responses.size());
                for (Wrapper response : responses) {
                    complaints.add(new Complaint(response.getMap()));
                }
                future.set(complaints);
            }
        });
        return future;
    }

    public CommandFuture<ConnectionInfo> getConnectionInfo() {
        final CServerRequestConnectionInfo info = new CServerRequestConnectionInfo();
        final CommandFuture<ConnectionInfo> future = new CommandFuture<ConnectionInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new ConnectionInfo(info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<List<DatabaseClientInfo>> getDatabaseClientsByName(String name) {
        final CClientDBFind find = new CClientDBFind(name, false);
        final CommandFuture<List<DatabaseClientInfo>> future = new CommandFuture<List<DatabaseClientInfo>>();
        this.query.doCommandAsync(find, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(find, future)) {
                    return;
                }
                List<Wrapper> responses = find.getResponse();
                ArrayList infoFutures = new ArrayList(responses.size());
                for (Wrapper response : responses) {
                    int databaseId = response.getInt("cldbid");
                    infoFutures.add(TS3ApiAsync.this.getDatabaseClientInfo(databaseId));
                }
                CommandFuture.ofAll(infoFutures).forwardResult(future);
            }
        });
        return future;
    }

    public CommandFuture<DatabaseClientInfo> getDatabaseClientByUId(String clientUId) {
        final CClientGetDBIdFromUId get = new CClientGetDBIdFromUId(clientUId);
        final CommandFuture<DatabaseClientInfo> future = new CommandFuture<DatabaseClientInfo>();
        this.query.doCommandAsync(get, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(get, future)) {
                    return;
                }
                TS3ApiAsync.this.getDatabaseClientInfo(get.getFirstResponse().getInt("cldbid")).forwardResult(future);
            }
        });
        return future;
    }

    public CommandFuture<DatabaseClientInfo> getDatabaseClientInfo(int clientDBId) {
        final CClientDBInfo info = new CClientDBInfo(clientDBId);
        final CommandFuture<DatabaseClientInfo> future = new CommandFuture<DatabaseClientInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new DatabaseClientInfo(info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<List<DatabaseClient>> getDatabaseClients() {
        final CClientDBList countList = new CClientDBList(0, 1, true);
        final CommandFuture<List<DatabaseClient>> future = new CommandFuture<List<DatabaseClient>>();
        this.query.doCommandAsync(countList, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(countList, future)) {
                    return;
                }
                int count = countList.getFirstResponse().getInt("count");
                int futuresCount = (count - 1) / 200 + 1;
                ArrayList futures = new ArrayList(futuresCount);
                int i = 0;
                while (i < count) {
                    futures.add(TS3ApiAsync.this.getDatabaseClients(i, 200));
                    i += 200;
                }
                CommandFuture.ofAll(futures).onSuccess(new CommandFuture.SuccessListener<List<List<DatabaseClient>>>(){

                    @Override
                    public void handleSuccess(List<List<DatabaseClient>> result) {
                        int total = 0;
                        for (List<DatabaseClient> list : result) {
                            total += list.size();
                        }
                        ArrayList<DatabaseClient> combination = new ArrayList<DatabaseClient>(total);
                        for (List<DatabaseClient> list : result) {
                            combination.addAll(list);
                        }
                        future.set(combination);
                    }
                }).forwardFailure(future);
            }
        });
        return future;
    }

    public CommandFuture<List<DatabaseClient>> getDatabaseClients(int offset, final int count) {
        final CClientDBList list = new CClientDBList(offset, count, false);
        final CommandFuture<List<DatabaseClient>> future = new CommandFuture<List<DatabaseClient>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                ArrayList<DatabaseClient> clients = new ArrayList<DatabaseClient>(count);
                for (Wrapper response : list.getResponse()) {
                    clients.add(new DatabaseClient(response.getMap()));
                }
                future.set(clients);
            }
        });
        return future;
    }

    public CommandFuture<HostInfo> getHostInfo() {
        final CHostInfo info = new CHostInfo();
        final CommandFuture<HostInfo> future = new CommandFuture<HostInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new HostInfo(info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<InstanceInfo> getInstanceInfo() {
        final CInstanceInfo info = new CInstanceInfo();
        final CommandFuture<InstanceInfo> future = new CommandFuture<InstanceInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new InstanceInfo(info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<String> getOfflineMessage(int messageId) {
        CMessageGet get = new CMessageGet(messageId);
        return this.executeAndReturnStringProperty(get, "message");
    }

    public CommandFuture<String> getOfflineMessage(Message message) {
        return this.getOfflineMessage(message.getId());
    }

    public CommandFuture<List<Message>> getOfflineMessages() {
        final CMessageList list = new CMessageList();
        final CommandFuture<List<Message>> future = new CommandFuture<List<Message>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Message> msg = new ArrayList<Message>(responses.size());
                for (Wrapper response : responses) {
                    msg.add(new Message(response.getMap()));
                }
                future.set(msg);
            }
        });
        return future;
    }

    public CommandFuture<List<PermissionAssignment>> getPermissionAssignments(String permName) {
        final CPermFind find = new CPermFind(permName);
        final CommandFuture<List<PermissionAssignment>> future = new CommandFuture<List<PermissionAssignment>>();
        this.query.doCommandAsync(find, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(find, future)) {
                    return;
                }
                List<Wrapper> responses = find.getResponse();
                ArrayList<PermissionAssignment> assignments = new ArrayList<PermissionAssignment>(responses.size());
                for (Wrapper response : responses) {
                    assignments.add(new PermissionAssignment(response.getMap()));
                }
                future.set(assignments);
            }
        });
        return future;
    }

    public CommandFuture<Integer> getPermissionIdByName(String permName) {
        CPermIdGetByName get = new CPermIdGetByName(permName);
        return this.executeAndReturnIntProperty(get, "permid");
    }

    public CommandFuture<List<PermissionAssignment>> getPermissionOverview(int channelId, int clientDBId) {
        final CPermOverview overview = new CPermOverview(channelId, clientDBId);
        final CommandFuture<List<PermissionAssignment>> future = new CommandFuture<List<PermissionAssignment>>();
        this.query.doCommandAsync(overview, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(overview, future)) {
                    return;
                }
                List<Wrapper> responses = overview.getResponse();
                ArrayList<PermissionAssignment> permissions = new ArrayList<PermissionAssignment>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new PermissionAssignment(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<List<PermissionInfo>> getPermissions() {
        final CPermissionList list = new CPermissionList();
        final CommandFuture<List<PermissionInfo>> future = new CommandFuture<List<PermissionInfo>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new PermissionInfo(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<Integer> getPermissionValue(String permName) {
        CPermGet get = new CPermGet(permName);
        return this.executeAndReturnIntProperty(get, "permvalue");
    }

    public CommandFuture<List<PrivilegeKey>> getPrivilegeKeys() {
        final CPrivilegeKeyList list = new CPrivilegeKeyList();
        final CommandFuture<List<PrivilegeKey>> future = new CommandFuture<List<PrivilegeKey>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<PrivilegeKey> keys = new ArrayList<PrivilegeKey>(responses.size());
                for (Wrapper response : responses) {
                    keys.add(new PrivilegeKey(response.getMap()));
                }
                future.set(keys);
            }
        });
        return future;
    }

    public CommandFuture<List<ServerGroupClient>> getServerGroupClients(int serverGroupId) {
        final CServerGroupClientList list = new CServerGroupClientList(serverGroupId);
        final CommandFuture<List<ServerGroupClient>> future = new CommandFuture<List<ServerGroupClient>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<ServerGroupClient> clients = new ArrayList<ServerGroupClient>(responses.size());
                for (Wrapper response : responses) {
                    clients.add(new ServerGroupClient(response.getMap()));
                }
                future.set(clients);
            }
        });
        return future;
    }

    public CommandFuture<List<ServerGroupClient>> getServerGroupClients(ServerGroup serverGroup) {
        return this.getServerGroupClients(serverGroup.getId());
    }

    public CommandFuture<List<Permission>> getServerGroupPermissions(int serverGroupId) {
        final CServerGroupPermList list = new CServerGroupPermList(serverGroupId);
        final CommandFuture<List<Permission>> future = new CommandFuture<List<Permission>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<Permission> permissions = new ArrayList<Permission>(responses.size());
                for (Wrapper response : responses) {
                    permissions.add(new Permission(response.getMap()));
                }
                future.set(permissions);
            }
        });
        return future;
    }

    public CommandFuture<List<Permission>> getServerGroupPermissions(ServerGroup serverGroup) {
        return this.getServerGroupPermissions(serverGroup.getId());
    }

    public CommandFuture<List<ServerGroup>> getServerGroups() {
        final CServerGroupList list = new CServerGroupList();
        final CommandFuture<List<ServerGroup>> future = new CommandFuture<List<ServerGroup>>();
        this.query.doCommandAsync(list, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(list, future)) {
                    return;
                }
                List<Wrapper> responses = list.getResponse();
                ArrayList<ServerGroup> groups = new ArrayList<ServerGroup>(responses.size());
                for (Wrapper response : responses) {
                    groups.add(new ServerGroup(response.getMap()));
                }
                future.set(groups);
            }
        });
        return future;
    }

    public CommandFuture<List<ServerGroup>> getServerGroupsByClientId(int clientDatabaseId) {
        final CServerGroupsByClientId client = new CServerGroupsByClientId(clientDatabaseId);
        final CommandFuture<List<ServerGroup>> future = new CommandFuture<List<ServerGroup>>();
        this.getServerGroups().onSuccess(new CommandFuture.SuccessListener<List<ServerGroup>>(){

            @Override
            public void handleSuccess(final List<ServerGroup> allServerGroups) {
                TS3ApiAsync.this.query.doCommandAsync(client, new Callback(){

                    @Override
                    public void handle() {
                        if (TS3ApiAsync.this.hasFailed(client, future)) {
                            return;
                        }
                        List<Wrapper> responses = client.getResponse();
                        ArrayList<ServerGroup> list = new ArrayList<ServerGroup>(responses.size());
                        for (Wrapper response : responses) {
                            for (ServerGroup s : allServerGroups) {
                                if (s.getId() != response.getInt("sgid")) continue;
                                list.add(s);
                            }
                        }
                        future.set(list);
                    }
                });
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<ServerGroup>> getServerGroupsByClient(Client client) {
        return this.getServerGroupsByClientId(client.getDatabaseId());
    }

    public CommandFuture<Integer> getServerIdByPort(int port) {
        CServerIdGetByPort s = new CServerIdGetByPort(port);
        return this.executeAndReturnIntProperty(s, "server_id");
    }

    public CommandFuture<VirtualServerInfo> getServerInfo() {
        final CServerInfo info = new CServerInfo();
        final CommandFuture<VirtualServerInfo> future = new CommandFuture<VirtualServerInfo>();
        this.query.doCommandAsync(info, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(info, future)) {
                    return;
                }
                future.set(new VirtualServerInfo(info.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<Version> getVersion() {
        final CVersion version = new CVersion();
        final CommandFuture<Version> future = new CommandFuture<Version>();
        this.query.doCommandAsync(version, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(version, future)) {
                    return;
                }
                future.set(new Version(version.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    public CommandFuture<List<VirtualServer>> getVirtualServers() {
        final CServerList serverList = new CServerList();
        final CommandFuture<List<VirtualServer>> future = new CommandFuture<List<VirtualServer>>();
        this.query.doCommandAsync(serverList, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(serverList, future)) {
                    return;
                }
                List<Wrapper> responses = serverList.getResponse();
                ArrayList<VirtualServer> servers = new ArrayList<VirtualServer>(responses.size());
                for (Wrapper response : responses) {
                    servers.add(new VirtualServer(response.getMap()));
                }
                future.set(servers);
            }
        });
        return future;
    }

    public CommandFuture<Boolean> kickClientFromChannel(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clientIds);
    }

    public CommandFuture<Boolean> kickClientFromChannel(Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clients);
    }

    public CommandFuture<Boolean> kickClientFromChannel(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clientIds);
    }

    public CommandFuture<Boolean> kickClientFromChannel(String message, Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clients);
    }

    public CommandFuture<Boolean> kickClientFromServer(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clientIds);
    }

    public CommandFuture<Boolean> kickClientFromServer(Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clients);
    }

    public CommandFuture<Boolean> kickClientFromServer(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clientIds);
    }

    public CommandFuture<Boolean> kickClientFromServer(String message, Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clients);
    }

    private CommandFuture<Boolean> kickClients(ReasonIdentifier reason, String message, Client ... clients) {
        int[] clientIds = new int[clients.length];
        int i = 0;
        while (i < clients.length) {
            clientIds[i] = clients[i].getId();
            ++i;
        }
        return this.kickClients(reason, message, clientIds);
    }

    private CommandFuture<Boolean> kickClients(ReasonIdentifier reason, String message, int ... clientIds) {
        CClientKick kick = new CClientKick(reason, message, clientIds);
        return this.executeAndReturnError(kick);
    }

    public CommandFuture<Boolean> login(String username, String password) {
        CLogin login = new CLogin(username, password);
        return this.executeAndReturnError(login);
    }

    public CommandFuture<Boolean> logout() {
        CLogout logout = new CLogout();
        return this.executeAndReturnError(logout);
    }

    public CommandFuture<Boolean> moveChannel(int channelId, int channelTargetId) {
        return this.moveChannel(channelId, channelTargetId, 0);
    }

    public CommandFuture<Boolean> moveChannel(int channelId, int channelTargetId, int order) {
        CChannelMove move = new CChannelMove(channelId, channelTargetId, order);
        return this.executeAndReturnError(move);
    }

    public CommandFuture<Boolean> moveQuery(int channelId) {
        return this.moveClient(0, channelId, null);
    }

    public CommandFuture<Boolean> moveQuery(ChannelBase channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel was null");
        }
        return this.moveClient(0, channel.getId(), null);
    }

    public CommandFuture<Boolean> moveQuery(int channelId, String channelPassword) {
        return this.moveClient(0, channelId, channelPassword);
    }

    public CommandFuture<Boolean> moveQuery(ChannelBase channel, String channelPassword) {
        if (channel == null) {
            throw new IllegalArgumentException("channel was null");
        }
        return this.moveClient(0, channel.getId(), channelPassword);
    }

    public CommandFuture<Boolean> moveClient(int clientId, int channelId) {
        return this.moveClient(clientId, channelId, null);
    }

    public CommandFuture<Boolean> moveClients(int[] clientIds, int channelId) {
        return this.moveClients(clientIds, channelId, null);
    }

    public CommandFuture<Boolean> moveClient(Client client, ChannelBase channel) {
        return this.moveClient(client, channel, null);
    }

    public CommandFuture<Boolean> moveClients(Client[] clients, ChannelBase channel) {
        return this.moveClients(clients, channel, null);
    }

    public CommandFuture<Boolean> moveClient(int clientId, int channelId, String channelPassword) {
        CClientMove move = new CClientMove(clientId, channelId, channelPassword);
        return this.executeAndReturnError(move);
    }

    public CommandFuture<Boolean> moveClients(int[] clientIds, int channelId, String channelPassword) {
        if (clientIds == null) {
            throw new IllegalArgumentException("clientIds was null");
        }
        if (clientIds.length == 0) {
            return CommandFuture.immediate(true);
        }
        CClientMove move = new CClientMove(clientIds, channelId, channelPassword);
        return this.executeAndReturnError(move);
    }

    public CommandFuture<Boolean> moveClient(Client client, ChannelBase channel, String channelPassword) {
        if (client == null) {
            throw new IllegalArgumentException("client was null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("channel was null");
        }
        return this.moveClient(client.getId(), channel.getId(), channelPassword);
    }

    public CommandFuture<Boolean> moveClients(Client[] clients, ChannelBase channel, String channelPassword) {
        if (clients == null) {
            throw new IllegalArgumentException("clients was null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("channel was null");
        }
        int[] clientIds = new int[clients.length];
        int i = 0;
        while (i < clients.length) {
            Client client = clients[i];
            clientIds[i] = client.getId();
            ++i;
        }
        return this.moveClients(clientIds, channel.getId(), channelPassword);
    }

    public CommandFuture<Boolean> pokeClient(int clientId, String message) {
        CClientPoke poke = new CClientPoke(clientId, message);
        return this.executeAndReturnError(poke);
    }

    @Deprecated
    public CommandFuture<Boolean> quit() {
        CQuit quit = new CQuit();
        return this.executeAndReturnError(quit);
    }

    public CommandFuture<Boolean> registerAllEvents() {
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        ArrayList eventFutures = new ArrayList(5);
        eventFutures.add(this.registerEvent(TS3EventType.SERVER));
        eventFutures.add(this.registerEvent(TS3EventType.TEXT_SERVER));
        eventFutures.add(this.registerEvent(TS3EventType.CHANNEL, 0));
        eventFutures.add(this.registerEvent(TS3EventType.TEXT_CHANNEL, 0));
        eventFutures.add(this.registerEvent(TS3EventType.TEXT_PRIVATE));
        eventFutures.add(this.registerEvent(TS3EventType.PRIVILEGE_KEY_USED));
        CommandFuture.ofAll(eventFutures).onSuccess(new CommandFuture.SuccessListener<List<Boolean>>(){

            @Override
            public void handleSuccess(List<Boolean> result) {
                future.set(true);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Boolean> registerEvent(TS3EventType eventType) {
        if (eventType == TS3EventType.CHANNEL || eventType == TS3EventType.TEXT_CHANNEL) {
            return this.registerEvent(eventType, 0);
        }
        return this.registerEvent(eventType, -1);
    }

    public CommandFuture<Boolean> registerEvent(TS3EventType eventType, int channelId) {
        CServerNotifyRegister register = new CServerNotifyRegister(eventType, channelId);
        return this.executeAndReturnError(register);
    }

    public CommandFuture<Boolean> registerEvents(TS3EventType ... eventTypes) {
        if (eventTypes.length == 0) {
            return CommandFuture.immediate(true);
        }
        ArrayList registerFutures = new ArrayList(eventTypes.length);
        TS3EventType[] tS3EventTypeArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TS3EventType type = tS3EventTypeArray[n2];
            registerFutures.add(this.registerEvent(type));
            ++n2;
        }
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        CommandFuture.ofAll(registerFutures).onSuccess(new CommandFuture.SuccessListener<List<Boolean>>(){

            @Override
            public void handleSuccess(List<Boolean> result) {
                future.set(true);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Boolean> removeClientFromServerGroup(int serverGroupId, int clientDatabaseId) {
        CServerGroupDelClient del = new CServerGroupDelClient(serverGroupId, clientDatabaseId);
        return this.executeAndReturnError(del);
    }

    public CommandFuture<Boolean> removeClientFromServerGroup(ServerGroup serverGroup, Client client) {
        return this.removeClientFromServerGroup(serverGroup.getId(), client.getDatabaseId());
    }

    public void removeTS3Listeners(TS3Listener ... listeners) {
        this.query.getEventManager().removeListeners(listeners);
    }

    public CommandFuture<Boolean> renameChannelGroup(int channelGroupId, String name) {
        CChannelGroupRename rename = new CChannelGroupRename(channelGroupId, name);
        return this.executeAndReturnError(rename);
    }

    public CommandFuture<Boolean> renameChannelGroup(ChannelGroup channelGroup, String name) {
        return this.renameChannelGroup(channelGroup.getId(), name);
    }

    public CommandFuture<Boolean> renameServerGroup(int serverGroupId, String name) {
        CServerGroupRename rename = new CServerGroupRename(serverGroupId, name);
        return this.executeAndReturnError(rename);
    }

    public CommandFuture<Boolean> renameServerGroup(ServerGroup serverGroup, String name) {
        return this.renameChannelGroup(serverGroup.getId(), name);
    }

    public CommandFuture<String> resetPermissions() {
        CPermReset reset = new CPermReset();
        return this.executeAndReturnStringProperty(reset, "token");
    }

    public CommandFuture<Boolean> selectVirtualServerById(int id) {
        CUse use = new CUse(id, -1);
        return this.executeAndReturnError(use);
    }

    public CommandFuture<Boolean> selectVirtualServerByPort(int port) {
        CUse use = new CUse(-1, port);
        return this.executeAndReturnError(use);
    }

    public CommandFuture<Boolean> selectVirtualServer(VirtualServer server) {
        return this.selectVirtualServerById(server.getId());
    }

    public CommandFuture<Boolean> sendOfflineMessage(String clientUId, String subject, String message) {
        CMessageAdd add = new CMessageAdd(clientUId, subject, message);
        return this.executeAndReturnError(add);
    }

    public CommandFuture<Boolean> sendTextMessage(TextMessageTargetMode targetMode, int targetId, String message) {
        CSendTextMessage msg = new CSendTextMessage(targetMode.getIndex(), targetId, message);
        return this.executeAndReturnError(msg);
    }

    public CommandFuture<Boolean> sendChannelMessage(int channelId, final String message) {
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        this.moveQuery(channelId).onSuccess(new CommandFuture.SuccessListener<Boolean>(){

            @Override
            public void handleSuccess(Boolean result) {
                TS3ApiAsync.this.sendTextMessage(TextMessageTargetMode.CHANNEL, 0, message).forwardResult(future);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Boolean> sendChannelMessage(String message) {
        return this.sendTextMessage(TextMessageTargetMode.CHANNEL, 0, message);
    }

    public CommandFuture<Boolean> sendServerMessage(int serverId, final String message) {
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        this.selectVirtualServerById(serverId).onSuccess(new CommandFuture.SuccessListener<Boolean>(){

            @Override
            public void handleSuccess(Boolean result) {
                TS3ApiAsync.this.sendTextMessage(TextMessageTargetMode.SERVER, 0, message).forwardResult(future);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Boolean> sendServerMessage(String message) {
        return this.sendTextMessage(TextMessageTargetMode.SERVER, 0, message);
    }

    public CommandFuture<Boolean> sendPrivateMessage(int clientId, String message) {
        return this.sendTextMessage(TextMessageTargetMode.CLIENT, clientId, message);
    }

    public CommandFuture<Boolean> setClientChannelGroup(int groupId, int channelId, int clientDBId) {
        CSetClientChannelGroup group = new CSetClientChannelGroup(groupId, channelId, clientDBId);
        return this.executeAndReturnError(group);
    }

    public CommandFuture<Boolean> setMessageRead(int messageId) {
        return this.setMessageReadFlag(messageId, true);
    }

    public CommandFuture<Boolean> setMessageRead(Message message) {
        return this.setMessageReadFlag(message.getId(), true);
    }

    public CommandFuture<Boolean> setMessageReadFlag(int messageId, boolean read) {
        CMessageUpdateFlag flag = new CMessageUpdateFlag(messageId, read);
        return this.executeAndReturnError(flag);
    }

    public CommandFuture<Boolean> setMessageReadFlag(Message message, boolean read) {
        return this.setMessageReadFlag(message.getId(), read);
    }

    public CommandFuture<Boolean> setNickname(String nickname) {
        Map<ClientProperty, String> options = Collections.singletonMap(ClientProperty.CLIENT_NICKNAME, nickname);
        return this.updateClient(options);
    }

    public CommandFuture<Boolean> startServer(int serverId) {
        CServerStart start = new CServerStart(serverId);
        return this.executeAndReturnError(start);
    }

    public CommandFuture<Boolean> startServer(VirtualServer virtualServer) {
        return this.startServer(virtualServer.getId());
    }

    public CommandFuture<Boolean> stopServer(int serverId) {
        CServerStop stop = new CServerStop(serverId);
        return this.executeAndReturnError(stop);
    }

    public CommandFuture<Boolean> stopServer(VirtualServer virtualServer) {
        return this.stopServer(virtualServer.getId());
    }

    public CommandFuture<Boolean> stopServerProcess() {
        CServerProcessStop stop = new CServerProcessStop();
        return this.executeAndReturnError(stop);
    }

    public CommandFuture<Boolean> unregisterAllEvents() {
        CServerNotifyUnregister unr = new CServerNotifyUnregister();
        return this.executeAndReturnError(unr);
    }

    public CommandFuture<Boolean> updateClient(Map<ClientProperty, String> options) {
        CClientUpdate update = new CClientUpdate(options);
        return this.executeAndReturnError(update);
    }

    public CommandFuture<String> updateServerQueryLogin(String loginName) {
        CClientSetServerQueryLogin login = new CClientSetServerQueryLogin(loginName);
        return this.executeAndReturnStringProperty(login, "client_login_password");
    }

    public CommandFuture<Boolean> usePrivilegeKey(String token) {
        CPrivilegeKeyUse use = new CPrivilegeKeyUse(token);
        return this.executeAndReturnError(use);
    }

    public CommandFuture<Boolean> usePrivilegeKey(PrivilegeKey privilegeKey) {
        return this.usePrivilegeKey(privilegeKey.getToken());
    }

    public CommandFuture<ServerQueryInfo> whoAmI() {
        final CWhoAmI whoAmI = new CWhoAmI();
        final CommandFuture<ServerQueryInfo> future = new CommandFuture<ServerQueryInfo>();
        this.query.doCommandAsync(whoAmI, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(whoAmI, future)) {
                    return;
                }
                future.set(new ServerQueryInfo(whoAmI.getFirstResponse().getMap()));
            }
        });
        return future;
    }

    private CommandFuture<Boolean> executeAndReturnError(final Command command) {
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        this.query.doCommandAsync(command, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(command, future)) {
                    return;
                }
                future.set(true);
            }
        });
        return future;
    }

    private CommandFuture<String> executeAndReturnStringProperty(final Command command, final String property) {
        final CommandFuture<String> future = new CommandFuture<String>();
        this.query.doCommandAsync(command, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(command, future)) {
                    return;
                }
                future.set(command.getFirstResponse().get(property));
            }
        });
        return future;
    }

    private CommandFuture<Integer> executeAndReturnIntProperty(final Command command, final String property) {
        final CommandFuture<Integer> future = new CommandFuture<Integer>();
        this.query.doCommandAsync(command, new Callback(){

            @Override
            public void handle() {
                if (TS3ApiAsync.this.hasFailed(command, future)) {
                    return;
                }
                future.set(command.getFirstResponse().getInt(property));
            }
        });
        return future;
    }

    private boolean hasFailed(Command command, CommandFuture<?> future) {
        QueryError error = command.getError();
        if (error.isSuccessful()) {
            return false;
        }
        future.fail(error);
        return true;
    }
}

