/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.wrapper;

import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import java.util.Date;
import java.util.Map;

public class Client
extends Wrapper {
    public Client(Map<String, String> map) {
        super(map);
    }

    public boolean canTalk() {
        return this.getBoolean(ClientProperty.CLIENT_IS_TALKER);
    }

    public String getAwayMessage() {
        return this.get(ClientProperty.CLIENT_AWAY_MESSAGE);
    }

    public int getChannelGroupId() {
        return this.getInt(ClientProperty.CLIENT_CHANNEL_GROUP_ID);
    }

    public int getChannelId() {
        return this.getInt(ClientProperty.CID);
    }

    public String getCountry() {
        return this.get(ClientProperty.CLIENT_COUNTRY);
    }

    public Date getCreatedDate() {
        return new Date(this.getLong(ClientProperty.CLIENT_CREATED) * 1000L);
    }

    public int getDatabaseId() {
        return this.getInt(ClientProperty.CLIENT_DATABASE_ID);
    }

    public long getIconId() {
        return this.getLong(ClientProperty.CLIENT_ICON_ID);
    }

    public int getId() {
        return this.getInt("clid");
    }

    public long getIdleTime() {
        return this.getLong(ClientProperty.CLIENT_IDLE_TIME);
    }

    public int getInheritedChannelGroupId() {
        return this.getInt(ClientProperty.CLIENT_CHANNEL_GROUP_INHERITED_CHANNEL_ID);
    }

    public String getIp() {
        return this.get(ClientProperty.CONNECTION_CLIENT_IP);
    }

    public Date getLastConnectedDate() {
        return new Date(this.getLong(ClientProperty.CLIENT_LASTCONNECTED) * 1000L);
    }

    public String getNickname() {
        return this.get(ClientProperty.CLIENT_NICKNAME);
    }

    public String getPlatform() {
        return this.get(ClientProperty.CLIENT_PLATFORM);
    }

    public int[] getServerGroups() {
        String str = this.get(ClientProperty.CLIENT_SERVERGROUPS);
        String[] arr = str.split(",");
        int[] groups = new int[arr.length];
        int i = 0;
        while (i < groups.length) {
            groups[i] = Integer.parseInt(arr[i]);
            ++i;
        }
        return groups;
    }

    public int getTalkPower() {
        return this.getInt(ClientProperty.CLIENT_TALK_POWER);
    }

    public int getType() {
        return this.getInt(ClientProperty.CLIENT_TYPE);
    }

    public String getUniqueIdentifier() {
        return this.get(ClientProperty.CLIENT_UNIQUE_IDENTIFIER);
    }

    public String getVersion() {
        return this.get(ClientProperty.CLIENT_VERSION);
    }

    public boolean isAway() {
        return this.getBoolean(ClientProperty.CLIENT_AWAY);
    }

    public boolean isChannelCommander() {
        return this.getBoolean(ClientProperty.CLIENT_IS_CHANNEL_COMMANDER);
    }

    public boolean isInServerGroup(int serverGroupId) {
        int[] serverGroupIds;
        int[] nArray = serverGroupIds = this.getServerGroups();
        int n = serverGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (s == serverGroupId) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isInServerGroup(ServerGroup serverGroup) {
        return this.isInServerGroup(serverGroup.getId());
    }

    public boolean isInputHardware() {
        return this.getBoolean(ClientProperty.CLIENT_INPUT_HARDWARE);
    }

    public boolean isInputMuted() {
        return this.getBoolean(ClientProperty.CLIENT_INPUT_MUTED);
    }

    public boolean isOutputHardware() {
        return this.getBoolean(ClientProperty.CLIENT_OUTPUT_HARDWARE);
    }

    public boolean isOutputMuted() {
        return this.getBoolean(ClientProperty.CLIENT_OUTPUT_MUTED);
    }

    public boolean isPrioritySpeaker() {
        return this.getBoolean(ClientProperty.CLIENT_IS_PRIORITY_SPEAKER);
    }

    public boolean isRecording() {
        return this.getBoolean(ClientProperty.CLIENT_IS_RECORDING);
    }

    public boolean isRegularClient() {
        return this.getType() == 0;
    }

    public boolean isServerQueryClient() {
        return this.getType() == 1;
    }

    public boolean isTalking() {
        return this.getBoolean("client_flag_talking");
    }
}

