/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.KeepAliveThread;
import com.github.theholywaffle.teamspeak3.SocketReader;
import com.github.theholywaffle.teamspeak3.SocketWriter;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.Callback;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueryIO {
    private final Socket socket;
    private final SocketReader socketReader;
    private final SocketWriter socketWriter;
    private final KeepAliveThread keepAlive;
    private final Queue<Command> commandQueue = new ConcurrentLinkedQueue<Command>();
    private final Map<Command, Callback> callbackMap = Collections.synchronizedMap(new LinkedHashMap(16));

    QueryIO(TS3Query query, TS3Config config) {
        Socket tmpSocket = null;
        try {
            this.socket = tmpSocket = new Socket(config.getHost(), config.getQueryPort());
            this.socketReader = new SocketReader(query, this);
            this.socketWriter = new SocketWriter(this, config.getFloodRate().getMs());
            this.keepAlive = new KeepAliveThread(this.socketWriter, query.getAsyncApi());
        }
        catch (IOException e) {
            if (tmpSocket != null) {
                try {
                    tmpSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new TS3ConnectionFailedException(e);
        }
        this.socketReader.start();
        this.socketWriter.start();
        this.keepAlive.start();
    }

    public void continueFrom(QueryIO io) {
        if (io == null || io.commandQueue.isEmpty()) {
            return;
        }
        this.callbackMap.putAll(io.callbackMap);
        Command lastSent = io.commandQueue.poll();
        this.commandQueue.add(lastSent.reset());
        this.commandQueue.addAll(io.commandQueue);
        io.commandQueue.clear();
        io.callbackMap.clear();
    }

    public void disconnect() {
        this.keepAlive.interrupt();
        this.socketWriter.interrupt();
        this.socketReader.interrupt();
        try {
            this.keepAlive.join();
            this.socketWriter.join();
            this.socketReader.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void queueCommand(Command command, Callback callback) {
        if (command == null) {
            throw new NullPointerException("Command cannot be null!");
        }
        if (callback != null) {
            this.callbackMap.put(command, callback);
        }
        this.commandQueue.add(command);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Map<Command, Callback> getCallbackMap() {
        return this.callbackMap;
    }

    public Queue<Command> getCommandQueue() {
        return this.commandQueue;
    }
}

