/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.util.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.dzikoysk.wildskript.WildSkript;
import net.dzikoysk.wildskript.util.doc.Element;
import net.dzikoysk.wildskript.util.doc.ElementMap;
import net.dzikoysk.wildskript.util.doc.Type;

public class Documentation {
    private static List<Element> events = new ArrayList<Element>();
    private static List<Element> effects = new ArrayList<Element>();
    private static List<Element> conditions = new ArrayList<Element>();
    private static List<Element> expressions = new ArrayList<Element>();
    private static List<Element> types = new ArrayList<Element>();
    private static List<Element> eventvalues = new ArrayList<Element>();
    private static List<Element> desc = new ArrayList<Element>();
    private static ElementMap<String, List<Element>> collections = new ElementMap();
    private static ElementMap<String, List<Element>> objects = new ElementMap();
    private static ElementMap<String, List<Element>> plugins = new ElementMap();
    private static File doc = new File(WildSkript.getInstance().getDataFolder() + File.separator + "doc");

    public static void addElement(Element e) {
        new ElementMap();
        switch (e.getType()) {
            case EFFECT: {
                effects.add(e);
                break;
            }
            case CONDITION: {
                conditions.add(e);
                break;
            }
            case EVENT: {
                events.add(e);
                break;
            }
            case EXPRESSION: {
                expressions.add(e);
                break;
            }
            case COLLECTION: {
                collections.add(e);
                break;
            }
            case OBJECT: {
                objects.add(e);
                break;
            }
            case PLUGIN: {
                plugins.add(e);
                break;
            }
            case TYPE: {
                types.add(e);
                break;
            }
            case EVENT_VALUE: {
                eventvalues.add(e);
                break;
            }
            case DESC: {
                desc.add(e);
                break;
            }
            case NO_DOC: {
                break;
            }
        }
    }

    public static void generate() {
        Documentation.deleteFolder(doc);
        Documentation.index();
        Documentation.single();
        Documentation.mindex();
        Documentation.multiple();
        Documentation.css();
    }

    private static void single() {
        List[] lists;
        for (List l : lists = new List[]{events, conditions, effects, expressions, types}) {
            String name = ((Element)l.get(0)).getType().getName();
            String head = Documentation.singleHead(name);
            String list = Documentation.singleList(l);
            String patterns = Documentation.singlePattern(l);
            String footer = Documentation.footer();
            Documentation.build(new File(doc + File.separator + name.toLowerCase() + ".html"), new String[]{head, list, patterns, footer});
        }
    }

    private static void multiple() {
        ElementMap[] maps;
        for (ElementMap ep : maps = new ElementMap[]{collections, objects}) {
            for (Map.Entry<String, List<Element>> entry : ep.entrySet()) {
                Type type = entry.getValue().get(0).getType();
                String title = entry.getKey();
                String head = Documentation.multipleHead(type, title);
                String body = Documentation.multipleBody(title, entry.getValue());
                String footer = Documentation.footer();
                Documentation.build(new File(doc + File.separator + type.getName().toLowerCase() + File.separator + title + ".html"), new String[]{head, body, footer});
            }
        }
    }

    private static String singleHead(String title) {
        InputStream is = Documentation.resource("doc/single/header.txt");
        String s = Documentation.isS(is);
        String head = s.replace("{TITLE}", title);
        return head;
    }

    private static String singleList(List<Element> list) {
        InputStream is = Documentation.resource("doc/single/list.txt");
        String template = Documentation.isS(is);
        StringBuilder sb = new StringBuilder("");
        Collections.sort(list);
        for (Element e : list) {
            String name = e.getName();
            sb.append("<a href=\"#" + name + '\"' + " class=" + '\"' + "list-b" + '\"' + ">" + name + "</a>");
        }
        sb.append(template);
        return sb.toString();
    }

    private static String singlePattern(List<Element> pattern) {
        InputStream is = Documentation.resource("doc/single/pattern.txt");
        String tmp = Documentation.isS(is);
        ArrayList<String> ptr = new ArrayList<String>();
        Collections.sort(pattern);
        for (Element e : pattern) {
            String b = tmp.replace("{NAME}", e.getName()).replace("{USAGE}", Documentation.updateClasses(e.getUsage())).replace("{VERSION}", e.getVersion()).replace("{DESC}", e.getDesc()).replace("{EXAMPLE}", e.getExample());
            ptr.add(b);
        }
        StringBuilder sb = new StringBuilder("");
        for (String s : ptr) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static String multipleHead(Type type, String title) {
        InputStream is = Documentation.resource("doc/multiple/header.txt");
        String s = Documentation.isS(is);
        StringBuilder sb = new StringBuilder("");
        if (type == Type.COLLECTION) {
            for (String name : collections.keySet()) {
                sb.append("<a href=\"./" + name + ".html" + '\"' + " class=" + '\"' + "menu-link" + '\"' + '>' + name + " </a> \n");
            }
        } else if (type == Type.OBJECT) {
            for (String name : objects.keySet()) {
                sb.append("<a href=\"./" + name + ".html" + '\"' + " class=" + '\"' + "menu-link" + '\"' + '>' + name + " </a> \n");
            }
        }
        String head = s.replace("{TITLE}", title).replace("{LIST}", sb.toString());
        return head;
    }

    private static String multipleBody(String name, List<Element> es) {
        InputStream is = Documentation.resource("doc/multiple/body.txt");
        String tmp = Documentation.isS(is);
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        for (Element e : es) {
            if (i == 0) {
                sb.append(e.getDesc() + " \n" + e.getExample());
            } else {
                sb.append("\n \n" + e.getDesc() + " \n" + e.getExample());
            }
            ++i;
        }
        Element esc = null;
        for (Element ef : desc) {
            if (!ef.getName().equalsIgnoreCase(name)) continue;
            esc = ef;
        }
        return tmp.replace("{DESC}", esc.getDesc()).replace("{CONTENT}", sb.toString());
    }

    private static void index() {
        InputStream index = Documentation.resource("doc/index.txt");
        Documentation.copy(index, new File(doc + File.separator + "index.html"));
    }

    private static void mindex() {
        String chead = Documentation.multipleHead(Type.COLLECTION, "Collections");
        String ohead = Documentation.multipleHead(Type.OBJECT, "Objects");
        String cindex = Documentation.isS(Documentation.resource("doc/multiple/cindex.txt"));
        String oindex = Documentation.isS(Documentation.resource("doc/multiple/oindex.txt"));
        String footer = Documentation.footer();
        Documentation.build(new File(doc + File.separator + "collections" + File.separator + "index.html"), new String[]{chead, cindex, footer});
        Documentation.build(new File(doc + File.separator + "objects" + File.separator + "index.html"), new String[]{ohead, oindex, footer});
    }

    private static void css() {
        InputStream css = WildSkript.getInstance().getResource("doc/css/style.css");
        InputStream bebas = WildSkript.getInstance().getResource("doc/css/BebasNeueRegular.ttf");
        InputStream kirvy = WildSkript.getInstance().getResource("doc/css/Kirvy-Regular.otf");
        InputStream icon = WildSkript.getInstance().getResource("doc/css/favicon.ico");
        Documentation.copy(css, new File(doc + File.separator + "css" + File.separator + "style.css"));
        Documentation.copy(bebas, new File(doc + File.separator + "css" + File.separator + "BebasNeueRegular.ttf"));
        Documentation.copy(kirvy, new File(doc + File.separator + "css" + File.separator + "Kirvy-Regular.otf"));
        Documentation.copy(icon, new File(doc + File.separator + "css" + File.separator + "favicon.ico"));
    }

    private static void build(File file, String[] t) {
        try {
            file.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(file);
            StringBuilder sb = new StringBuilder("");
            for (String s : t) {
                sb.append(s + "\n");
            }
            fw.write(sb.toString());
            fw.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private static String footer() {
        InputStream is = Documentation.resource("doc/footer.txt");
        String footer = Documentation.isS(is);
        return footer;
    }

    private static String updateClasses(String s) {
        String[] classes;
        for (String type : classes = new String[]{"string", "player", "number", "location", "entity"}) {
            s = s.replace("%" + type + "%", "%<a href=\"http://njol.ch/projects/skript/doc/classes/#" + type + '\"' + "class=" + '\"' + "a" + '\"' + ">" + type + "</a>%");
        }
        return s;
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Documentation.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    private static void copy(InputStream in, File file) {
        try {
            int len;
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String isS(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static InputStream resource(String dir) {
        return WildSkript.getInstance().getResource(dir);
    }
}

