/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Bukkit;

public class MetricsLite {
    private static List<MetricsLite> list = new ArrayList<MetricsLite>();
    private static final int REVISION = 7;
    private static final String BASE_URL = "http://report.mcstats.org";
    private static final String REPORT_URL = "/plugin/%s";
    private static final int PING_INTERVAL = 10;
    private final Object optOutLock = new Object();
    private Timer timer;
    private final String name;
    private String version;

    private MetricsLite(String name) {
        this.name = name;
        this.timer = new Timer();
        list.add(this);
    }

    public static MetricsLite get(String name) {
        for (MetricsLite mcs : list) {
            if (!mcs.getName().equalsIgnoreCase(name)) continue;
            return mcs;
        }
        return new MetricsLite(name);
    }

    public MetricsLite version(String version) {
        this.version = version;
        return this;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                return false;
            }
            if (this.timer != null) {
                return true;
            }
            this.timer.schedule(new TimerTask(){
                private boolean firstPost = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = MetricsLite.this.optOutLock;
                        synchronized (object) {
                            if (MetricsLite.this.isOptOut() && MetricsLite.this.timer != null) {
                                MetricsLite.this.timer.cancel();
                                MetricsLite.this.timer = null;
                            }
                        }
                        MetricsLite.this.postPlugin(!this.firstPost);
                        this.firstPost = false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, 0L, 12000L);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptOut() {
        Object object = this.optOutLock;
        synchronized (object) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.timer == null) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    private void postPlugin(boolean isPing) throws IOException {
        String pluginName = "WS " + this.name;
        boolean onlineMode = Bukkit.getOnlineMode();
        String pluginVersion = this.version;
        String serverVersion = Bukkit.getVersion();
        int playersOnline = Bukkit.getOnlinePlayers().size();
        StringBuilder json = new StringBuilder(1024);
        json.append('{');
        MetricsLite.appendJSONPair(json, "guid", pluginName);
        MetricsLite.appendJSONPair(json, "plugin_version", pluginVersion);
        MetricsLite.appendJSONPair(json, "server_version", serverVersion);
        MetricsLite.appendJSONPair(json, "players_online", Integer.toString(playersOnline));
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        String java_version = System.getProperty("java.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (osarch.equals("amd64")) {
            osarch = "x86_64";
        }
        MetricsLite.appendJSONPair(json, "osname", osname);
        MetricsLite.appendJSONPair(json, "osarch", osarch);
        MetricsLite.appendJSONPair(json, "osversion", osversion);
        MetricsLite.appendJSONPair(json, "cores", Integer.toString(coreCount));
        MetricsLite.appendJSONPair(json, "auth_mode", onlineMode ? "1" : "0");
        MetricsLite.appendJSONPair(json, "java_version", java_version);
        if (isPing) {
            MetricsLite.appendJSONPair(json, "ping", "1");
        }
        json.append('}');
        URL url = new URL(BASE_URL + String.format(REPORT_URL, MetricsLite.urlEncode(pluginName)));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        byte[] compressed = MetricsLite.gzip(json.toString());
        connection.addRequestProperty("User-Agent", "MCStats/7");
        connection.addRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", Integer.toString(compressed.length));
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.setDoOutput(true);
        OutputStream os = connection.getOutputStream();
        os.write(compressed);
        os.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        os.close();
        reader.close();
        if (response == null || response.startsWith("ERR") || response.startsWith("7")) {
            if (response == null) {
                response = "null";
            } else if (response.startsWith("7")) {
                response = response.substring(response.startsWith("7,") ? 2 : 1);
            }
            throw new IOException(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(String input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = null;
        try {
            gzos = new GZIPOutputStream(baos);
            gzos.write(input.getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzos != null) {
                try {
                    gzos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void appendJSONPair(StringBuilder json, String key, String value) throws UnsupportedEncodingException {
        boolean isValueNumeric = false;
        try {
            if (value.equals("0") || !value.endsWith("0")) {
                Double.parseDouble(value);
                isValueNumeric = true;
            }
        }
        catch (NumberFormatException e) {
            isValueNumeric = false;
        }
        if (json.charAt(json.length() - 1) != '{') {
            json.append(',');
        }
        json.append(MetricsLite.escapeJSON(key));
        json.append(':');
        if (isValueNumeric) {
            json.append(value);
        } else {
            json.append(MetricsLite.escapeJSON(value));
        }
    }

    private static String escapeJSON(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        block7: for (int index = 0; index < text.length(); ++index) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\"': 
                case '\\': {
                    builder.append('\\');
                    builder.append(chr);
                    continue block7;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block7;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block7;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block7;
                }
                default: {
                    if (chr < ' ') {
                        String t = "000" + Integer.toHexString(chr);
                        builder.append("\\u" + t.substring(t.length() - 4));
                        continue block7;
                    }
                    builder.append(chr);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }

    private static String urlEncode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }
}

