/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.classes;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import javax.annotation.Nullable;
import net.dzikoysk.wildskript.objects.region.Regions;
import net.dzikoysk.wildskript.objects.region.RegionsUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class RegionClasses {
    public static String toS(Location loc) {
        StringBuilder b = new StringBuilder("");
        b.append(loc.getBlockX() + ";");
        b.append(loc.getBlockY() + ";");
        b.append(loc.getBlockZ() + ";");
        b.append(loc.getWorld());
        return b.toString();
    }

    public static Location fromS(String s) {
        String[] t = s.split(";");
        int x = Integer.parseInt(t[0]);
        int y = Integer.parseInt(t[1]);
        int z = Integer.parseInt(t[2]);
        World w = Bukkit.getWorld((String)t[3]);
        return new Location(w, (double)x, (double)y, (double)z);
    }

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(Regions.class, "regions").user(new String[]{"regions"}).name("WildSkript Regions").description(new String[]{"WildSkript Regions"}).usage(new String[]{"..."}).examples(new String[]{""}).since("1.5").parser((Parser)new Parser<Regions>(){

            @Nullable
            public Regions parse(String s, ParseContext context) {
                return RegionsUtils.get(s);
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toVariableNameString(Regions r) {
                StringBuilder b = new StringBuilder("region:");
                String id = r.getID();
                String c = RegionClasses.toS(r.getCenter());
                String l = RegionClasses.toS(r.getL());
                String p = RegionClasses.toS(r.getP());
                String w = r.getWorld().getName();
                if (id == null) {
                    return null;
                }
                if (c == null) {
                    c = "";
                }
                if (l == null) {
                    l = "";
                }
                if (p == null) {
                    p = "";
                }
                if (w == null) {
                    w = "";
                }
                b.append(id + ",");
                b.append(c + ",");
                b.append(r.getSize() + ",");
                b.append(l + ",");
                b.append(p + ",");
                b.append(w + ",");
                return b.toString();
            }

            public String getVariableNamePattern() {
                return "region:.+";
            }

            public String toString(Regions r, int flags) {
                return r.getID();
            }
        }).serializer((Serializer)new Serializer<Regions>(){

            @Nullable
            public Fields serialize(Regions r) {
                Fields f = new Fields();
                String id = r.getID();
                Location c = r.getCenter();
                Location l = r.getL();
                Location p = r.getP();
                World w = r.getWorld();
                f.putObject("id", (Object)id);
                f.putObject("center", (Object)c);
                f.putObject("size", (Object)r.getSize());
                f.putObject("l", (Object)l);
                f.putObject("p", (Object)p);
                f.putObject("world", (Object)w);
                return f;
            }

            public void deserialize(Regions r, Fields f) {
                assert (false);
            }

            protected Regions deserialize(Fields fields) throws StreamCorruptedException {
                String id = (String)fields.getObject("id", String.class);
                Location c = (Location)fields.getObject("center", Location.class);
                Integer s = (Integer)fields.getObject("size", Integer.class);
                Location l = (Location)fields.getObject("l", Location.class);
                Location p = (Location)fields.getObject("p", Location.class);
                World w = (World)fields.getObject("world", World.class);
                if (id == null) {
                    throw new StreamCorruptedException();
                }
                Regions r = RegionsUtils.get(id);
                if (c != null) {
                    r.setCenter(c);
                }
                if (s != null) {
                    r.setSize(s);
                }
                if (l != null) {
                    r.setL(l);
                }
                if (p != null) {
                    r.setP(p);
                }
                if (w != null) {
                    r.setWorld(w);
                }
                if (r == null) {
                    throw new StreamCorruptedException();
                }
                return r;
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            public boolean canBeInstantiated(Class<? extends Regions> c) {
                return false;
            }

            public Regions deserialize(String x) {
                String d = x.replaceAll("region:", "");
                String[] t = d.split(",");
                Regions region = RegionsUtils.get(t[0]);
                Location c = null;
                int s = 0;
                Location l = null;
                Location p = null;
                World w = null;
                if (!t[1].equals("")) {
                    c = RegionClasses.fromS(t[1]);
                }
                if (!t[2].equals("")) {
                    s = Integer.valueOf(t[2]);
                }
                if (!t[3].equals("")) {
                    l = RegionClasses.fromS(t[3]);
                }
                if (!t[4].equals("")) {
                    p = RegionClasses.fromS(t[4]);
                }
                if (!t[5].equals("")) {
                    w = Bukkit.getWorld((String)t[5]);
                }
                region.setCenter(c);
                region.setSize(s);
                region.setL(l);
                region.setP(p);
                region.setWorld(w);
                return region;
            }
        }));
    }
}

