/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.objects.tab;

import java.util.ArrayList;
import java.util.List;
import net.dzikoysk.wildskript.objects.tab.TabUtils;

public class Tab {
    private final String id;
    private final String[] prefix;
    private final String[] center;
    private final String[] suffix;
    private List<String> fields;
    private String[][] backup;
    private boolean sent;

    protected Tab(String id) {
        this.id = id;
        this.prefix = new String[60];
        this.center = new String[60];
        this.suffix = new String[60];
        this.fields = new ArrayList<String>();
        TabUtils.add(this);
    }

    public void set(int i, String s) {
        if (i >= 60) {
            return;
        }
        String[] ss = s.split("(?<=\\G................)");
        if (ss.length >= 3) {
            this.prefix[i] = ss[0];
            this.center[i] = ss[1];
            this.suffix[i] = ss[2];
        } else if (ss.length == 2) {
            this.prefix[i] = ss[0];
            this.center[i] = ss[1];
            this.suffix[i] = "";
        } else if (ss.length == 1) {
            this.prefix[i] = "";
            this.center[i] = ss[0];
            this.suffix[i] = "";
        }
    }

    public void fill() {
        int i = 0;
        while (i < this.center.length) {
            if (this.center[i] == null || this.center[i].isEmpty()) {
                this.center[i] = TabUtils.uniqueField(this);
            }
            if (this.prefix[i] == null) {
                this.prefix[i] = "";
            }
            if (this.suffix[i] == null) {
                this.suffix[i] = "";
            }
            ++i;
        }
    }

    protected void fields(List<String> fields) {
        this.fields = fields;
    }

    public void backup(String[] prefix, String[] center, String[] suffix) {
        this.backup = new String[][]{(String[])prefix.clone(), (String[])center.clone(), (String[])suffix.clone()};
    }

    public void backup() {
        this.backup = new String[][]{(String[])this.prefix.clone(), (String[])this.center.clone(), (String[])this.suffix.clone()};
    }

    public void sent(boolean b) {
        this.sent = b;
    }

    public boolean isSent() {
        return this.sent;
    }

    public String[][] getRows() {
        return new String[][]{(String[])this.prefix.clone(), (String[])this.center.clone(), (String[])this.suffix.clone()};
    }

    public String[] getPrefix() {
        return (String[])this.prefix.clone();
    }

    public String[] getCenter() {
        return (String[])this.center.clone();
    }

    public String[] getSuffix() {
        return (String[])this.suffix.clone();
    }

    public String[][] getBackup() {
        return (String[][])this.backup.clone();
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getID() {
        return this.id;
    }
}

