/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.objects.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.bukkit.Bukkit;

public class MySQL {
    public static ArrayList<MySQL> list = new ArrayList();
    private final String id;
    private final String user;
    private final String database;
    private final String password;
    private final String port;
    private final String hostname;
    private Connection connection;

    public MySQL(String id, String hostname, String port, String database, String username, String password) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.user = username;
        this.password = password;
        this.connection = null;
        list.add(this);
    }

    public static MySQL get(String id) {
        for (MySQL sql : list) {
            if (!sql.getID().equals(id)) continue;
            return sql;
        }
        return null;
    }

    public String getID() {
        return this.id;
    }

    public Connection openConnection() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database, this.user, this.password);
        }
        catch (SQLException e) {
            Bukkit.getLogger().severe("Could not connect to MySQL server! because: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().severe("JDBC Driver not found!");
        }
        return this.connection;
    }

    public boolean checkConnection() {
        return this.connection != null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                Bukkit.getLogger().severe("Error closing the MySQL Connection!");
                e.printStackTrace();
            }
        }
    }

    public ResultSet querySQL(String query) {
        Connection c = null;
        c = this.checkConnection() ? this.getConnection() : this.openConnection();
        Statement s = null;
        try {
            s = c.createStatement();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        ResultSet ret = null;
        try {
            ret = s.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.closeConnection();
        return ret;
    }

    public void updateSQL(String[] update) {
        Connection c = null;
        c = this.checkConnection() ? this.getConnection() : this.openConnection();
        Statement s = null;
        try {
            s = c.createStatement();
            String[] stringArray = update;
            int n = update.length;
            int n2 = 0;
            while (n2 < n) {
                String u = stringArray[n2];
                s.executeUpdate(u);
                ++n2;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.closeConnection();
    }

    public String[] getAll() {
        return new String[]{this.hostname, this.port, this.database, this.user, this.password};
    }
}

