/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.objects.hologram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dzikoysk.wildskript.WildSkript;
import net.dzikoysk.wildskript.util.PacketUtils;
import net.dzikoysk.wildskript.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Hologram {
    public static List<Hologram> holograms = new ArrayList<Hologram>();
    private static final double distance = 0.23;
    private String id;
    private List<String> lines;
    private List<Integer> ids;
    private boolean showing;
    private Location location;

    public Hologram(String id) {
        this.id = id;
        this.lines = new ArrayList<String>();
        this.ids = new ArrayList<Integer>();
        holograms.add(this);
    }

    public static Hologram get(String id) {
        for (Hologram h : holograms) {
            if (!h.getID().equals(id)) continue;
            return h;
        }
        return new Hologram(id);
    }

    public void change(String[] lines) {
        this.lines.clear();
        if (this.showing) {
            try {
                this.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.lines.add(s);
                ++n2;
            }
            if (this.location != null) {
                this.show(this.location);
            }
            return;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n3 = 0;
        while (n3 < n) {
            String s = stringArray[n3];
            this.lines.add(s);
            ++n3;
        }
    }

    public void show(Location loc) {
        if (this.showing) {
            return;
        }
        if (this.lines == null) {
            return;
        }
        Location first = loc.clone().add(0.0, (double)(this.lines.size() / 2) * 0.23, 0.0);
        int i = 0;
        while (i < this.lines.size()) {
            this.ids.addAll(Hologram.showLine(first.clone(), this.lines.get(i)));
            first.subtract(0.0, 0.23, 0.0);
            ++i;
        }
        this.showing = true;
        this.location = loc;
    }

    public void show(Location loc, int sec) {
        this.show(loc);
        new BukkitRunnable(){

            public void run() {
                try {
                    Hologram.this.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.runTaskLater((Plugin)WildSkript.getInstance(), (long)(sec * 20));
    }

    public void destroy() throws Exception {
        if (!this.showing) {
            return;
        }
        int[] ints = new int[this.ids.size()];
        int j = 0;
        while (j < ints.length) {
            if (j != 0) {
                ints[j] = this.ids.get(j);
            }
            ++j;
        }
        Class<?> packetDestroy = ReflectionUtils.getCraftClass("PacketPlayOutEntityDestroy");
        Object packet = packetDestroy.getConstructor(int[].class).newInstance(new Object[]{ints});
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            PacketUtils.sendPacket(p, packet);
            ++n2;
        }
        this.showing = false;
        this.location = null;
        this.ids.clear();
    }

    private static List<Integer> showLine(Location loc, String text) {
        Class<?> Entity2 = ReflectionUtils.getCraftClass("Entity");
        Class<?> EntityLiving = ReflectionUtils.getCraftClass("EntityLiving");
        Class<?> EntityWitherSkull = ReflectionUtils.getCraftClass("EntityWitherSkull");
        Class<?> EntityHorse = ReflectionUtils.getCraftClass("EntityHorse");
        Class<?> packetOnlyClass = ReflectionUtils.getCraftClass("PacketPlayOutSpawnEntity");
        Class<?> packetLivingClass = ReflectionUtils.getCraftClass("PacketPlayOutSpawnEntityLiving");
        Class<?> packetAttachClass = ReflectionUtils.getCraftClass("PacketPlayOutAttachEntity");
        try {
            Object world = ReflectionUtils.getHandle(loc.getWorld());
            Object skull = EntityWitherSkull.getConstructor(ReflectionUtils.getCraftClass("World")).newInstance(world);
            ReflectionUtils.getMethod(EntityWitherSkull, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).invoke(skull, loc.getX(), loc.getY() + 1.0 + 55.0, loc.getZ(), 0, 0);
            Object skull_packet = packetOnlyClass.getConstructor(Entity2, Integer.TYPE).newInstance(skull, 64);
            Object horse = EntityHorse.getConstructor(ReflectionUtils.getCraftClass("World")).newInstance(world);
            ReflectionUtils.getMethod(EntityHorse, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).invoke(horse, loc.getX(), loc.getY() + 55.0, loc.getZ(), 0, 0);
            ReflectionUtils.getMethod(EntityHorse, "setAge", Integer.TYPE).invoke(horse, -1700000);
            ReflectionUtils.getMethod(EntityHorse, "setCustomName", String.class).invoke(horse, text);
            ReflectionUtils.getMethod(EntityHorse, "setCustomNameVisible", Boolean.TYPE).invoke(horse, true);
            Object packedt = packetLivingClass.getConstructor(EntityLiving).newInstance(horse);
            for (Player player : loc.getWorld().getPlayers()) {
                PacketUtils.sendPacket(player, packedt);
                PacketUtils.sendPacket(player, skull_packet);
                Object pa = packetAttachClass.getConstructor(Integer.TYPE, Entity2, Entity2).newInstance(0, horse, skull);
                PacketUtils.sendPacket(player, pa);
            }
            int sid = (Integer)ReflectionUtils.getMethod(EntityWitherSkull, "getId").invoke(skull, new Object[0]);
            int hid = (Integer)ReflectionUtils.getMethod(EntityHorse, "getId").invoke(horse, new Object[0]);
            return Arrays.asList(sid, hid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void delete() {
        holograms.remove(this);
        try {
            this.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getID() {
        return this.id;
    }
}

