/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript;

import ch.njol.skript.Skript;
import java.io.IOException;
import net.dzikoysk.wildskript.events.PlayerJoin;
import net.dzikoysk.wildskript.events.PlayerMove;
import net.dzikoysk.wildskript.events.ServerPing;
import net.dzikoysk.wildskript.objects.inventory.InventoryEvent;
import net.dzikoysk.wildskript.objects.recipe.RecipesEvent;
import net.dzikoysk.wildskript.objects.recipe.ResultEvent;
import net.dzikoysk.wildskript.register.Register;
import net.dzikoysk.wildskript.util.Metrics;
import net.dzikoysk.wildskript.util.User;
import net.dzikoysk.wildskript.util.WildSkriptTimer;
import net.dzikoysk.wildskript.util.data.Data;
import net.dzikoysk.wildskript.util.doc.Documentation;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WildSkript
extends JavaPlugin {
    private static WildSkript wildskript;
    public static String version;
    public static boolean debug;
    private static boolean enable;
    private static boolean skQuery;
    private static boolean randomSk;
    private static WildSkriptTimer timer;

    public void onEnable() {
        wildskript = this;
        if (this.cannot()) {
            return;
        }
        Data.load();
        this.bungee();
        this.utils();
        Bukkit.getPluginManager().registerEvents((Listener)new ServerPing(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryEvent(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerMove(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new RecipesEvent(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ResultEvent(), (Plugin)this);
        Skript.registerAddon((JavaPlugin)this);
        Register.register();
        if (Data.doc) {
            Documentation.generate();
        }
        if (Data.mcstats) {
            this.metrics();
        }
        WildSkript.log("~ Created by & \u00a9 Dzikoysk ~");
    }

    private boolean cannot() {
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (plugin.getName().equalsIgnoreCase("skQuery")) {
                WildSkript.log("skQuery hooked!");
                skQuery = true;
            }
            if (plugin.getName().equalsIgnoreCase("randomSk")) {
                WildSkript.log("RandomSK hooked!");
                randomSk = true;
            }
            if (plugin.getName().equalsIgnoreCase("llc")) {
                WildSkript.severe("Unsupported Skript addon (LLC)! Disabling WildSkript ... ");
                return true;
            }
            ++n2;
        }
        enable = true;
        return false;
    }

    private void metrics() {
        try {
            Metrics metrics = new Metrics((Plugin)wildskript);
            Metrics.Graph global = metrics.createGraph("Global Statistics Linear");
            global.addPlotter(new Metrics.Plotter("Servers"){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            global.addPlotter(new Metrics.Plotter("Players"){

                @Override
                public int getValue() {
                    return Bukkit.getOnlinePlayers().length;
                }
            });
            metrics.addGraph(global);
            metrics.start();
        }
        catch (IOException e) {
            WildSkript.log(e.getMessage());
        }
    }

    private void bungee() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)wildskript, "BungeeCord");
    }

    private void utils() {
        timer = new WildSkriptTimer();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)timer, 1000L, 50L);
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            User.get(p);
            ++n2;
        }
    }

    public static void log(String log) {
        Bukkit.getLogger().info("[WildSkript] " + log);
    }

    public static void severe(String log) {
        Bukkit.getLogger().severe("[WildSkript][Error] #!#");
        Bukkit.getLogger().severe("[WildSkript][Error] #!# =!!!======{ WildSkript Error }======!!!=");
        Bukkit.getLogger().severe("[WildSkript][Error] #!# " + log);
        Bukkit.getLogger().severe("[WildSkript][Error] #!#");
        Bukkit.getLogger().severe("[WildSkript][Error] #!#");
    }

    public static WildSkript getInstance() {
        return wildskript;
    }

    public static String getVersion() {
        return version;
    }

    public static WildSkriptTimer getTimer() {
        return timer;
    }

    public static boolean skQuery() {
        return skQuery;
    }

    public static boolean randomSk() {
        return randomSk;
    }

    public static boolean enabled() {
        return enable;
    }

    public static boolean debug() {
        return debug;
    }
}

