/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class ReflectionUtils {
    public static Class<?> getCraftClass(String ClassName) {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String version = String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + ".";
        String className = "net.minecraft.server." + version + ClassName;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public static Object getHandle(Entity entity) {
        try {
            return ReflectionUtils.getMethod(entity.getClass(), "getHandle").invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getHandle(World world) {
        try {
            return ReflectionUtils.getMethod(world.getClass(), "getHandle").invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getField(Class<?> cl, String field_name) {
        try {
            return cl.getDeclaredField(field_name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getMethod(Class<?> cl, String method, Class<?> ... args) {
        Method[] methodArray = cl.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(method) && ReflectionUtils.ClassListEqual(args, m.getParameterTypes())) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    public static Method getMethod(Class<?> cl, String method) {
        Method[] methodArray = cl.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(method)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    public static boolean ClassListEqual(Class<?>[] l1, Class<?>[] l2) {
        boolean equal = true;
        if (l1.length != l2.length) {
            return false;
        }
        int i = 0;
        while (i < l1.length) {
            if (l1[i] != l2[i]) {
                equal = false;
                break;
            }
            ++i;
        }
        return equal;
    }
}

