/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.objects.tablist;

import java.util.ArrayList;
import java.util.Random;
import net.dzikoysk.wildskript.collections.packet.NMSPacket;
import net.dzikoysk.wildskript.collections.packet.PacketUtils;
import net.dzikoysk.wildskript.objects.tablist.TabListManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TabList {
    public static ArrayList<TabList> list = new ArrayList();
    public static String[] c = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    String id;
    int max;
    int interval;
    String[] scheme;
    String[] backup;
    ArrayList<String> fields = new ArrayList();
    boolean active = false;
    ArrayList<Player> players = new ArrayList();

    public TabList(String id) {
        this.id = id;
        this.initiate();
        list.add(this);
    }

    public void set(int i, String s) {
        if (i < 1 || i > this.max) {
            return;
        }
        if (s.length() > 16) {
            --i;
        }
        this.scheme[i] = s;
        this.refresh();
    }

    public void remove(int i) {
        if (i < 1 || i > this.max) {
            return;
        }
        this.scheme[i - 1] = null;
        this.refresh();
    }

    private void initiate() {
        int i = Bukkit.getMaxPlayers();
        i = i > 40 ? 60 : (i > 20 ? 40 : 20);
        this.max = i;
        this.scheme = new String[i];
    }

    public void refresh() {
        if (this.active) {
            ArrayList l = (ArrayList)this.players.clone();
            if (l == null || l.isEmpty()) {
                return;
            }
            for (Player p : l) {
                TabListManager.hidePlayer(p);
                this.reset(p);
                this.send(p);
            }
        }
    }

    public void send(Player p) {
        TabListManager.hidePlayers(p);
        int i = 0;
        while (i < this.max) {
            String s = this.scheme[i];
            if (s != null) {
                NMSPacket packet = new NMSPacket("PacketPlayOutPlayerInfo");
                packet.setDeclaredField("a", s);
                packet.setDeclaredField("b", true);
                packet.setDeclaredField("c", 0);
                PacketUtils.sendPacket(p, packet);
            } else {
                String field;
                this.scheme[i] = field = this.getUniqueField();
                NMSPacket packet = new NMSPacket("PacketPlayOutPlayerInfo");
                packet.setDeclaredField("a", field);
                packet.setDeclaredField("b", true);
                packet.setDeclaredField("c", 0);
                PacketUtils.sendPacket(p, packet);
            }
            ++i;
        }
        this.backup = this.scheme;
        this.active = true;
        this.players.add(p);
    }

    public void reset(Player p) {
        int i = 0;
        while (i < this.max) {
            String s = this.backup[i];
            if (s != null) {
                NMSPacket packet = new NMSPacket("PacketPlayOutPlayerInfo");
                packet.setDeclaredField("a", s);
                packet.setDeclaredField("b", false);
                packet.setDeclaredField("c", 0);
                PacketUtils.sendPacket(p, packet);
            }
            ++i;
        }
        this.active = false;
        this.players.remove(p);
        TabListManager.displayPlayers(p);
    }

    public void delete() {
        list.remove(this);
        this.id = null;
        this.scheme = null;
        this.players = null;
    }

    public String getID() {
        return this.id;
    }

    public ArrayList<Player> getPlayers() {
        return this.players;
    }

    private String getUniqueField() {
        Random random = new Random();
        String s = "";
        if (!this.fields.contains(s)) {
            this.fields.add(s);
        }
        while (this.fields.contains(s)) {
            String r = c[random.nextInt(c.length)];
            if ((s = String.valueOf(s) + "\u00a7" + r).length() <= 16) continue;
            s = "";
        }
        this.fields.add(s);
        return s;
    }
}

