/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.objects.region;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class Regions {
    public static ArrayList<Regions> regions = new ArrayList();
    String id;
    Location center;
    World world;
    Location l;
    Location p;
    int size = 0;
    int height = 256;

    public Regions(String id) {
        this.id = id;
        regions.add(this);
    }

    public Regions(String id, Location loc, int size) {
        this.id = id;
        this.world = loc.getWorld();
        this.height = this.world.getMaxHeight();
        this.size = size;
        this.center = loc;
        regions.add(this);
        this.update();
    }

    public Regions(String id, Location loc1, Location loc2) {
        this.id = id;
        this.world = loc1.getWorld();
        this.height = this.world.getMaxHeight();
        this.l = loc1;
        this.p = loc2;
        regions.add(this);
    }

    public void update() {
        if (this.center != null && this.size > 0) {
            if (this.world == null) {
                this.world = Bukkit.getWorld((String)"world");
            }
            if (this.world != null) {
                int lx = this.center.getBlockX() + this.size;
                int lz = this.center.getBlockZ() + this.size;
                int px = this.center.getBlockX() - this.size;
                int pz = this.center.getBlockZ() - this.size;
                Vector l = new Vector(lx, 0, lz);
                Vector p = new Vector(px, this.height, pz);
                this.l = l.toLocation(this.world);
                this.p = p.toLocation(this.world);
            }
        }
    }

    public void setCenter(Location loc) {
        this.center = loc;
        this.world = loc.getWorld();
        this.update();
    }

    public void setSize(int i) {
        this.size = i;
        this.update();
    }

    public void setHeight(int i) {
        this.height = i;
        this.update();
    }

    public void setWorld(World world) {
        this.world = world;
        this.update();
    }

    public void setL(Location loc) {
        this.l = loc;
        this.update();
    }

    public void setP(Location loc) {
        this.p = loc;
        this.update();
    }

    public void delete() {
        regions.remove(this);
        this.id = null;
        this.world = null;
        this.center = null;
        this.l = null;
        this.p = null;
    }

    public boolean isIn(Location loc) {
        if (loc == null) {
            return false;
        }
        this.update();
        return loc.getBlockX() > this.getLowerX() && loc.getBlockX() < this.getUpperX() && loc.getBlockY() > this.getLowerY() && loc.getBlockY() < this.getUpperY() && loc.getBlockZ() > this.getLowerZ() && loc.getBlockZ() < this.getUpperZ();
    }

    public String getID() {
        return this.id;
    }

    public Location getCenter() {
        Location loc;
        if (this.center != null) {
            return this.center;
        }
        this.update();
        int x1 = this.getUpperX();
        int y1 = this.getLowerY();
        int z1 = this.getLowerZ();
        this.center = loc = new Location(this.world, (double)this.getLowerX() + (double)(x1 - this.getLowerX()) / 2.0, (double)this.getLowerY() + (double)(y1 - this.getLowerY()) / 2.0, (double)this.getLowerZ() + (double)(z1 - this.getLowerZ()) / 2.0);
        return this.center;
    }

    public int getSize() {
        return this.size;
    }

    public int getHeight() {
        return this.height;
    }

    public World getWorld() {
        return this.world;
    }

    public Location getL() {
        return this.l;
    }

    public Location getP() {
        return this.p;
    }

    public int getUpperX() {
        this.update();
        if (this.l == null || this.p == null) {
            return 0;
        }
        int x = this.l.getBlockX();
        int y = this.p.getBlockX();
        if (y < x) {
            return x;
        }
        return y;
    }

    public int getUpperY() {
        this.update();
        if (this.l == null || this.p == null) {
            return 0;
        }
        int x = this.l.getBlockY();
        int y = this.p.getBlockY();
        if (y < x) {
            return x;
        }
        return y;
    }

    public int getUpperZ() {
        this.update();
        if (this.l == null || this.p == null) {
            return 0;
        }
        int x = this.l.getBlockZ();
        int y = this.p.getBlockZ();
        if (y < x) {
            return x;
        }
        return y;
    }

    public int getLowerX() {
        int y;
        this.update();
        if (this.l == null || this.p == null) {
            return 0;
        }
        int x = this.l.getBlockX();
        if (x > (y = this.p.getBlockX())) {
            return y;
        }
        return x;
    }

    public int getLowerY() {
        int y;
        this.update();
        if (this.l == null || this.p == null) {
            return 0;
        }
        int x = this.l.getBlockY();
        if (x > (y = this.p.getBlockY())) {
            return y;
        }
        return x;
    }

    public int getLowerZ() {
        int y;
        this.update();
        if (this.l == null || this.p == null) {
            return 0;
        }
        int x = this.l.getBlockZ();
        if (x > (y = this.p.getBlockZ())) {
            return y;
        }
        return x;
    }
}

