/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.collections.bossbar;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.dzikoysk.wildskript.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BossHealthBar {
    public static HashMap<Player, Float> percents = new HashMap();
    public static HashMap<Player, String> texts = new HashMap();
    private static PlayerMap<FakeDragon> DRAGONS = new PlayerMap();

    public static boolean hasStatusBar(Player player) {
        return DRAGONS.containsKey(player) && DRAGONS.get(player) != null;
    }

    public static void removeStatusBar(Player player) {
        if (BossHealthBar.hasStatusBar(player)) {
            BossHealthBar.sendPacket(player, DRAGONS.get(player).getDestroyPacket());
            DRAGONS.remove(player);
            percents.remove(player);
            texts.remove(player);
        }
    }

    public static void setStatusBar(Player player, String text, float percent) {
        FakeDragon dragon;
        FakeDragon fakeDragon = dragon = DRAGONS.containsKey(player) ? DRAGONS.get(player) : null;
        if (text.length() > 64) {
            text = text.substring(0, 63);
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        if (percent < 0.05f) {
            percent = 0.05f;
        }
        if (text.isEmpty() && dragon != null) {
            BossHealthBar.removeStatusBar(player);
        }
        if (dragon == null) {
            dragon = new FakeDragon(player.getLocation().add(0.0, -200.0, 0.0), text, percent);
            BossHealthBar.sendPacket(player, dragon.getSpawnPacket());
            DRAGONS.put(player, dragon);
        } else {
            dragon.setName(text);
            dragon.setHealth(percent);
            BossHealthBar.sendPacket(player, dragon.getMetaPacket(dragon.getWatcher()));
            BossHealthBar.sendPacket(player, dragon.getTeleportPacket(player.getLocation().add(0.0, -200.0, 0.0)));
        }
        percents.put(player, Float.valueOf(percent));
        texts.put(player, text);
    }

    private static void sendPacket(Player player, Object packet) {
        try {
            Object nmsPlayer = ReflectionUtils.getHandle((Entity)player);
            Field connectionField = nmsPlayer.getClass().getField("playerConnection");
            Object connection = connectionField.get(nmsPlayer);
            Method sendPacket = ReflectionUtils.getMethod(connection.getClass(), "sendPacket");
            sendPacket.invoke(connection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class FakeDragon {
        private static final int MAX_HEALTH = 200;
        private int id;
        private int x;
        private int y;
        private int z;
        private int pitch = 0;
        private int yaw = 0;
        private byte xvel = 0;
        private byte yvel = 0;
        private byte zvel = 0;
        private float health;
        private boolean visible = false;
        private String name;
        private Object world;
        private Object dragon;

        public FakeDragon(Location loc, String name, float percent) {
            this.name = name;
            this.x = loc.getBlockX();
            this.y = loc.getBlockY();
            this.z = loc.getBlockZ();
            this.health = percent * 200.0f;
            this.world = ReflectionUtils.getHandle(loc.getWorld());
        }

        public void setHealth(float percent) {
            this.health = percent / 200.0f;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getSpawnPacket() {
            Class<?> Entity2 = ReflectionUtils.getCraftClass("Entity");
            Class<?> EntityLiving = ReflectionUtils.getCraftClass("EntityLiving");
            Class<?> EntityEnderDragon = ReflectionUtils.getCraftClass("EntityEnderDragon");
            try {
                this.dragon = EntityEnderDragon.getConstructor(ReflectionUtils.getCraftClass("World")).newInstance(this.world);
                ReflectionUtils.getMethod(EntityEnderDragon, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).invoke(this.dragon, this.x, this.y, this.z, this.pitch, this.yaw);
                ReflectionUtils.getMethod(EntityEnderDragon, "setInvisible", Boolean.TYPE).invoke(this.dragon, this.visible);
                ReflectionUtils.getMethod(EntityEnderDragon, "setCustomName", String.class).invoke(this.dragon, this.name);
                ReflectionUtils.getMethod(EntityEnderDragon, "setHealth", Float.TYPE).invoke(this.dragon, Float.valueOf(this.health));
                ReflectionUtils.getField(Entity2, "motX").set(this.dragon, this.xvel);
                ReflectionUtils.getField(Entity2, "motY").set(this.dragon, this.yvel);
                ReflectionUtils.getField(Entity2, "motZ").set(this.dragon, this.zvel);
                this.id = (Integer)ReflectionUtils.getMethod(EntityEnderDragon, "getId").invoke(this.dragon, new Object[0]);
                Class<?> packetClass = ReflectionUtils.getCraftClass("PacketPlayOutSpawnEntityLiving");
                return packetClass.getConstructor(EntityLiving).newInstance(this.dragon);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getDestroyPacket() {
            try {
                Class<?> packetClass = ReflectionUtils.getCraftClass("PacketPlayOutEntityDestroy");
                return packetClass.getConstructor(int[].class).newInstance(new Object[]{new int[]{this.id}});
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getMetaPacket(Object watcher) {
            try {
                Class<?> watcherClass = ReflectionUtils.getCraftClass("DataWatcher");
                Class<?> packetClass = ReflectionUtils.getCraftClass("PacketPlayOutEntityMetadata");
                return packetClass.getConstructor(Integer.TYPE, watcherClass, Boolean.TYPE).newInstance(this.id, watcher, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getTeleportPacket(Location loc) {
            try {
                Class<?> packetClass = ReflectionUtils.getCraftClass("PacketPlayOutEntityTeleport");
                return packetClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE).newInstance(this.id, loc.getBlockX() * 32, loc.getBlockY() * 32, loc.getBlockZ() * 32, (byte)((int)loc.getYaw() * 256 / 360), (byte)((int)loc.getPitch() * 256 / 360));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getWatcher() {
            Class<?> Entity2 = ReflectionUtils.getCraftClass("Entity");
            Class<?> DataWatcher = ReflectionUtils.getCraftClass("DataWatcher");
            try {
                Object watcher = DataWatcher.getConstructor(Entity2).newInstance(this.dragon);
                Method a = ReflectionUtils.getMethod(DataWatcher, "a", Integer.TYPE, Object.class);
                a.invoke(watcher, 0, this.visible ? (byte)0 : 32);
                a.invoke(watcher, 6, Float.valueOf(this.health));
                a.invoke(watcher, 7, 0);
                a.invoke(watcher, 8, (byte)0);
                a.invoke(watcher, 10, this.name);
                a.invoke(watcher, 11, (byte)1);
                return watcher;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class PlayerMap<V>
    implements Map<Player, V> {
        private final V defaultValue = null;
        private final Map<String, V> contents = new HashMap<String, V>();

        @Override
        public void clear() {
            this.contents.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof Player) {
                return this.contents.containsKey(((Player)key).getName());
            }
            if (key instanceof String) {
                return this.contents.containsKey(key);
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.contents.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Player, V>> entrySet() {
            HashSet<Map.Entry<Player, V>> toReturn = new HashSet<Map.Entry<Player, V>>();
            for (String name : this.contents.keySet()) {
                toReturn.add(new PlayerEntry(Bukkit.getPlayer((String)name), this.contents.get(name)));
            }
            return toReturn;
        }

        @Override
        public V get(Object key) {
            V result = null;
            if (key instanceof Player) {
                result = this.contents.get(((Player)key).getName());
            }
            if (key instanceof String) {
                result = this.contents.get(key);
            }
            return result == null ? (V)this.defaultValue : result;
        }

        @Override
        public boolean isEmpty() {
            return this.contents.isEmpty();
        }

        @Override
        public Set<Player> keySet() {
            HashSet<Player> toReturn = new HashSet<Player>();
            for (String name : this.contents.keySet()) {
                toReturn.add(Bukkit.getPlayer((String)name));
            }
            return toReturn;
        }

        @Override
        public V put(Player key, V value) {
            if (key == null) {
                return null;
            }
            return this.contents.put(key.getName(), value);
        }

        @Override
        public void putAll(Map<? extends Player, ? extends V> map) {
            for (Map.Entry<Player, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            if (key instanceof Player) {
                return this.contents.remove(((Player)key).getName());
            }
            if (key instanceof String) {
                return this.contents.remove(key);
            }
            return null;
        }

        @Override
        public int size() {
            return this.contents.size();
        }

        @Override
        public Collection<V> values() {
            return this.contents.values();
        }

        public String toString() {
            return this.contents.toString();
        }

        public class PlayerEntry
        implements Map.Entry<Player, V> {
            private Player key;
            private V value;

            public PlayerEntry(Player key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public Player getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                Object toReturn = this.value;
                this.value = value;
                return toReturn;
            }
        }
    }
}

