/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.objects.hologram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dzikoysk.wildskript.WildSkript;
import net.dzikoysk.wildskript.complex.packet.NMSPacket;
import net.dzikoysk.wildskript.complex.packet.PacketUtils;
import net.minecraft.server.v1_7_R1.Entity;
import net.minecraft.server.v1_7_R1.EntityHorse;
import net.minecraft.server.v1_7_R1.EntityLiving;
import net.minecraft.server.v1_7_R1.EntityPlayer;
import net.minecraft.server.v1_7_R1.EntityWitherSkull;
import net.minecraft.server.v1_7_R1.Packet;
import net.minecraft.server.v1_7_R1.PacketPlayOutAttachEntity;
import net.minecraft.server.v1_7_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_7_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_7_R1.World;
import net.minecraft.server.v1_7_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class Hologram {
    public static List<Hologram> holograms = new ArrayList<Hologram>();
    String id;
    private static final double distance = 0.23;
    private List<String> lines = new ArrayList<String>();
    private List<Integer> ids = new ArrayList<Integer>();
    private boolean showing = false;
    private Location location;

    public Hologram(String id) {
        this.id = id;
        holograms.add(this);
    }

    public static Hologram get(String id) {
        for (Hologram h : holograms) {
            if (!h.getID().equals(id)) continue;
            return h;
        }
        return new Hologram(id);
    }

    public void change(String[] lines) {
        this.lines.clear();
        if (this.showing) {
            this.destroy();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.lines.add(s);
                ++n2;
            }
            if (this.location != null) {
                this.show(this.location);
            }
            return;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n3 = 0;
        while (n3 < n) {
            String s = stringArray[n3];
            this.lines.add(s);
            ++n3;
        }
    }

    public void show(Location loc) {
        if (this.showing) {
            return;
        }
        if (this.lines == null) {
            return;
        }
        Location first = loc.clone().add(0.0, (double)(this.lines.size() / 2) * 0.23, 0.0);
        int i = 0;
        while (i < this.lines.size()) {
            this.ids.addAll(Hologram.showLine(first.clone(), this.lines.get(i)));
            first.subtract(0.0, 0.23, 0.0);
            ++i;
        }
        this.showing = true;
        this.location = loc;
    }

    public void show(Location loc, int sec) {
        this.show(loc);
        new BukkitRunnable(){

            public void run() {
                Hologram.this.destroy();
            }
        }.runTaskLater(WildSkript.ws, (long)(sec * 20));
    }

    public void destroy() {
        if (!this.showing) {
            return;
        }
        int[] ints = new int[this.ids.size()];
        int j = 0;
        while (j < ints.length) {
            if (j != 0) {
                ints[j] = this.ids.get(j);
            }
            ++j;
        }
        NMSPacket packet = new NMSPacket("PacketPlayOutEntityDestroy");
        packet.setDeclaredField("a", ints);
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            PacketUtils.sendPacket(p, packet);
            ++n2;
        }
        this.showing = false;
        this.location = null;
        this.ids.clear();
    }

    private static List<Integer> showLine(Location loc, String text) {
        WorldServer world = ((CraftWorld)loc.getWorld()).getHandle();
        EntityWitherSkull skull = new EntityWitherSkull((World)world);
        skull.setLocation(loc.getX(), loc.getY() + 1.0 + 55.0, loc.getZ(), 0.0f, 0.0f);
        PacketPlayOutSpawnEntity skull_packet = new PacketPlayOutSpawnEntity((Entity)skull, 64);
        EntityHorse horse = new EntityHorse((World)world);
        horse.setLocation(loc.getX(), loc.getY() + 55.0, loc.getZ(), 0.0f, 0.0f);
        horse.setAge(-1700000);
        horse.setCustomName(text);
        horse.setCustomNameVisible(true);
        PacketPlayOutSpawnEntityLiving packedt = new PacketPlayOutSpawnEntityLiving((EntityLiving)horse);
        for (Player player : loc.getWorld().getPlayers()) {
            EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
            nmsPlayer.playerConnection.sendPacket((Packet)packedt);
            nmsPlayer.playerConnection.sendPacket((Packet)skull_packet);
            PacketPlayOutAttachEntity pa = new PacketPlayOutAttachEntity(0, (Entity)horse, (Entity)skull);
            nmsPlayer.playerConnection.sendPacket((Packet)pa);
        }
        return Arrays.asList(skull.getId(), horse.getId());
    }

    public void delete() {
        this.destroy();
        holograms.remove(null);
        this.lines = null;
        this.location = null;
    }

    public String getID() {
        return this.id;
    }
}

