/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.wildskript.doc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import net.dzikoysk.wildskript.WildSkript;
import net.dzikoysk.wildskript.doc.Element;
import net.minecraft.util.org.apache.commons.io.FileUtils;

public class Documentation {
    private static List<Element> events = new ArrayList<Element>();
    private static List<Element> effects = new ArrayList<Element>();
    private static List<Element> conditions = new ArrayList<Element>();
    private static List<Element> expressions = new ArrayList<Element>();
    private static List<Element> types = new ArrayList<Element>();
    private static List<Element> eventvalues = new ArrayList<Element>();
    private static List<Element> complex = new ArrayList<Element>();
    private static List<Element> objects = new ArrayList<Element>();
    private static List<Element> plugins = new ArrayList<Element>();
    private static File doc = new File(WildSkript.ws.getDataFolder() + File.separator + "doc");

    public static void addElement(Element e) {
        switch (e.getType()) {
            case EFFECT: {
                effects.add(e);
                break;
            }
            case COMPLEX: {
                complex.add(e);
                break;
            }
            case CONDITION: {
                conditions.add(e);
                break;
            }
            case EVENT: {
                events.add(e);
                break;
            }
            case EXPRESSION: {
                expressions.add(e);
                break;
            }
            case OBJECT: {
                objects.add(e);
                break;
            }
            case PLUGIN: {
                plugins.add(e);
                break;
            }
            case TYPE: {
                types.add(e);
                break;
            }
            case EVENT_VALUE: {
                eventvalues.add(e);
                break;
            }
            case NO_DOC: {
                break;
            }
        }
    }

    public static void generate() {
        try {
            FileUtils.deleteDirectory((File)doc);
            Documentation.single();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void single() throws IOException {
        List[] lists;
        List[] listArray = lists = new List[]{events, conditions, effects, expressions, types};
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            List l = listArray[n2];
            String name = ((Element)l.get(0)).getType().getName();
            String head = Documentation.singleHead(name);
            String list = Documentation.singleList(l);
            String patterns = Documentation.singlePattern(l);
            String footer = Documentation.singleFooter();
            Documentation.singleBuild(new File(doc + File.separator + name + ".html"), new String[]{head, list, patterns, footer});
            ++n2;
        }
    }

    private static String updateClasses(String s) {
        String[] classes;
        String[] stringArray = classes = new String[]{"string", "player", "number", "location", "entity"};
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            s = s.replace("%" + type + "%", "%<a href=\"http://njol.ch/projects/skript/doc/classes/#" + type + '\"' + "class=" + '\"' + "a" + '\"' + ">" + type + "</a>%");
            ++n2;
        }
        return s;
    }

    private static void singleBuild(File file, String[] t) throws IOException {
        file.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(file);
        StringBuilder sb = new StringBuilder("");
        String[] stringArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.valueOf(s) + "\n");
            ++n2;
        }
        String page = sb.toString();
        String name = file.getName();
        if (name.equals("effects")) {
            page.replace("LEVT", "activated");
        }
        if (name.equals("conditions")) {
            page.replace("LCOND", "activated");
        }
        if (name.equals("effect")) {
            page.replace("LEFF", "activated");
        }
        if (name.equals("expressions")) {
            page.replace("LEXPR", "activated");
        }
        if (name.equals("types")) {
            page.replace("LCLL", "activated");
        }
        fw.write(page);
        fw.close();
    }

    private static String singleHead(String title) throws IOException {
        InputStream is = WildSkript.ws.getResource("doc/header.txt");
        String s = Documentation.isS(is);
        String[] split = s.split("\\|");
        StringBuilder build = new StringBuilder(split[0]);
        build.append(title).append(split[1]).append(title).append(split[2]);
        String head = build.toString();
        return head;
    }

    private static String singleList(List<Element> list) throws IOException {
        InputStream is = WildSkript.ws.getResource("doc/list.txt");
        String template = Documentation.isS(is);
        StringBuilder sb = new StringBuilder("");
        Collections.sort(list);
        for (Element e : list) {
            String name = e.getName();
            sb.append("<a href=\"#" + name + '\"' + " class=" + '\"' + "list-b" + '\"' + ">" + name + "</a>");
        }
        sb.append(template);
        return sb.toString();
    }

    private static String singlePattern(List<Element> pattern) throws IOException {
        InputStream is = WildSkript.ws.getResource("doc/pattern.txt");
        String tmp = Documentation.isS(is);
        ArrayList<String> ptr = new ArrayList<String>();
        Collections.sort(pattern);
        for (Element e : pattern) {
            String[] p = tmp.split("\\|");
            StringBuilder sb = new StringBuilder(p[0]);
            sb.append(e.getName()).append(p[1]).append(e.getName()).append(p[2]).append(e.getName()).append(p[3]).append(Documentation.updateClasses(e.getUsage())).append(p[4]).append(e.getVersion()).append(p[5]).append(e.getDesc()).append(p[6]).append(e.getExample()).append(p[7]);
            ptr.add(sb.toString());
        }
        StringBuilder sb = new StringBuilder("");
        for (String s : ptr) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static String singleFooter() throws IOException {
        InputStream is = WildSkript.ws.getResource("doc/footer.txt");
        String footer = Documentation.isS(is);
        return footer;
    }

    private static String isS(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

