/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.variables;

import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class VariablesTreeMap
extends TreeMap<String, Object> {
    private final Optional<VariablesTreeMap> parent;
    private final Optional<Set<String>> keys;

    public VariablesTreeMap(VariablesTreeMap parent, Set<String> keys) {
        this.parent = Optional.ofNullable(parent);
        this.keys = Optional.ofNullable(keys);
    }

    private boolean keyMatches(String key) {
        return this.keys.map(Set2 -> Set2.contains(key)).orElse(true) != false || this.keyMatchesParent(key);
    }

    private boolean keyMatchesParent(String key) {
        return this.parent.map(map -> map.keyMatches(key)).orElse(false);
    }

    @Override
    public Object get(Object keyObj) {
        if (!(keyObj instanceof String)) {
            return null;
        }
        String key = (String)keyObj;
        if (!this.keyMatches(key)) {
            return null;
        }
        if (this.keyMatchesParent(key)) {
            VariablesTreeMap parent = this.parent.get();
            return parent.get(key);
        }
        return super.get(key);
    }

    @Override
    public Object put(String key, Object elem) {
        if (!this.keyMatches(key)) {
            return null;
        }
        if (this.keyMatchesParent(key)) {
            VariablesTreeMap parent = this.parent.get();
            return parent.put(key, elem);
        }
        return super.put(key, elem);
    }
}

