/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.variables;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;

public class VariablesHashMap
extends HashMap<String, Object> {
    private final Optional<VariablesHashMap> parent;
    private final Optional<Set<String>> keys;

    public VariablesHashMap(VariablesHashMap parent, Set<String> keys) {
        this.parent = Optional.ofNullable(parent);
        this.keys = Optional.ofNullable(keys);
    }

    private boolean keyMatches(String key) {
        return this.keys.map(Set2 -> Set2.contains(key.split("::")[0])).orElse(true) != false || this.keyMatchesParent(key);
    }

    private boolean keyMatchesParent(String key) {
        return this.parent.map(map -> map.keyMatches(key)).orElse(false);
    }

    @Override
    public Object get(Object keyObj) {
        if (!(keyObj instanceof String)) {
            return null;
        }
        String key = (String)keyObj;
        if (!this.keyMatches(key)) {
            return null;
        }
        if (this.keyMatchesParent(key)) {
            VariablesHashMap parent = this.parent.get();
            return parent.get(key);
        }
        return super.get(key);
    }

    @Override
    public Object put(String key, Object elem) {
        if (!this.keyMatches(key)) {
            return null;
        }
        if (this.keyMatchesParent(key)) {
            VariablesHashMap parent = this.parent.get();
            return parent.put(key, elem);
        }
        return super.put(key, elem);
    }
}

