/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.template;

import ch.njol.skript.Skript;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import us.tlatoani.webskt.constructor.ExprConstructedWebSocket;
import us.tlatoani.webskt.constructor.WebSKTConstructor;
import us.tlatoani.webskt.core.grouped_list.GroupedList;
import us.tlatoani.webskt.events.WebSocketCloseEvent;
import us.tlatoani.webskt.events.WebSocketErrorEvent;
import us.tlatoani.webskt.events.WebSocketHandshakeEvent;
import us.tlatoani.webskt.events.WebSocketMessageEvent;
import us.tlatoani.webskt.events.WebSocketOpenEvent;
import us.tlatoani.webskt.template.Subsection;

public class WebSocketClientFunctionality
implements Iterable<Subsection> {
    public final String id;
    private boolean loaded = false;
    public final Subsection<WebSocketOpenEvent.Client> onOpen = new Subsection<WebSocketOpenEvent.Client>("open", "WebSocketClientOpen", WebSocketOpenEvent.Client.class);
    public final Subsection<WebSocketHandshakeEvent.Client> onHandshake = new Subsection<WebSocketHandshakeEvent.Client>("handshake", "WebSocketClientHandshake", WebSocketHandshakeEvent.Client.class);
    public final Subsection<WebSocketCloseEvent> onClose = new Subsection<WebSocketCloseEvent>("close", "WebSocketClientClose", WebSocketCloseEvent.class);
    public final Subsection<WebSocketMessageEvent> onMessage = new Subsection<WebSocketMessageEvent>("message", "WebSocketClientMessage", WebSocketMessageEvent.class);
    public final Subsection<WebSocketErrorEvent> onError = new Subsection<WebSocketErrorEvent>("error", "WebSocketClientError", WebSocketErrorEvent.class);
    private Collection<WebSKTConstructor> constructors = new ArrayList<WebSKTConstructor>();
    private GroupedList.Key constructorKey = null;
    private Set<String> webSocketVariableKeys = new HashSet<String>();

    public void addConstructor(WebSKTConstructor constructor) {
        this.constructors.add(constructor);
    }

    public Set<String> getWebSocketVariableKeys() {
        return Collections.unmodifiableSet(this.webSocketVariableKeys);
    }

    public boolean addWebSocketVariableKey(String key) {
        if (key.contains("::") || key.contains("*")) {
            Skript.error((String)"You can't have '::' or '*' in your websocket variable names.");
            return false;
        }
        if (!this.webSocketVariableKeys.add(key)) {
            Skript.error((String)("You already specified '" + key + "' as a websocket variable name!"));
            return false;
        }
        this.webSocketVariableKeys.add(key);
        return true;
    }

    public WebSocketClientFunctionality(String id) {
        this.id = id;
    }

    @Override
    public Iterator<Subsection> iterator() {
        return Iterators.forArray((Object[])new Subsection[]{this.onOpen, this.onHandshake, this.onClose, this.onMessage, this.onError});
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void registerConstructors() {
        if (!this.constructors.isEmpty()) {
            this.constructorKey = ExprConstructedWebSocket.registerConstructors(this.constructors);
        }
    }

    public void load() {
        this.loaded = true;
        for (Subsection subsection : this) {
            subsection.load();
        }
        for (WebSKTConstructor constructor : this.constructors) {
            constructor.load();
        }
    }

    public void unload() {
        this.loaded = false;
        this.webSocketVariableKeys.clear();
        for (Subsection subsection : this) {
            subsection.unload();
        }
        this.constructors.clear();
        if (this.constructorKey != null) {
            ExprConstructedWebSocket.unregisterConstructors(this.constructorKey);
            this.constructorKey = null;
        }
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "WebSocketClientFunctionality(", ")");
        for (Subsection subsection : this) {
            stringJoiner.add(subsection.toString());
        }
        return stringJoiner.toString();
    }
}

