/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.template;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.bukkit.event.Event;
import us.tlatoani.webskt.WebSKT;
import us.tlatoani.webskt.classes.WebSKTClient;
import us.tlatoani.webskt.classes.WebSKTServerConnection;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.core.base.Scheduling;
import us.tlatoani.webskt.core.event_scope.ScopeUtil;
import us.tlatoani.webskt.events.WebSocketEvent;
import us.tlatoani.webskt.events.WebSocketServerEvent;
import us.tlatoani.webskt.java_websocket.WebSocket;
import us.tlatoani.webskt.variables.VariablesMapManipulator;

public class Subsection<E extends Event> {
    public final String syntax;
    public final String eventName;
    public final Class<E> eventClass;
    public final boolean shouldLock;
    private Optional<TriggerItem> triggerItem = Optional.empty();
    private Optional<SectionNode> sectionNode = Optional.empty();

    public Subsection(String syntax, String eventName, Class<E> eventClass) {
        this(syntax, eventName, eventClass, false);
    }

    public Subsection(String syntax, String eventName, Class<E> eventClass, boolean shouldLock) {
        this.syntax = syntax;
        this.eventName = eventName;
        this.eventClass = eventClass;
        this.shouldLock = shouldLock;
    }

    public Kleenean trySectionNode(SectionNode sectionNode) {
        if (sectionNode.getKey().equals("on " + this.syntax)) {
            if (this.sectionNode.isPresent()) {
                Skript.error((String)("You cannot have two 'on " + this.syntax + "' sections here!"));
                return Kleenean.FALSE;
            }
            this.sectionNode = Optional.of(sectionNode);
            return Kleenean.TRUE;
        }
        return Kleenean.UNKNOWN;
    }

    public void load() {
        this.triggerItem = this.sectionNode.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)this.eventName, (Class[])new Class[]{this.eventClass});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.sectionNode = Optional.empty();
    }

    public void unload() {
        this.triggerItem = Optional.empty();
        this.sectionNode = Optional.empty();
    }

    public boolean isPresent() {
        return this.triggerItem.isPresent();
    }

    public void run(E event) {
        if (!WebSKT.isEnabledAtomic()) {
            return;
        }
        Logging.debug((Object)this, this + " called");
        this.triggerItem.ifPresent(t -> {
            WebSocket webSocket;
            VariablesMapManipulator parentVMM = event instanceof WebSocketEvent ? ((webSocket = ((WebSocketEvent)event).webSocket) instanceof WebSKTClient ? ((WebSKTClient)webSocket).vmm : (webSocket instanceof WebSKTServerConnection ? ((WebSKTServerConnection)webSocket).vmm : null)) : (event instanceof WebSocketServerEvent ? ((WebSocketServerEvent)event).getWebSocketServer().vmm : null);
            if (this.shouldLock) {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                Scheduling.sync(() -> {
                    if (parentVMM != null) {
                        VariablesMapManipulator.setParentVariables(event, parentVMM);
                    }
                    TriggerItem.walk((TriggerItem)t, (Event)event);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    Logging.reportException(this, e);
                }
            } else {
                Scheduling.sync(() -> {
                    if (parentVMM != null) {
                        VariablesMapManipulator.setParentVariables(event, parentVMM);
                    }
                    TriggerItem.walk((TriggerItem)t, (Event)event);
                });
            }
        });
    }

    public String toString() {
        return "Subsection(syntax: on " + this.syntax + ", triggerItem: " + this.triggerItem + ")";
    }
}

