/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.template;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import us.tlatoani.webskt.WebSocketManager;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.core.event_scope.MundoEventScope;
import us.tlatoani.webskt.core.event_scope.ScopeUtil;
import us.tlatoani.webskt.template.Subsection;
import us.tlatoani.webskt.template.WebSocketServerFunctionality;

public class ScopeWebSocketServer
extends MundoEventScope {
    private WebSocketServerFunctionality serverFunctionality;
    private boolean sync;

    @Override
    protected void afterInit() {
        this.serverFunctionality.load();
        Logging.debug((Object)this, "registered: " + this.serverFunctionality);
    }

    public void unregister(Trigger trigger) {
        this.serverFunctionality.unload();
        Logging.debug((Object)this, "unregistered");
    }

    public void unregisterAll() {
        WebSocketManager.clearServerFunctionalities();
    }

    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        boolean result;
        this.serverFunctionality = WebSocketManager.getServerFunctionality((String)literals[0].getSingle());
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        Logging.debug((Object)this, "init()ing");
        if (this.serverFunctionality.isLoaded()) {
            Skript.warning((String)("You seem to have two 'websocket server' instances with the id \"" + this.serverFunctionality.id + "\" in your code. If you do, note that only one of them will be used. If you don't, you can ignore this warning."));
            this.serverFunctionality.unload();
        }
        if (!(result = this.loadFunctionality(topNode))) {
            this.serverFunctionality.unload();
        }
        ScopeUtil.removeSubNodes(topNode);
        return result;
    }

    private boolean loadFunctionality(SectionNode topNode) {
        block0: for (Node node : topNode) {
            SkriptLogger.setNode((Node)node);
            Logging.debug((Object)this, "Current node: " + node.getKey());
            if (!(node instanceof SectionNode)) {
                Skript.error((String)"'websocket server' should only have sections directly under it!");
                return false;
            }
            SectionNode subNode = (SectionNode)node;
            if (subNode.getKey().equals("server variables") || subNode.getKey().equals("server vars")) {
                for (Node varKeyNode : subNode) {
                    SkriptLogger.setNode((Node)varKeyNode);
                    if (varKeyNode instanceof SectionNode) {
                        Skript.error((String)"The 'server variables' section should only be used to list names of server variables, you can't have a subsection there.");
                        return false;
                    }
                    if (this.serverFunctionality.addServerVariableKey(varKeyNode.getKey())) continue;
                    return false;
                }
                continue;
            }
            if (subNode.getKey().equals("websocket variables") || subNode.getKey().equals("websocket vars")) {
                for (Node varKeyNode : subNode) {
                    SkriptLogger.setNode((Node)varKeyNode);
                    if (varKeyNode instanceof SectionNode) {
                        Skript.error((String)"The 'websocket variables' section should only be used to list names of websocket variables, you can't have a subsection there.");
                        return false;
                    }
                    if (this.serverFunctionality.addWebSocketVariableKey(varKeyNode.getKey())) continue;
                    return false;
                }
                continue;
            }
            for (Subsection subsection : this.serverFunctionality) {
                Kleenean result = subsection.trySectionNode(subNode);
                if (result == Kleenean.TRUE) continue block0;
                if (result != Kleenean.FALSE) continue;
                return false;
            }
            Skript.error((String)"The only sections allowed under 'websocket server' are 'on start', 'on stop', 'on open', 'on handshake, 'on close', 'on message', and 'on error'!");
            return false;
        }
        return true;
    }

    public String toString(Event event, boolean b) {
        return "websocket  server \"" + this.serverFunctionality.id + "\"";
    }
}

