/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.syntaxes;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.webskt.WebSocketManager;
import us.tlatoani.webskt.classes.WebSKTClient;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.java_websocket.WebSocket;
import us.tlatoani.webskt.java_websocket.handshake.Handshakedata;
import us.tlatoani.webskt.template.WebSocketClientFunctionality;

public class ExprNewWebSocket
extends SimpleExpression<WebSocket> {
    private Expression<String> idExpr;
    private Expression<String> uriExpr;
    private Optional<Expression<Handshakedata>> handshakeExpr;

    protected WebSocket[] get(Event event) {
        URI uri;
        String id = (String)this.idExpr.getSingle(event);
        if (id == null) {
            return new WebSocket[0];
        }
        WebSocketClientFunctionality functionality = WebSocketManager.getClientFunctionality(id);
        String uriStr = (String)this.uriExpr.getSingle(event);
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            Skript.warning((String)("Failed to parse '" + uriStr + "' as a URI: " + e.getMessage()));
            Logging.debug((Object)this, e);
            return new WebSocket[0];
        }
        catch (NullPointerException e) {
            Logging.debug((Object)this, e);
            return new WebSocket[0];
        }
        Optional<Handshakedata> handshakeOptional = this.handshakeExpr.map(expr -> (Handshakedata)expr.getSingle(event));
        WebSKTClient webSocket = handshakeOptional.map(handshake -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            handshake.iterateHttpFields().forEachRemaining(name -> headers.put((String)name, handshake.getFieldValue((String)name)));
            return new WebSKTClient(functionality, uri, headers);
        }).orElseGet(() -> new WebSKTClient(functionality, uri));
        webSocket.connect();
        return new WebSocket[]{webSocket};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends WebSocket> getReturnType() {
        return WebSKTClient.class;
    }

    public String toString(Event event, boolean b) {
        return "websocket " + this.idExpr + " connected to uri " + this.uriExpr + this.handshakeExpr.map(expr -> " with request " + expr).orElse("");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.idExpr = expressions[0];
        this.uriExpr = expressions[1];
        this.handshakeExpr = Optional.ofNullable(expressions[2]);
        return true;
    }
}

