/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.core.base;

import ch.njol.skript.Skript;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.plugin.java.JavaPlugin;
import us.tlatoani.webskt.core.base.CondBoolean;
import us.tlatoani.webskt.core.base.Config;
import us.tlatoani.webskt.core.base.Scheduling;

public abstract class MundoAddon
extends JavaPlugin {
    public static final Config.Option<List<String>> DEBUG_PACKAGES = Config.option("debug", MemorySection::getStringList);
    private static MundoAddon instance = null;
    public final String commandName;
    public final ChatColor primaryChatColor;
    public final ChatColor altChatColor;
    public final ChatColor triChatColor;
    private final List<Pair<String, String>> links = new ArrayList<Pair<String, String>>();
    private String gitHubLink = "(no github link available yet, but you can join the skript discord chat at https://discord.gg/vb9dGbu for help)";
    private static final Map<String, BiConsumer<CommandSender, String[]>> subCommands = new HashMap<String, BiConsumer<CommandSender, String[]>>();
    private static final Map<String, String> subCommandDescriptions = new TreeMap<String, String>();

    public static MundoAddon get() {
        if (instance == null) {
            throw new IllegalStateException("The plugin has not been initialized yet!");
        }
        return instance;
    }

    public MundoAddon(String commandName, ChatColor primaryChatColor, ChatColor altChatColor, ChatColor triChatColor) {
        instance = this;
        this.commandName = commandName;
        this.primaryChatColor = primaryChatColor;
        this.altChatColor = altChatColor;
        this.triChatColor = triChatColor;
    }

    protected void link(String name, String url) {
        this.links.add((Pair<String, String>)new Pair((Object)name, (Object)url));
        if (name.equalsIgnoreCase("github")) {
            this.gitHubLink = url;
        }
    }

    public static String getGitHubLink() {
        return MundoAddon.get().gitHubLink;
    }

    public static ChatColor getPrimaryChatColor() {
        return MundoAddon.get().primaryChatColor;
    }

    public static ChatColor getAltChatColor() {
        return MundoAddon.get().altChatColor;
    }

    public static ChatColor getTriChatColor() {
        return MundoAddon.get().triChatColor;
    }

    public void onEnable() {
        Config.reload();
        Skript.registerAddon((JavaPlugin)this);
        Skript.registerCondition(CondBoolean.class, (String[])new String[]{"[(1\u00a6not)] %boolean%"});
        MundoAddon.registerSubCommand(MundoAddon::onHelpCommand, "help");
        MundoAddon.registerSubCommand(MundoAddon::onDescCommand, "desc", "description");
        MundoAddon.registerSubCommand(MundoAddon::onVersionCommand, "ver", "version");
        MundoAddon.registerSubCommand(Config::accessConfig, "config");
        MundoAddon.registerSubCommandDescription("help", "Prints this list of commands");
        MundoAddon.registerSubCommandDescription("desc[ription]", "Prints a description of " + MundoAddon.name());
        MundoAddon.registerSubCommandDescription("ver[sion]", "Prints the version of " + MundoAddon.name() + " running on this server");
        MundoAddon.registerSubCommandDescription("config", "Prints the current config options");
        MundoAddon.registerSubCommandDescription("config reload", "Reloads " + MundoAddon.name() + "'s config");
        Scheduling.sync(this::afterPluginsEnabled);
    }

    public void afterPluginsEnabled() {
    }

    public void afterConfigReloaded() {
    }

    public static void registerSubCommand(Consumer<CommandSender> onCommand, String ... names) {
        MundoAddon.registerSubCommand((CommandSender sender, String[] __) -> onCommand.accept((CommandSender)sender), names);
    }

    public static void registerSubCommand(BiConsumer<CommandSender, String[]> onCommand, String ... names) {
        for (String name : names) {
            subCommands.put(name, onCommand);
        }
    }

    public static void registerSubCommandDescription(String nameSyntax, String description) {
        subCommandDescriptions.put(nameSyntax, description);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equals(this.commandName)) {
            BiConsumer<CommandSender, String[]> onCommand = subCommands.get(args.length == 0 ? "help" : args[0]);
            if (onCommand == null) {
                sender.sendMessage(MundoAddon.getPrimaryChatColor() + MundoAddon.name() + " didn't understand this command argument: " + MundoAddon.getAltChatColor() + args[0]);
                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Do " + MundoAddon.getAltChatColor() + "/" + this.commandName + " " + MundoAddon.getPrimaryChatColor() + "to show a list of " + MundoAddon.name() + " commands");
            } else {
                onCommand.accept(sender, args);
            }
            return true;
        }
        return false;
    }

    public static String formatCommandDescription(String args, String desc) {
        return MundoAddon.getAltChatColor() + "/" + MundoAddon.get().commandName + " " + args + " " + MundoAddon.getPrimaryChatColor() + desc;
    }

    public static String formatInfo(String name, String info) {
        return MundoAddon.getPrimaryChatColor() + name + " " + MundoAddon.getAltChatColor() + info;
    }

    public static String name() {
        return MundoAddon.get().getDescription().getName();
    }

    public static String version() {
        return MundoAddon.get().getDescription().getVersion();
    }

    private static void onHelpCommand(CommandSender sender) {
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + MundoAddon.name() + " Command Help");
        subCommandDescriptions.forEach((nameSyntax, desc) -> sender.sendMessage(MundoAddon.formatCommandDescription(nameSyntax, desc)));
    }

    private static void onDescCommand(CommandSender sender) {
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + MundoAddon.get().getDescription().getDescription());
        sender.sendMessage(MundoAddon.formatInfo("Your " + MundoAddon.name() + " Version", MundoAddon.version()));
        sender.sendMessage(MundoAddon.formatInfo(MundoAddon.name() + " Website", MundoAddon.get().getDescription().getWebsite()));
        for (Pair<String, String> link : MundoAddon.get().links) {
            sender.sendMessage(MundoAddon.formatInfo((String)link.getFirst(), (String)link.getSecond()));
        }
        sender.sendMessage(MundoAddon.formatInfo("Skript Chat Discord Invite", "https://discord.gg/vb9dGbu"));
    }

    private static void onVersionCommand(CommandSender sender) {
        sender.sendMessage(MundoAddon.formatInfo("Your " + MundoAddon.name() + " Version", MundoAddon.version()));
    }
}

