/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.classes;

import java.util.List;
import us.tlatoani.webskt.classes.WebSKTServer;
import us.tlatoani.webskt.java_websocket.WebSocketImpl;
import us.tlatoani.webskt.java_websocket.WebSocketListener;
import us.tlatoani.webskt.java_websocket.drafts.Draft;
import us.tlatoani.webskt.variables.VariablesMapManipulator;

public class WebSKTServerConnection
extends WebSocketImpl {
    public final WebSKTServer server;
    public final VariablesMapManipulator vmm;

    public WebSKTServerConnection(WebSKTServer server, List<Draft> drafts) {
        super((WebSocketListener)server, drafts);
        this.server = server;
        this.vmm = new VariablesMapManipulator(server.functionality.getWebSocketVariableKeys(), server.vmm);
    }

    public WebSKTServerConnection(WebSKTServer server, Draft draft) {
        super((WebSocketListener)server, draft);
        this.server = server;
        this.vmm = new VariablesMapManipulator(server.functionality.getWebSocketVariableKeys(), server.vmm);
    }

    @Override
    public String toString() {
        if (this.getRemoteSocketAddress() == null) {
            return "connection of websocket server \"" + this.server.functionality.id + "\" at port " + this.server.getAddress().getPort() + " with hashcode " + Integer.toHexString(this.hashCode());
        }
        return "connection of websocket server \"" + this.server.functionality.id + "\" at port " + this.server.getAddress().getPort() + " connected to host \"" + this.getRemoteSocketAddress().getHostName() + "\" port " + this.getRemoteSocketAddress().getPort() + " with hashcode " + Integer.toHexString(this.hashCode());
    }
}

