/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.template;

import ch.njol.skript.Skript;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import us.tlatoani.webskt.events.WebSocketCloseEvent;
import us.tlatoani.webskt.events.WebSocketErrorEvent;
import us.tlatoani.webskt.events.WebSocketHandshakeEvent;
import us.tlatoani.webskt.events.WebSocketMessageEvent;
import us.tlatoani.webskt.events.WebSocketOpenEvent;
import us.tlatoani.webskt.events.WebSocketServerStartEvent;
import us.tlatoani.webskt.events.WebSocketServerStopEvent;
import us.tlatoani.webskt.template.Subsection;

public class WebSocketServerFunctionality
implements Iterable<Subsection> {
    public final String id;
    private boolean loaded = false;
    public final Subsection<WebSocketServerStartEvent> onStart = new Subsection<WebSocketServerStartEvent>("start", "WebSocketServerStart", WebSocketServerStartEvent.class);
    public final Subsection<WebSocketServerStopEvent> onStop = new Subsection<WebSocketServerStopEvent>("stop", "WebSocketServerStop", WebSocketServerStopEvent.class);
    public final Subsection<WebSocketOpenEvent.Server> onOpen = new Subsection<WebSocketOpenEvent.Server>("open", "WebSocketServerOpen", WebSocketOpenEvent.Server.class);
    public final Subsection<WebSocketHandshakeEvent.Server> onHandshake = new Subsection<WebSocketHandshakeEvent.Server>("handshake", "WebSocketServerHandshake", WebSocketHandshakeEvent.Server.class, true);
    public final Subsection<WebSocketCloseEvent.Server> onClose = new Subsection<WebSocketCloseEvent.Server>("close", "WebSocketServerClose", WebSocketCloseEvent.Server.class);
    public final Subsection<WebSocketMessageEvent.Server> onMessage = new Subsection<WebSocketMessageEvent.Server>("message", "WebSocketServerMessage", WebSocketMessageEvent.Server.class);
    public final Subsection<WebSocketErrorEvent.Server> onError = new Subsection<WebSocketErrorEvent.Server>("error", "WebSocketServerError", WebSocketErrorEvent.Server.class);
    private Set<String> serverVariableKeys = new HashSet<String>();
    private Set<String> webSocketVariableKeys = new HashSet<String>();

    public Set<String> getServerVariableKeys() {
        return Collections.unmodifiableSet(this.serverVariableKeys);
    }

    public Set<String> getWebSocketVariableKeys() {
        return Collections.unmodifiableSet(this.webSocketVariableKeys);
    }

    public boolean addServerVariableKey(String key) {
        if (key.contains("::") || key.contains("*")) {
            Skript.error((String)"You can't have '::' or '*' in your server variable names.");
            return false;
        }
        if (this.serverVariableKeys.contains(key)) {
            Skript.error((String)("You already specified '" + key + "' as a server variable name!"));
            return false;
        }
        if (this.webSocketVariableKeys.contains(key)) {
            Skript.error((String)("You already specified '" + key + "' as a websocket variable name!"));
            return false;
        }
        this.serverVariableKeys.add(key);
        return true;
    }

    public boolean addWebSocketVariableKey(String key) {
        if (key.contains("::") || key.contains("*")) {
            Skript.error((String)"You can't have '::' or '*' in your websocket variable names.");
            return false;
        }
        if (this.serverVariableKeys.contains(key)) {
            Skript.error((String)("You already specified '" + key + "' as a server variable name!"));
            return false;
        }
        if (this.webSocketVariableKeys.contains(key)) {
            Skript.error((String)("You already specified '" + key + "' as a websocket variable name!"));
            return false;
        }
        this.webSocketVariableKeys.add(key);
        return true;
    }

    public WebSocketServerFunctionality(String id) {
        this.id = id;
    }

    @Override
    public Iterator<Subsection> iterator() {
        return Iterators.forArray((Object[])new Subsection[]{this.onStart, this.onStop, this.onOpen, this.onHandshake, this.onClose, this.onMessage, this.onError});
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
        for (Subsection subsection : this) {
            subsection.load();
        }
    }

    public void unload() {
        this.loaded = false;
        this.serverVariableKeys.clear();
        this.webSocketVariableKeys.clear();
        for (Subsection subsection : this) {
            subsection.unload();
        }
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "WebSocketServerFunctionality(", ")");
        for (Subsection subsection : this) {
            stringJoiner.add(subsection.toString());
        }
        return stringJoiner.toString();
    }
}

