/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.template;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.webskt.WebSocketManager;
import us.tlatoani.webskt.constructor.WebSocketConstructor;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.core.event_scope.MundoEventScope;
import us.tlatoani.webskt.core.event_scope.ScopeUtil;
import us.tlatoani.webskt.template.Subsection;
import us.tlatoani.webskt.template.WebSocketClientFunctionality;

public class ScopeWebSocketClient
extends MundoEventScope {
    private WebSocketClientFunctionality clientFunctionality;
    private boolean sync;

    @Override
    public void afterInit() {
        this.clientFunctionality.load();
        Logging.debug((Object)this, "registered: " + this.clientFunctionality);
    }

    public void unregister(Trigger trigger) {
        this.clientFunctionality.unload();
        Logging.debug((Object)this, "unregistered");
    }

    public void unregisterAll() {
        WebSocketManager.clearClientFunctionalities();
    }

    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        boolean result;
        this.clientFunctionality = WebSocketManager.getClientFunctionality((String)literals[0].getSingle());
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        Logging.debug((Object)this, "init()ing");
        if (this.clientFunctionality.isLoaded()) {
            Skript.warning((String)("You seem to have two 'websocket client' instances with the id \"" + this.clientFunctionality.id + "\" in your code. If you do, note that only one of them will be used. If you don't, you can ignore this warning."));
            this.clientFunctionality.unload();
        }
        if (result = this.loadFunctionality(topNode)) {
            this.clientFunctionality.registerConstructors();
        } else {
            this.clientFunctionality.unload();
        }
        ScopeUtil.removeSubNodes(topNode);
        return result;
    }

    private boolean loadFunctionality(SectionNode topNode) {
        block0: for (Node node : topNode) {
            SkriptLogger.setNode((Node)node);
            Logging.debug((Object)this, "Current node: " + node.getKey());
            if (!(node instanceof SectionNode)) {
                Skript.error((String)"'websocket client' should only have sections directly under it!");
                return false;
            }
            SectionNode subNode = (SectionNode)node;
            if (subNode.getKey().startsWith("constructor ")) {
                String quotedSyntax = subNode.getKey().substring(12);
                if (!quotedSyntax.startsWith("\"") || !quotedSyntax.endsWith("\"")) {
                    Skript.error((String)"The constructor syntax is not quoted properly!");
                    return false;
                }
                String unquotedSyntax = quotedSyntax.substring(1, quotedSyntax.length() - 1);
                Optional<WebSocketConstructor> constructorOptional = WebSocketConstructor.from(unquotedSyntax, this.clientFunctionality, subNode);
                if (!constructorOptional.isPresent()) {
                    return false;
                }
                this.clientFunctionality.addConstructor(constructorOptional.get());
                continue;
            }
            if (subNode.getKey().equals("websocket variables") || subNode.getKey().equals("websocket vars")) {
                for (Node varKeyNode : subNode) {
                    SkriptLogger.setNode((Node)varKeyNode);
                    if (varKeyNode instanceof SectionNode) {
                        Skript.error((String)"The 'websocket variables' section should only be used to list names of websocket variables, you can't have a subsection there.");
                        return false;
                    }
                    if (this.clientFunctionality.addWebSocketVariableKey(varKeyNode.getKey())) continue;
                    return false;
                }
                continue;
            }
            for (Subsection subsection : this.clientFunctionality) {
                Kleenean result = subsection.trySectionNode(subNode);
                if (result == Kleenean.TRUE) continue block0;
                if (result != Kleenean.FALSE) continue;
                return false;
            }
            Skript.error((String)"The only sections allowed under 'websocket client' are 'on open', 'on handshake', 'on close', 'on message', and 'on error'!");
            return false;
        }
        return true;
    }

    public String toString(Event event, boolean b) {
        return "websocket  client \"" + this.clientFunctionality.id + "\"";
    }
}

