/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.mundosyntax;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import us.tlatoani.webskt.mundosyntax.Literal;
import us.tlatoani.webskt.mundosyntax.SyntaxPiece;
import us.tlatoani.webskt.mundosyntax.VariableCollective;
import us.tlatoani.webskt.mundosyntax.VariableUsage;

public class Varying
extends SyntaxPiece {
    public final ImmutableList<SyntaxPiece> options;
    public final Optional<String> variable;
    public final boolean isOptional;

    public Varying(ImmutableList<SyntaxPiece> options, Optional<String> variable) {
        this.options = options;
        this.variable = variable;
        this.isOptional = this.isOptional();
    }

    public boolean isOptional() {
        return ((SyntaxPiece)this.options.get(0)).equals(Literal.EMPTY);
    }

    @Override
    public boolean containsVariables() {
        if (this.variable.isPresent()) {
            return true;
        }
        for (SyntaxPiece syntaxPiece : this.options) {
            if (!syntaxPiece.containsVariables()) continue;
            return true;
        }
        return false;
    }

    @Override
    public VariableUsage getVariableUsage(String variable) {
        VariableUsage combinedUsage = this.options.stream().map(syntaxPiece -> syntaxPiece.getVariableUsage(variable)).reduce(VariableUsage::xor).orElse(VariableUsage.NONE);
        if (this.variable.filter(variable::equals).isPresent()) {
            combinedUsage = VariableUsage.and(combinedUsage, VariableUsage.SPECIFIC);
        }
        return combinedUsage;
    }

    public static int digitsInBase(int num, int base) {
        int result = 0;
        while (num > 0) {
            num /= base;
            ++result;
        }
        return result;
    }

    @Override
    public int markLength() {
        int result = 0;
        for (SyntaxPiece syntaxPiece : this.options) {
            result = Math.max(result, syntaxPiece.markLength());
        }
        if (this.containsVariables()) {
            result += Varying.digitsInBase(this.options.size() - 1, 2);
        }
        return result;
    }

    @Override
    public int expressionAmount() {
        int result = 0;
        for (SyntaxPiece syntaxPiece : this.options) {
            result += syntaxPiece.expressionAmount();
        }
        return result;
    }

    @Override
    public void addVariables(VariableCollective constraints) {
        this.variable.ifPresent(constraints::addVaryingOption);
        for (SyntaxPiece option : this.options) {
            option.addVariables(constraints);
        }
    }

    @Override
    public String readableSyntax() {
        StringJoiner joiner = new StringJoiner("|", this.isOptional ? "[" : "(", this.isOptional ? "]" : ")");
        for (SyntaxPiece syntaxPiece : this.options) {
            if (syntaxPiece.equals(Literal.EMPTY)) continue;
            joiner.add(syntaxPiece.readableSyntax());
        }
        return joiner.toString();
    }

    @Override
    public String actualSyntax(int prevMarkLength) {
        if (this.isOptional && this.options.size() == 2) {
            return "[" + ((SyntaxPiece)this.options.get(1)).actualSyntax(prevMarkLength) + "]";
        }
        StringJoiner joiner = new StringJoiner("|", this.isOptional ? "[(" : "(", this.isOptional ? ")]" : ")");
        int varMarkLength = Varying.digitsInBase(this.options.size() - 1, 2);
        if (this.containsVariables()) {
            int i;
            int n = i = this.isOptional() ? 1 : 0;
            while (i < this.options.size()) {
                joiner.add((i << prevMarkLength) + "\u00a6" + ((SyntaxPiece)this.options.get(i)).actualSyntax(prevMarkLength + varMarkLength));
                ++i;
            }
        } else {
            for (SyntaxPiece syntaxPiece : this.options) {
                if (syntaxPiece.equals(Literal.EMPTY)) continue;
                joiner.add(syntaxPiece.actualSyntax(prevMarkLength));
            }
        }
        return joiner.toString();
    }

    @Override
    public String originalSyntax() {
        StringJoiner joiner = new StringJoiner("|", (this.isOptional ? "[" : "(") + this.variable.map(name -> name + "=").orElse(""), this.isOptional ? "]" : ")");
        for (SyntaxPiece syntaxPiece : this.options) {
            if (syntaxPiece.equals(Literal.EMPTY)) continue;
            joiner.add(syntaxPiece.originalSyntax());
        }
        return joiner.toString();
    }

    @Override
    public void setInformation(SyntaxPiece.MarkSpecificInformation information, int mark, int prevExprAmount) {
        int markLength = this.markLength();
        int optionIndex = mark % (2 ^ markLength);
        int nextMark = mark >> markLength;
        this.variable.ifPresent(var -> information.markVarValues.put((String)var, optionIndex));
        for (int i = 0; i < optionIndex; ++i) {
            prevExprAmount += ((SyntaxPiece)this.options.get(i)).expressionAmount();
        }
        ((SyntaxPiece)this.options.get(optionIndex)).setInformation(information, nextMark, prevExprAmount);
    }

    @Override
    public String toString(int mark) {
        int markLength = this.markLength();
        if (!this.containsVariables()) {
            return ((SyntaxPiece)this.options.get(0)).toString(0);
        }
        int optionIndex = mark % (2 ^ markLength);
        int nextMark = mark >> markLength;
        return ((SyntaxPiece)this.options.get(optionIndex)).toString(nextMark);
    }

    @Override
    public String toString() {
        return "Varying(" + this.options.stream().map(SyntaxPiece::toString).collect(Collectors.joining(", ")) + ")";
    }
}

