/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.mundosyntax;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import us.tlatoani.webskt.mundosyntax.ExpressionConstraints;

public class VariableCollective
implements Iterable<String> {
    private Map<String, ExpressionConstraints> constraintsMap = new HashMap<String, ExpressionConstraints>();
    private Set<String> varyingOptions = new HashSet<String>();
    private Set<String> allVariables = new HashSet<String>();

    public void addExpression(String variable, ExpressionConstraints constraints) {
        ExpressionConstraints prevConstraints = this.getExpression(variable);
        if (prevConstraints != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(prevConstraints.types);
            builder.addAll(constraints.types);
            ExpressionConstraints.LiteralState isLiteral = constraints.isLiteral == prevConstraints.isLiteral ? constraints.isLiteral : ExpressionConstraints.LiteralState.UNKNOWN;
            int time = constraints.time == prevConstraints.time ? constraints.time : 0;
            boolean nullable = constraints.nullable || prevConstraints.nullable;
            ExpressionConstraints newConstraints = new ExpressionConstraints((ImmutableSet<ExpressionConstraints.Type>)builder.build(), isLiteral, time, nullable);
            this.constraintsMap.put(variable, newConstraints);
        } else {
            this.constraintsMap.put(variable, constraints);
            this.allVariables.add(variable);
        }
    }

    public void addVaryingOption(String variable) {
        if (this.varyingOptions.add(variable)) {
            this.allVariables.add(variable);
        }
    }

    public ExpressionConstraints getExpression(String variable) {
        return this.constraintsMap.get(variable);
    }

    public boolean isVaryingOption(String variable) {
        return this.varyingOptions.contains(variable);
    }

    public int size() {
        return this.allVariables.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.allVariables.iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        this.allVariables.forEach(action);
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.allVariables.spliterator();
    }
}

