/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.mundosyntax;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import us.tlatoani.webskt.mundosyntax.Concatenation;
import us.tlatoani.webskt.mundosyntax.Expression;
import us.tlatoani.webskt.mundosyntax.Literal;
import us.tlatoani.webskt.mundosyntax.SyntaxPiece;
import us.tlatoani.webskt.mundosyntax.Varying;

public class SyntaxParser {
    public static SyntaxPiece concatenate(List<SyntaxPiece> pieces) {
        if (pieces.size() == 1) {
            return pieces.get(0);
        }
        return new Concatenation((ImmutableList<SyntaxPiece>)ImmutableList.copyOf(pieces));
    }

    public static SyntaxPiece parse(final String string) {
        return new ParsingConsumer(){
            List<SyntaxPiece> syntaxPieces = new LinkedList<SyntaxPiece>();
            StringBuilder literalBuilder = new StringBuilder();
            ParsingIterator parsingIterator = new ParsingIterator(string);

            public SyntaxPiece parse() {
                while (this.parsingIterator.hasNext()) {
                    this.parsingIterator.next(this);
                }
                return SyntaxParser.concatenate(this.syntaxPieces);
            }

            @Override
            public void consumeChar(char chara, int index) {
                this.literalBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol, int index) {
                if (this.literalBuilder.length() > 0) {
                    this.syntaxPieces.add(new Literal(this.literalBuilder.toString()));
                    this.literalBuilder = new StringBuilder();
                }
                switch (symbol) {
                    case EXPRESSION_IDENTIFIER: {
                        this.syntaxPieces.add(SyntaxParser.parseExpression(this.parsingIterator));
                        break;
                    }
                    case VARYING_OPENER: 
                    case OPTIONAL_OPENER: {
                        this.syntaxPieces.add(SyntaxParser.parseVarying(this.parsingIterator, symbol == Symbol.OPTIONAL_OPENER));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal " + (Object)((Object)symbol) + " found, index = " + index);
                    }
                }
            }
        }.parse();
    }

    public static Expression parseExpression(final ParsingIterator parsingIterator) {
        String variable = new ParsingConsumer(){
            StringBuilder stringBuilder = new StringBuilder();
            boolean continu = true;

            public String extract() {
                while (parsingIterator.hasNext() && this.continu) {
                    parsingIterator.next(this);
                }
                if (this.continu) {
                    throw new IllegalArgumentException("Expression never terminated");
                }
                return this.stringBuilder.toString();
            }

            @Override
            public void consumeChar(char chara, int index) {
                this.stringBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol, int index) {
                if (symbol != Symbol.VARIABLE_IDENTIFIER) {
                    throw new IllegalArgumentException("VARIABLE_IDENTIFIER expected, found: " + (Object)((Object)symbol) + ", index = " + index);
                }
                this.continu = false;
            }
        }.extract();
        String exprInfo = new ParsingConsumer(){
            StringBuilder stringBuilder = new StringBuilder();
            boolean continu = true;

            public String extract() {
                while (parsingIterator.hasNext() && this.continu) {
                    parsingIterator.next(this);
                }
                if (this.continu) {
                    throw new IllegalArgumentException("Expression never terminated");
                }
                return this.stringBuilder.toString();
            }

            @Override
            public void consumeChar(char chara, int index) {
                this.stringBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol, int index) {
                if (symbol != Symbol.EXPRESSION_IDENTIFIER) {
                    throw new IllegalArgumentException("EXPRESSION_IDENTIFIER exptected, found: " + (Object)((Object)symbol) + ", index = " + index);
                }
                this.continu = false;
            }
        }.extract();
        return new Expression(variable, exprInfo);
    }

    public static Varying parseVarying(final ParsingIterator parsingIterator, final boolean optional) {
        return new ParsingConsumer(){
            List<SyntaxPiece> options = new LinkedList<SyntaxPiece>();
            List<SyntaxPiece> syntaxPieces = new LinkedList<SyntaxPiece>();
            StringBuilder literalBuilder = new StringBuilder();
            Optional<String> variable = Optional.empty();
            boolean continu = true;

            public Varying parse() {
                while (parsingIterator.hasNext() && this.continu) {
                    parsingIterator.next(this);
                }
                if (this.continu) {
                    throw new IllegalArgumentException("Varying never terminated");
                }
                if (optional) {
                    this.options.add(0, Literal.EMPTY);
                }
                return new Varying((ImmutableList<SyntaxPiece>)ImmutableList.copyOf(this.options), this.variable);
            }

            @Override
            public void consumeChar(char chara, int index) {
                this.literalBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol, int index) {
                if (this.literalBuilder.length() > 0 && symbol != Symbol.VARIABLE_IDENTIFIER) {
                    this.syntaxPieces.add(new Literal(this.literalBuilder.toString()));
                    this.literalBuilder = new StringBuilder();
                }
                switch (symbol) {
                    case EXPRESSION_IDENTIFIER: {
                        this.syntaxPieces.add(SyntaxParser.parseExpression(parsingIterator));
                        break;
                    }
                    case VARYING_OPENER: 
                    case OPTIONAL_OPENER: {
                        this.syntaxPieces.add(SyntaxParser.parseVarying(parsingIterator, symbol == Symbol.OPTIONAL_OPENER));
                        break;
                    }
                    case VARIABLE_IDENTIFIER: {
                        if (this.variable.isPresent() || !this.syntaxPieces.isEmpty() || !this.options.isEmpty()) {
                            throw new IllegalArgumentException("Illegal " + (Object)((Object)symbol) + " found, index = " + index);
                        }
                        this.variable = Optional.of(this.literalBuilder.toString());
                        this.literalBuilder = new StringBuilder();
                        break;
                    }
                    case VARYING_SEPARATOR: {
                        this.options.add(SyntaxParser.concatenate(this.syntaxPieces));
                        this.syntaxPieces = new LinkedList<SyntaxPiece>();
                        break;
                    }
                    default: {
                        this.options.add(SyntaxParser.concatenate(this.syntaxPieces));
                        if (symbol == Symbol.OPTIONAL_CLOSER == optional) {
                            this.continu = false;
                            break;
                        }
                        throw new IllegalArgumentException("Illegal closer: " + (Object)((Object)symbol) + ", index = " + index);
                    }
                }
            }
        }.parse();
    }

    public static interface ParsingConsumer {
        public void consumeChar(char var1, int var2);

        public void consumeSymbol(Symbol var1, int var2);
    }

    public static class ParsingIterator {
        private final String string;
        private int nextIndex = 0;

        public ParsingIterator(String string) {
            this.string = string;
        }

        public boolean hasNext() {
            return this.nextIndex < this.string.length();
        }

        public void next(ParsingConsumer consumer) {
            if (this.string.charAt(this.nextIndex) == '\\') {
                this.nextIndex += 2;
                consumer.consumeChar(this.string.charAt(this.nextIndex - 1), this.nextIndex - 1);
            } else {
                ++this.nextIndex;
                Optional<Symbol> symbolOptional = Symbol.fromChar(this.string.charAt(this.nextIndex - 1));
                if (symbolOptional.isPresent()) {
                    consumer.consumeSymbol(symbolOptional.get(), this.nextIndex - 1);
                } else {
                    consumer.consumeChar(this.string.charAt(this.nextIndex - 1), this.nextIndex - 1);
                }
            }
        }
    }

    public static enum Symbol {
        VARIABLE_IDENTIFIER('='),
        EXPRESSION_IDENTIFIER('%'),
        VARYING_OPENER('('),
        VARYING_CLOSER(')'),
        VARYING_SEPARATOR('|'),
        OPTIONAL_OPENER('['),
        OPTIONAL_CLOSER(']');

        public final char chara;

        private Symbol(char chara) {
            this.chara = chara;
        }

        public static Optional<Symbol> fromChar(char chara) {
            for (Symbol symbol : Symbol.values()) {
                if (symbol.chara != chara) continue;
                return Optional.of(symbol);
            }
            return Optional.empty();
        }
    }
}

