/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.mundosyntax;

import us.tlatoani.webskt.mundosyntax.ExpressionConstraints;
import us.tlatoani.webskt.mundosyntax.SyntaxPiece;
import us.tlatoani.webskt.mundosyntax.VariableCollective;
import us.tlatoani.webskt.mundosyntax.VariableUsage;

public class Expression
extends SyntaxPiece {
    public final String variable;
    public final ExpressionConstraints constraints;

    public Expression(String variable, String exprInfo) {
        this.variable = variable;
        this.constraints = ExpressionConstraints.fromSyntax(exprInfo);
    }

    @Override
    public boolean containsVariables() {
        return true;
    }

    @Override
    public VariableUsage getVariableUsage(String variable) {
        return this.variable.equals(variable) ? (this.constraints.nullable ? VariableUsage.SPECIFIC : VariableUsage.CONSISTENT) : VariableUsage.NONE;
    }

    @Override
    public int markLength() {
        return 0;
    }

    @Override
    public int expressionAmount() {
        return 1;
    }

    @Override
    public void addVariables(VariableCollective collective) {
        collective.addExpression(this.variable, this.constraints);
    }

    @Override
    public String readableSyntax() {
        return "%" + this.constraints.getTypeOptions() + "%";
    }

    @Override
    public String actualSyntax(int prevMarkLength) {
        return "%" + this.constraints.getSyntax() + "%";
    }

    @Override
    public String originalSyntax() {
        return "%" + this.variable + "=" + this.constraints.getSyntax() + "%";
    }

    @Override
    public void setInformation(SyntaxPiece.MarkSpecificInformation information, int mark, int prevExprAmount) {
        information.exprIndexes.put(this.variable, prevExprAmount);
    }

    @Override
    public String toString(int mark) {
        return "%" + this.variable + "%";
    }

    @Override
    public String toString() {
        return "Expression(\"" + this.variable + "\", \"" + this.constraints + "\")";
    }
}

