/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.core.reflective_registration;

import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SyntaxElementInfo;
import us.tlatoani.webskt.core.reflection.Reflection;
import us.tlatoani.webskt.core.reflective_registration.ReflectiveRegistration;

public abstract class ModifiableSyntaxElementInfo<I extends SyntaxElementInfo> {
    public static final Reflection.FieldAccessor<String[]> PATTERNS_FIELD = Reflection.getField(SyntaxElementInfo.class, "patterns", String[].class);
    public static final Reflection.ConstructorInvoker SYNTAX_ELEMENT_INFO_INIT;
    public static final Reflection.ConstructorInvoker EXPRESSION_INFO_INIT;
    public static final boolean usesNewConstructor;
    public final I syntaxElementInfo;

    private ModifiableSyntaxElementInfo(I syntaxElementInfo) {
        this.syntaxElementInfo = syntaxElementInfo;
    }

    public String[] getPatterns() {
        return ((SyntaxElementInfo)this.syntaxElementInfo).patterns;
    }

    public void setPatterns(String ... patterns) {
        if (((SyntaxElementInfo)this.syntaxElementInfo).patterns.length == patterns.length) {
            for (int i = 0; i < patterns.length; ++i) {
                ((SyntaxElementInfo)this.syntaxElementInfo).patterns[i] = patterns[i];
            }
        } else {
            PATTERNS_FIELD.set(this.syntaxElementInfo, patterns);
        }
    }

    public static SyntaxElementInfo createSyntaxElementInfo(String[] patterns, Class c) {
        if (usesNewConstructor) {
            return (SyntaxElementInfo)SYNTAX_ELEMENT_INFO_INIT.invoke(patterns, c, "MUNDOSK_MODIFIABLE_SYNTAX_ELEMENT_INFO");
        }
        return (SyntaxElementInfo)SYNTAX_ELEMENT_INFO_INIT.invoke(patterns, c);
    }

    public static ExpressionInfo createExpressionInfo(String[] patterns, Class returnType, Class expressionClass) {
        if (usesNewConstructor) {
            return (ExpressionInfo)EXPRESSION_INFO_INIT.invoke(patterns, returnType, expressionClass, "MUNDOSK_MODIFIABLE_EXPRESSION_INFO");
        }
        return (ExpressionInfo)EXPRESSION_INFO_INIT.invoke(patterns, returnType, expressionClass);
    }

    public void addPattern(String pattern) {
        String[] newPatterns = new String[this.getPatterns().length + 1];
        System.arraycopy(this.getPatterns(), 0, newPatterns, 0, this.getPatterns().length);
        newPatterns[this.getPatterns().length] = pattern;
        this.setPatterns(newPatterns);
    }

    public void addPatterns(String ... patterns) {
        String[] newPatterns = new String[this.getPatterns().length + patterns.length];
        System.arraycopy(this.getPatterns(), 0, newPatterns, 0, this.getPatterns().length);
        System.arraycopy(patterns, 0, newPatterns, this.getPatterns().length, patterns.length);
        this.setPatterns(newPatterns);
    }

    public abstract void register();

    /* synthetic */ ModifiableSyntaxElementInfo(SyntaxElementInfo x0, 1 x1) {
        this(x0);
    }

    static {
        Reflection.ConstructorInvoker syntaxElementInfoInit = null;
        try {
            syntaxElementInfoInit = Reflection.getConstructor(SyntaxElementInfo.class, String[].class, Class.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (syntaxElementInfoInit == null) {
            SYNTAX_ELEMENT_INFO_INIT = Reflection.getConstructor(SyntaxElementInfo.class, String[].class, Class.class, String.class);
            EXPRESSION_INFO_INIT = Reflection.getConstructor(ExpressionInfo.class, String[].class, Class.class, Class.class, String.class);
            usesNewConstructor = true;
        } else {
            SYNTAX_ELEMENT_INFO_INIT = syntaxElementInfoInit;
            EXPRESSION_INFO_INIT = Reflection.getConstructor(ExpressionInfo.class, String[].class, Class.class, Class.class);
            usesNewConstructor = false;
        }
    }

    public static class Expression<E extends ch.njol.skript.lang.Expression<T>, T>
    extends ModifiableSyntaxElementInfo<ExpressionInfo<E, T>> {
        public final ExpressionType expressionType;

        public Expression(Class<E> expressionClass, Class<T> returnType, ExpressionType expressionType, String ... patterns) {
            super((SyntaxElementInfo)Expression.createExpressionInfo(patterns, returnType, expressionClass), null);
            this.expressionType = expressionType;
        }

        @Override
        public void register() {
            ReflectiveRegistration.registerExpression((ExpressionInfo)this.syntaxElementInfo, this.expressionType);
        }
    }

    public static class Condition<C extends ch.njol.skript.lang.Condition>
    extends ModifiableSyntaxElementInfo<SyntaxElementInfo<C>> {
        public Condition(Class<C> conditionClass, String ... patterns) {
            super(Condition.createSyntaxElementInfo(patterns, conditionClass), null);
        }

        @Override
        public void register() {
            ReflectiveRegistration.registerCondition((SyntaxElementInfo<? extends ch.njol.skript.lang.Condition>)this.syntaxElementInfo);
        }
    }

    public static class Effect<E extends ch.njol.skript.lang.Effect>
    extends ModifiableSyntaxElementInfo<SyntaxElementInfo<E>> {
        public Effect(Class<E> effectClass, String ... patterns) {
            super(Effect.createSyntaxElementInfo(patterns, effectClass), null);
        }

        @Override
        public void register() {
            ReflectiveRegistration.registerEffect((SyntaxElementInfo<? extends ch.njol.skript.lang.Effect>)this.syntaxElementInfo);
        }
    }
}

